/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.request;

import com.digiwin.dap.middleware.domain.AbstractConverter;
import com.digiwin.dap.middleware.omc.constant.enums.TossStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.domain.PackGoodsVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.remote.CloudDeviceInitVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.request.ContractVO;
import com.digiwin.dap.middleware.omc.domain.request.InvoiceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCouponVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPromotionMixVO;
import com.digiwin.dap.middleware.omc.domain.request.PaymentVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.support.serializer.UTCDateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

public class OrderVO
extends AbstractConverter<Order> {
    private Long sid;
    private String orderCode;
    private Integer orderStatus = 0;
    private Integer orderType = 1;
    private Boolean valid = true;
    private String orderSource = OrderSourceEnum.DigiwinCloud.name();
    private BigDecimal taxRate;
    private BigDecimal noTaxPrice = BigDecimal.ZERO;
    private BigDecimal taxPrice = BigDecimal.ZERO;
    private BigDecimal containTaxPrice = BigDecimal.ZERO;
    private BigDecimal totalPrice = BigDecimal.ZERO;
    private BigDecimal payPrice = BigDecimal.ZERO;
    private BigDecimal profitShare;
    private BigDecimal discountPrice = BigDecimal.ZERO;
    private Long tenantSid;
    @NotBlank(message="\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a") String tenantId;
    private String tenantName;
    private String teamId;
    private String teamName;
    private String customerId;
    private String potentialCustomerId;
    private Long userSid;
    @NotBlank(message="\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a") String userId;
    private String userName;
    private String email;
    private String telephone;
    private String departCode;
    private String businessCode;
    private String recommendedCode;
    private String recommendedItCode;
    private String recommendedItName;
    private String recommendedDepartCode;
    private Integer userNumber;
    private Integer originUserNumber;
    private String tossStatus = TossStatusEnum.N.name();
    private LocalDateTime tossDate;
    private String tossFail;
    private String dgwFacOrderCode;
    private String dgwFacContractCode;
    private Integer enterprise = 1;
    private Boolean checkBill = false;
    private Boolean shareAchievement = false;
    private Boolean useRecommendedCoupon = false;
    private String remark;
    private String comment;
    private String categoryId;
    private String categoryName;
    private String goodsCode;
    private Boolean authorization = false;
    private Integer initialize = 0;
    private Boolean needInit;
    @JsonProperty(value="createTime")
    private LocalDateTime createDate;
    private String createById;
    @NotEmpty(message="\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a") List<OrderDetailVO> orderDetails = new ArrayList();
    private List<OrderCouponVO> orderCoupons = new ArrayList();
    private InvoiceVO invoice;
    private PaymentVO payment;
    private PaymentVO refund;
    private ContractVO contract;
    private BnplOrderVO bnpl;
    private Goods goods;
    private Boolean testTenant = false;
    private LocalDateTime shipmentStartDate;
    private LocalDateTime shipmentEndDate;
    private LocalDateTime authorizationDate;
    private Integer payCount = 0;
    private String cartCode;
    private String packCode;
    private Long packSid;
    private Integer shopping = 0;
    private Boolean school = false;
    private OrderPromotionMixVO orderPromotionMixVO;
    private PackGoodsVO pack;
    private Boolean ifCustomFormData;
    @JsonIgnore
    private Boolean customFormData;
    private Boolean servicer = false;
    private boolean accountConfirm = false;
    private LocalDate accountConfirmDate;
    private String code;
    private String account;
    private Boolean shouldAuthUser;
    private boolean creditAutoRenew;
    private Integer renewPeriods;
    private String periodType;
    private String periodNo;
    private LocalDateTime firstAuthDate;
    private BigDecimal periodAmount;
    private String merchantOrderNo;
    private boolean periodSubOrder;
    private String priceCalculate;
    private boolean accessoryFlag;
    private String accessoryOf;
    private Boolean retryInit;
    private List<CloudDeviceInitVO> cloudDevices;
    private List<OrderDetailVO> packOrderDetails;
    private String useTenantId;
    private String useTenantName;
    private String batchCode;
    private LocalDateTime expireTime;
    private String credentialFileId;

    public boolean isPackOrder() {
        return this.getShopping() == 2;
    }

    public static OrderVO orderToVO(Order order) {
        OrderVO orderVO = new OrderVO();
        orderVO.doBackward((Object)order);
        return orderVO;
    }

    public String getPriceCalculate() {
        return this.priceCalculate;
    }

    public void setPriceCalculate(String priceCalculate) {
        this.priceCalculate = priceCalculate;
    }

    @JsonSerialize(using=UTCDateTimeSerializer.class)
    public LocalDateTime getCreateTimeUTC() {
        return this.createDate;
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getOrderType() {
        return this.orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNoTaxPrice() {
        return this.noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public BigDecimal getTaxPrice() {
        return this.taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getContainTaxPrice() {
        return this.containTaxPrice;
    }

    public void setContainTaxPrice(BigDecimal containTaxPrice) {
        this.containTaxPrice = containTaxPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getPayPrice() {
        return this.payPrice;
    }

    public void setPayPrice(BigDecimal payPrice) {
        this.payPrice = payPrice;
    }

    public BigDecimal getProfitShare() {
        return this.profitShare;
    }

    public void setProfitShare(BigDecimal profitShare) {
        this.profitShare = profitShare;
    }

    public BigDecimal getDiscountPrice() {
        return this.discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(Long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getDepartCode() {
        return this.departCode;
    }

    public void setDepartCode(String departCode) {
        this.departCode = departCode;
    }

    public String getBusinessCode() {
        return this.businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Integer getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Integer getOriginUserNumber() {
        return this.originUserNumber;
    }

    public void setOriginUserNumber(Integer originUserNumber) {
        this.originUserNumber = originUserNumber;
    }

    public String getTossStatus() {
        return this.tossStatus;
    }

    public void setTossStatus(String tossStatus) {
        this.tossStatus = tossStatus;
    }

    public LocalDateTime getTossDate() {
        return this.tossDate;
    }

    public void setTossDate(LocalDateTime tossDate) {
        this.tossDate = tossDate;
    }

    public String getTossFail() {
        return this.tossFail;
    }

    public void setTossFail(String tossFail) {
        this.tossFail = tossFail;
    }

    public String getDgwFacOrderCode() {
        return this.dgwFacOrderCode;
    }

    public void setDgwFacOrderCode(String dgwFacOrderCode) {
        this.dgwFacOrderCode = dgwFacOrderCode;
    }

    public String getDgwFacContractCode() {
        return this.dgwFacContractCode;
    }

    public void setDgwFacContractCode(String dgwFacContractCode) {
        this.dgwFacContractCode = dgwFacContractCode;
    }

    public Integer getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Integer enterprise) {
        this.enterprise = enterprise;
    }

    public Boolean getCheckBill() {
        return this.checkBill;
    }

    public void setCheckBill(Boolean checkBill) {
        this.checkBill = checkBill;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public Boolean getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Boolean authorization) {
        this.authorization = authorization;
    }

    public Integer getInitialize() {
        return this.initialize;
    }

    public void setInitialize(Integer initialize) {
        this.initialize = initialize;
    }

    public Boolean getNeedInit() {
        return this.needInit;
    }

    public void setNeedInit(Boolean needInit) {
        this.needInit = needInit;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public List<OrderDetailVO> getOrderDetails() {
        return this.orderDetails;
    }

    public void setOrderDetails(List<OrderDetailVO> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public List<OrderCouponVO> getOrderCoupons() {
        return this.orderCoupons;
    }

    public void setOrderCoupons(List<OrderCouponVO> orderCoupons) {
        this.orderCoupons = orderCoupons;
    }

    public InvoiceVO getInvoice() {
        return this.invoice;
    }

    public void setInvoice(InvoiceVO invoice) {
        this.invoice = invoice;
    }

    public PaymentVO getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentVO payment) {
        this.payment = payment;
    }

    public PaymentVO getRefund() {
        return this.refund;
    }

    public void setRefund(PaymentVO refund) {
        this.refund = refund;
    }

    public ContractVO getContract() {
        return this.contract;
    }

    public void setContract(ContractVO contract) {
        this.contract = contract;
    }

    public BnplOrderVO getBnpl() {
        return this.bnpl;
    }

    public void setBnpl(BnplOrderVO bnpl) {
        this.bnpl = bnpl;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    public String getRecommendedCode() {
        return this.recommendedCode;
    }

    public void setRecommendedCode(String recommendedCode) {
        this.recommendedCode = recommendedCode;
    }

    public String getRecommendedItName() {
        return this.recommendedItName;
    }

    public void setRecommendedItName(String recommendedItName) {
        this.recommendedItName = recommendedItName;
    }

    public String getRecommendedItCode() {
        return this.recommendedItCode;
    }

    public void setRecommendedItCode(String recommendedItCode) {
        this.recommendedItCode = recommendedItCode;
    }

    public String getRecommendedDepartCode() {
        return this.recommendedDepartCode;
    }

    public void setRecommendedDepartCode(String recommendedDepartCode) {
        this.recommendedDepartCode = recommendedDepartCode;
    }

    public Boolean getShareAchievement() {
        return this.shareAchievement;
    }

    public void setShareAchievement(Boolean shareAchievement) {
        this.shareAchievement = shareAchievement;
    }

    @JsonIgnore
    public OrderDetailVO getFirstOrderDetail() {
        if (this.orderDetails == null || this.orderDetails.isEmpty()) {
            return new OrderDetailVO();
        }
        return (OrderDetailVO)this.orderDetails.get(0);
    }

    public Boolean getTestTenant() {
        return this.testTenant;
    }

    public void setTestTenant(Boolean testTenant) {
        this.testTenant = testTenant;
    }

    public Boolean getUseRecommendedCoupon() {
        return this.useRecommendedCoupon;
    }

    public void setUseRecommendedCoupon(Boolean useRecommendedCoupon) {
        this.useRecommendedCoupon = useRecommendedCoupon;
    }

    public LocalDateTime getShipmentStartDate() {
        return this.shipmentStartDate;
    }

    public void setShipmentStartDate(LocalDateTime shipmentStartDate) {
        this.shipmentStartDate = shipmentStartDate;
    }

    public LocalDateTime getShipmentEndDate() {
        return this.shipmentEndDate;
    }

    public void setShipmentEndDate(LocalDateTime shipmentEndDate) {
        this.shipmentEndDate = shipmentEndDate;
    }

    public LocalDateTime getAuthorizationDate() {
        return this.authorizationDate;
    }

    public void setAuthorizationDate(LocalDateTime authorizationDate) {
        this.authorizationDate = authorizationDate;
    }

    public Integer getPayCount() {
        return this.payCount;
    }

    public void setPayCount(Integer payCount) {
        this.payCount = payCount;
    }

    public String getCartCode() {
        return this.cartCode;
    }

    public void setCartCode(String cartCode) {
        this.cartCode = cartCode;
    }

    public String getPackCode() {
        return this.packCode;
    }

    public void setPackCode(String packCode) {
        this.packCode = packCode;
    }

    public Long getPackSid() {
        return this.packSid;
    }

    public void setPackSid(Long packSid) {
        this.packSid = packSid;
    }

    public Integer getShopping() {
        return this.shopping;
    }

    public void setShopping(Integer shopping) {
        this.shopping = shopping;
    }

    public Boolean getSchool() {
        return this.school;
    }

    public void setSchool(Boolean school) {
        this.school = school;
    }

    public OrderPromotionMixVO getOrderPromotionMixVO() {
        return this.orderPromotionMixVO;
    }

    public void setOrderPromotionMixVO(OrderPromotionMixVO orderPromotionMixVO) {
        this.orderPromotionMixVO = orderPromotionMixVO;
    }

    public PackGoodsVO getPack() {
        return this.pack;
    }

    public void setPack(PackGoodsVO pack) {
        this.pack = pack;
    }

    public String getCreateById() {
        return this.createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public Boolean getIfCustomFormData() {
        return this.ifCustomFormData;
    }

    public void setIfCustomFormData(Boolean ifCustomFormData) {
        this.ifCustomFormData = ifCustomFormData;
    }

    public Boolean getCustomFormData() {
        return this.customFormData;
    }

    public void setCustomFormData(Boolean customFormData) {
        this.customFormData = customFormData;
    }

    public Boolean getServicer() {
        return this.servicer;
    }

    public void setServicer(Boolean servicer) {
        this.servicer = servicer;
    }

    public boolean isAccountConfirm() {
        return this.accountConfirm;
    }

    public void setAccountConfirm(boolean accountConfirm) {
        this.accountConfirm = accountConfirm;
    }

    public LocalDate getAccountConfirmDate() {
        return this.accountConfirmDate;
    }

    public void setAccountConfirmDate(LocalDate accountConfirmDate) {
        this.accountConfirmDate = accountConfirmDate;
    }

    public String generatePayCode() {
        if (this.payCount == 0) {
            return this.shopping != 0 ? this.cartCode : this.orderCode;
        }
        return this.shopping != 0 ? this.cartCode + "_" + this.payCount : this.orderCode + "_" + this.payCount;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPotentialCustomerId() {
        return this.potentialCustomerId;
    }

    public void setPotentialCustomerId(String potentialCustomerId) {
        this.potentialCustomerId = potentialCustomerId;
    }

    public Boolean getShouldAuthUser() {
        return this.shouldAuthUser;
    }

    public void setShouldAuthUser(Boolean shouldAuthUser) {
        this.shouldAuthUser = shouldAuthUser;
    }

    public boolean isCreditAutoRenew() {
        return this.creditAutoRenew;
    }

    public void setCreditAutoRenew(boolean creditAutoRenew) {
        this.creditAutoRenew = creditAutoRenew;
    }

    public Integer getRenewPeriods() {
        return this.renewPeriods;
    }

    public void setRenewPeriods(Integer renewPeriods) {
        this.renewPeriods = renewPeriods;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public String getPeriodNo() {
        return this.periodNo;
    }

    public void setPeriodNo(String periodNo) {
        this.periodNo = periodNo;
    }

    public LocalDateTime getFirstAuthDate() {
        return this.firstAuthDate;
    }

    public void setFirstAuthDate(LocalDateTime firstAuthDate) {
        this.firstAuthDate = firstAuthDate;
    }

    public BigDecimal getPeriodAmount() {
        return this.periodAmount;
    }

    public void setPeriodAmount(BigDecimal periodAmount) {
        this.periodAmount = periodAmount;
    }

    public String getMerchantOrderNo() {
        return this.merchantOrderNo;
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        this.merchantOrderNo = merchantOrderNo;
    }

    public boolean isPeriodSubOrder() {
        return this.periodSubOrder;
    }

    public void setPeriodSubOrder(boolean periodSubOrder) {
        this.periodSubOrder = periodSubOrder;
    }

    public boolean isAccessoryFlag() {
        return this.accessoryFlag;
    }

    public void setAccessoryFlag(boolean accessoryFlag) {
        this.accessoryFlag = accessoryFlag;
    }

    public String getAccessoryOf() {
        return this.accessoryOf;
    }

    public void setAccessoryOf(String accessoryOf) {
        this.accessoryOf = accessoryOf;
    }

    public boolean accessoryCart() {
        if (this.cartCode == null) {
            return false;
        }
        return this.cartCode.contains("MATCC") || this.cartCode.contains("MATCT");
    }

    public Boolean getRetryInit() {
        return this.retryInit;
    }

    public void setRetryInit(Boolean retryInit) {
        this.retryInit = retryInit;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String toString() {
        return this.shopping + ":" + this.orderCode + ":" + this.orderStatus;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public List<CloudDeviceInitVO> getCloudDevices() {
        return this.cloudDevices;
    }

    public void setCloudDevices(List<CloudDeviceInitVO> cloudDevices) {
        this.cloudDevices = cloudDevices;
    }

    public List<OrderDetailVO> getPackOrderDetails() {
        return this.packOrderDetails;
    }

    public void setPackOrderDetails(List<OrderDetailVO> packOrderDetails) {
        this.packOrderDetails = packOrderDetails;
    }

    public String getUseTenantId() {
        return this.useTenantId;
    }

    public void setUseTenantId(String useTenantId) {
        this.useTenantId = useTenantId;
    }

    public String getUseTenantName() {
        return this.useTenantName;
    }

    public void setUseTenantName(String useTenantName) {
        this.useTenantName = useTenantName;
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public String getCredentialFileId() {
        return this.credentialFileId;
    }

    public void setCredentialFileId(String credentialFileId) {
        this.credentialFileId = credentialFileId;
    }
}

