/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.request;

import com.digiwin.dap.middleware.domain.AbstractConverter;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsPaymentEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.response.AuthorizationModuleVO;
import com.digiwin.dap.middleware.omc.entity.PreOrderDetail;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.util.StringUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PreOrderDetailDTO
extends AbstractConverter<PreOrderDetail> {
    private Long sid;
    private Long orderSid;
    private Long goodsSid;
    private String goodsCode;
    private String goodsName;
    private String id;
    private String name;
    private String categoryId;
    private String itemId;
    private Long strategySid;
    private String strategyCode;
    private String strategyName;
    private Boolean mainStrategy;
    private Integer totalCountBound;
    private Integer userCountBound;
    private Integer totalUsageBound;
    private Integer remainUsageBound;
    private LocalDateTime effectiveDateTime;
    private LocalDateTime expiredDateTime;
    private List<AuthorizationModuleVO> modules;
    private Integer authorization;
    private Integer initialize;
    private String remark;
    private String packCode;
    private String packName;
    private String adminEmails;
    private Integer oldTotalUsageBound;
    private LocalDateTime oldEffectiveDateTime;
    private LocalDateTime oldExpiredDateTime;
    private List<AuthorizationModuleVO> oldModules;
    private List<CustomAttributeVO> customAttributes;
    private String bundleCode;
    private String bundleName;
    private Integer monthlyUsage;

    public PreOrderDetail doForward() {
        PreOrderDetail preOrderDetail = (PreOrderDetail)super.doForward();
        try {
            if (this.getModules() != null) {
                preOrderDetail.setModules(JsonUtils.createObjectMapper().writeValueAsString((Object)this.getModules()));
            }
            if (this.getOldModules() != null) {
                preOrderDetail.setOldModules(JsonUtils.createObjectMapper().writeValueAsString((Object)this.getOldModules()));
            }
            if (!CollectionUtils.isEmpty((Collection)this.getCustomAttributes())) {
                preOrderDetail.setCustomattributes(JsonUtils.objToJson((Object)this.getCustomAttributes()));
            }
        }
        catch (JsonProcessingException e) {
            throw new BusinessException("\u5546\u54c1\u6a21\u7ec4\u4fe1\u606f\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return preOrderDetail;
    }

    public PreOrderDetailDTO() {
    }

    public PreOrderDetailDTO(Goods goods, GoodsStrategy goodsStrategy, Boolean daplcdp) {
        try {
            this.categoryId = goods.getCategoryId();
            this.goodsCode = goods.getCode();
            this.goodsName = goods.getDisplayName();
            this.goodsSid = Long.valueOf(goods.getId());
            this.mainStrategy = true;
            this.strategyCode = goodsStrategy.getCode();
            this.strategySid = goodsStrategy.getId();
            this.strategyName = goodsStrategy.getName();
            this.totalUsageBound = Boolean.TRUE.equals(daplcdp) ? (GoodsPaymentEnum.PersonMonth.ordinal() != goods.getPaymentType().intValue() ? Integer.valueOf(-1) : Integer.valueOf(100)) : Integer.valueOf(5);
            this.effectiveDateTime = LocalDateTime.now().withNano(0);
            this.expiredDateTime = LocalDateTime.of(9999, 12, 31, 23, 59, 59);
            ObjectMapper objectMapper = JsonUtils.createObjectMapper();
            if (!StringUtil.isEmpty((String)goodsStrategy.getEnabledModulesStr())) {
                this.modules = (List)objectMapper.readValue(goodsStrategy.getEnabledModulesStr(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (this.modules != null) {
                    this.modules.forEach(m -> {
                        m.setEffectiveTime(LocalDateTime.now().withNano(0));
                        m.setExpiredTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                        if (Boolean.TRUE.equals(daplcdp)) {
                            m.setTotalUsage(-1);
                        } else {
                            m.setTotalUsage(5);
                        }
                    });
                }
            }
            this.authorization = PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue();
        }
        catch (Exception ex) {
            throw new BusinessException((Throwable)ex);
        }
    }

    public List<CustomAttributeVO> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttributeVO> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public Long getOrderSid() {
        return this.orderSid;
    }

    public void setOrderSid(Long orderSid) {
        this.orderSid = orderSid;
    }

    public Long getGoodsSid() {
        return this.goodsSid;
    }

    public void setGoodsSid(Long goodsSid) {
        this.goodsSid = goodsSid;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Long getStrategySid() {
        return this.strategySid;
    }

    public void setStrategySid(Long strategySid) {
        this.strategySid = strategySid;
    }

    public String getStrategyCode() {
        return this.strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Boolean getMainStrategy() {
        return this.mainStrategy;
    }

    public void setMainStrategy(Boolean mainStrategy) {
        this.mainStrategy = mainStrategy;
    }

    public Integer getTotalCountBound() {
        return this.totalCountBound;
    }

    public void setTotalCountBound(Integer totalCountBound) {
        this.totalCountBound = totalCountBound;
    }

    public Integer getUserCountBound() {
        return this.userCountBound;
    }

    public void setUserCountBound(Integer userCountBound) {
        this.userCountBound = userCountBound;
    }

    public Integer getTotalUsageBound() {
        return this.totalUsageBound;
    }

    public void setTotalUsageBound(Integer totalUsageBound) {
        this.totalUsageBound = totalUsageBound;
    }

    public Integer getRemainUsageBound() {
        return this.remainUsageBound;
    }

    public void setRemainUsageBound(Integer remainUsageBound) {
        this.remainUsageBound = remainUsageBound;
    }

    public LocalDateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public List<AuthorizationModuleVO> getModules() {
        return this.modules;
    }

    public void setModules(List<AuthorizationModuleVO> modules) {
        this.modules = modules;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPackCode() {
        return this.packCode;
    }

    public void setPackCode(String packCode) {
        this.packCode = packCode;
    }

    public String getPackName() {
        return this.packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Integer authorization) {
        this.authorization = authorization;
    }

    public String getAdminEmails() {
        return this.adminEmails;
    }

    public void setAdminEmails(String adminEmails) {
        this.adminEmails = adminEmails;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public Integer getInitialize() {
        return this.initialize;
    }

    public void setInitialize(Integer initialize) {
        this.initialize = initialize;
    }

    public Integer getOldTotalUsageBound() {
        return this.oldTotalUsageBound;
    }

    public void setOldTotalUsageBound(Integer oldTotalUsageBound) {
        this.oldTotalUsageBound = oldTotalUsageBound;
    }

    public LocalDateTime getOldEffectiveDateTime() {
        return this.oldEffectiveDateTime;
    }

    public void setOldEffectiveDateTime(LocalDateTime oldEffectiveDateTime) {
        this.oldEffectiveDateTime = oldEffectiveDateTime;
    }

    public LocalDateTime getOldExpiredDateTime() {
        return this.oldExpiredDateTime;
    }

    public void setOldExpiredDateTime(LocalDateTime oldExpiredDateTime) {
        this.oldExpiredDateTime = oldExpiredDateTime;
    }

    public List<AuthorizationModuleVO> getOldModules() {
        return this.oldModules;
    }

    public void setOldModules(List<AuthorizationModuleVO> oldModules) {
        this.oldModules = oldModules;
    }

    public String getBundleCode() {
        return this.bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public Integer getMonthlyUsage() {
        return this.monthlyUsage;
    }

    public void setMonthlyUsage(Integer monthlyUsage) {
        this.monthlyUsage = monthlyUsage;
    }
}

