/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.entity;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormContentVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="custom_form_cart", uniqueConstraints={@UniqueConstraint(name="uk_cartorderform_id_cartordersid_customformid", columnNames={"cart_order_sid", "id", "custom_form_id"})})
public class CustomFormCart
extends BaseEntity {
    @Column(name="cart_order_sid", columnDefinition="BIGINT(20) NOT NULL COMMENT '\u8d2d\u7269\u5355sid'")
    private Long cartOrderSid;
    @Column(name="id", columnDefinition="VARCHAR(50) NOT NULL COMMENT '\u81ea\u5b9a\u4e49\u8868\u5355\u5185\u5bb9id'")
    private String id;
    @Column(name="title", columnDefinition="VARCHAR(200) NULL DEFAULT NULL COMMENT '\u81ea\u5b9a\u4e49\u8868\u5355\u6807\u9898\u540d\u79f0'")
    private String title;
    @Column(name="value", columnDefinition="VARCHAR(500) NULL DEFAULT NULL COMMENT '\u95ee\u9898\u503c'")
    private String value;
    @Column(name="type", columnDefinition="INT(1) NULL DEFAULT '0' COMMENT '\u7c7b\u578b\uff080\uff1a\u6807\u9898\uff1b1\uff1a\u95ee\u9898\uff09'")
    private Integer type;
    @Column(name="custom_form_id", columnDefinition="VARCHAR(50) NOT NULL COMMENT '\u81ea\u5b9a\u4e49\u8868\u5355id'")
    private String customFormId;
    @Column(name="custom_form_name", columnDefinition="VARCHAR(200) NULL DEFAULT NULL COMMENT '\u81ea\u5b9a\u4e49\u8868\u5355\u540d\u79f0'")
    private String customFormName;
    @Column(name="default_value", columnDefinition="VARCHAR(512) NULL DEFAULT NULL COMMENT '\u9ed8\u8ba4\u503c'")
    private String defaultValue;
    @Column(name="value_type", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u503c\u7c7b\u578b'")
    private String valueType;
    @Column(name="value_parameter", columnDefinition="MEDIUMTEXT NULL COMMENT '\u503c\u9009\u62e9\u53c2\u6570'")
    private String valueParameter;
    @Column(name="sort_number", columnDefinition="BIGINT(20) NULL DEFAULT '0' COMMENT '\u6392\u5e8f\u5e8f\u53f7'")
    private Long sortNumber;
    @Column(name="mandatory", columnDefinition="BIT(1) NULL DEFAULT NULL COMMENT '\u662f\u5426\u5fc5\u586b'")
    private Boolean mandatory;
    @Column(name="reason", columnDefinition="VARCHAR(255) NULL DEFAULT NULL COMMENT '\u4fee\u6539\u539f\u56e0'")
    private String reason;
    @Column(name="remark", columnDefinition="VARCHAR(500) NULL DEFAULT NULL COMMENT '\u95ee\u9898\u5907\u6ce8'")
    private String remark;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public CustomFormCart() {
    }

    public CustomFormCart(long cartOrderSid, CustomFormVO customFormVO, CustomFormContentVO content) {
        this.cartOrderSid = cartOrderSid;
        this.customFormId = customFormVO.getId();
        this.customFormName = customFormVO.getName();
        this.id = StrUtils.isEmpty((String)content.getId()) ? SnowFlake.getInstance().newId() + "" : content.getId();
        this.title = content.getTitle();
        this.value = content.getValue();
        this.type = content.getType();
        this.defaultValue = content.getDefaultValue();
        this.valueType = content.getValueType();
        try {
            this.valueParameter = objectMapper.writeValueAsString((Object)content.getValueParameter());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        this.sortNumber = content.getSortNumber();
        this.mandatory = content.getMandatory();
        this.reason = content.getReason();
        this.remark = content.getRemark();
    }

    public Long getCartOrderSid() {
        return this.cartOrderSid;
    }

    public void setCartOrderSid(Long cartOrderSid) {
        this.cartOrderSid = cartOrderSid;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCustomFormId() {
        return this.customFormId;
    }

    public void setCustomFormId(String customFormId) {
        this.customFormId = customFormId;
    }

    public String getCustomFormName() {
        return this.customFormName;
    }

    public void setCustomFormName(String customFormName) {
        this.customFormName = customFormName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueParameter() {
        return this.valueParameter;
    }

    public void setValueParameter(String valueParameter) {
        this.valueParameter = valueParameter;
    }

    public Long getSortNumber() {
        return this.sortNumber;
    }

    public void setSortNumber(Long sortNumber) {
        this.sortNumber = sortNumber;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

