/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="`order`", uniqueConstraints={@UniqueConstraint(name="uk_order_ordercode", columnNames={"ordercode"})})
public class Order
extends BaseEntity
implements Cloneable {
    @Column(name="ordercode", columnDefinition="VARCHAR(32) NULL DEFAULT NULL COMMENT '\u8ba2\u5355\u7f16\u53f7'")
    private String orderCode;
    @Column(name="order_status", columnDefinition="INT(1) NOT NULL DEFAULT 0 COMMENT '\u8ba2\u5355\u72b6\u6001\uff080.\u5f85\u4ed8\u6b3e 1.\u5df2\u4ed8\u6b3e 2.\u5df2\u9000\u6b3e\uff09'")
    private Integer orderStatus;
    @Column(name="order_type", columnDefinition="INT(1) NOT NULL DEFAULT 1 COMMENT '\u8ba2\u5355\u7c7b\u578b\uff081.\u65b0\u8d2d 2.\u7eed\u8d2d 3.\u52a0\u8d2d\u4eba\u6570\uff09'")
    private Integer orderType;
    @Column(name="valid", columnDefinition="BIT(1) NOT NULL DEFAULT 1 COMMENT '\u662f\u5426\u6709\u6548'")
    private boolean valid;
    @Column(name="ordersource", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u8ba2\u5355\u6765\u6e90'")
    private String orderSource;
    @Column(name="area", columnDefinition="VARCHAR(100) NULL DEFAULT NULL COMMENT '\u533a\u57df'")
    private String area;
    @Column(name="taxrate", columnDefinition="DECIMAL(14,4) NULL DEFAULT '0.0000' COMMENT '\u7a0e\u7387\u767e\u5206\u6bd4'")
    private BigDecimal taxRate;
    @Column(name="notaxprice", columnDefinition="DECIMAL(14,4) NULL DEFAULT '0.0000' COMMENT '\u5e94\u4ed8\u672a\u7a0e\u91d1\u989d'")
    private BigDecimal noTaxPrice;
    @Column(name="taxprice", columnDefinition="DECIMAL(14,4) NULL DEFAULT '0.0000' COMMENT '\u5e94\u4ed8\u7a0e\u989d'")
    private BigDecimal taxPrice;
    @Column(name="containtaxprice", columnDefinition="DECIMAL(14,4) NULL DEFAULT '0.0000' COMMENT '\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d'")
    private BigDecimal containTaxPrice;
    @Column(name="totalprice", columnDefinition="DECIMAL(12,2) NULL DEFAULT '0.00' COMMENT '\u8ba2\u5355\u603b\u4ef7'")
    private BigDecimal totalPrice;
    @Column(name="payprice", columnDefinition="DECIMAL(12,2) NULL DEFAULT '0.00' COMMENT '\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u603b\u4ef7'")
    private BigDecimal payPrice;
    @Column(name="profit_share", columnDefinition="DECIMAL(12,2) NULL DEFAULT '0.00' COMMENT '\u5206\u6da6'")
    private BigDecimal profitShare;
    @Column(name="discount_price", columnDefinition="DECIMAL(14,4) NULL DEFAULT '0.0000' COMMENT '\u4f18\u60e0\u603b\u4ef7'")
    private BigDecimal discountPrice;
    @Column(name="tenant_sid", columnDefinition="BIGINT(20) NULL DEFAULT NULL COMMENT '\u79df\u6237sid'")
    private Long tenantSid;
    @Column(name="tenantid", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u79df\u6237id'")
    private String tenantId;
    @Column(name="tenantname", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u79df\u6237\u540d\u79f0'")
    private String tenantName;
    @Column(name="customer_id", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u5ba2\u670d\u4ee3\u53f7'")
    private String customerId;
    @Column(name="userid", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u7528\u6237id'")
    private String userId;
    @Column(name="username", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u7528\u6237\u540d\u79f0'")
    private String userName;
    @Column(name="email", columnDefinition="VARCHAR(40) NULL DEFAULT NULL COMMENT '\u7528\u6237\u90ae\u7bb1'")
    private String email;
    @Column(name="telephone", columnDefinition="VARCHAR(20) NULL DEFAULT NULL COMMENT '\u7528\u6237\u7535\u8bdd'")
    private String telephone;
    @Column(name="depart_code", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u90e8\u95e8\u4ee3\u53f7'")
    private String departCode;
    @Column(name="business_code", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u4e1a\u52a1\u5458itcode'")
    private String businessCode;
    @Column(name="payment_sid", columnDefinition="BIGINT(20) NULL DEFAULT NULL COMMENT '\u652f\u4ed8sid'")
    private Long paymentSid;
    @Column(name="invoice_sid", columnDefinition="BIGINT(20) NULL DEFAULT NULL COMMENT '\u53d1\u7968sid'")
    private Long invoiceSid;
    @Column(name="contract_sid", columnDefinition="BIGINT(20) NULL DEFAULT NULL COMMENT '\u5408\u540csid'")
    private Long contractSid;
    @Column(name="usernumber", columnDefinition="INT(11) NULL DEFAULT '0' COMMENT '\u8ba2\u5355\u7528\u6237\u6570'")
    private Integer userNumber;
    @Column(name="origin_user_number", columnDefinition="INT(11) NULL DEFAULT '0' COMMENT '\u539f\u6709\u7528\u6237\u6570\u91cf'")
    private Integer originUserNumber;
    @Column(name="tossstatus", columnDefinition="VARCHAR(1) NOT NULL DEFAULT 'N' COMMENT '\u8ba2\u5355\u629b\u8f6c'")
    private String tossStatus = "N";
    @Column(name="toss_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u629b\u8f6c\u65f6\u95f4'")
    private LocalDateTime tossDate;
    @Column(name="dgwfacordercode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT 'TT\u8ba2\u5355\u53f7'")
    private String dgwFacOrderCode;
    @Column(name="dgwfaccontractcode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u5408\u540c\u53f7'")
    private String dgwFacContractCode;
    @Column(name="enterprise", columnDefinition="BIT(1) NOT NULL DEFAULT 0 COMMENT '\u4f01\u4e1a\u7c7b\u578b\uff0c0-\u4e2a\u4eba\u79df\u6237\uff0c1-\u4f01\u4e1a\u79df\u6237\uff0c2-\u4e2a\u4eba\u5f00\u53d1\u5546\uff0c3-\u4f01\u4e1a\u5f00\u53d1\u5546'")
    private Integer enterprise;
    @Column(name="checkbill", columnDefinition="BIT(1) NOT NULL DEFAULT 0 COMMENT '\u662f\u5426\u5bf9\u8d26'")
    private boolean checkBill;
    @Column(name="remark", columnDefinition="VARCHAR(255) NULL DEFAULT NULL COMMENT '\u5907\u6ce8'")
    private String remark;
    @Column(name="categoryid", columnDefinition="VARCHAR(10) NULL DEFAULT NULL COMMENT '\u5546\u54c1\u5206\u7c7b'")
    private String categoryId;
    @Column(name="goodscode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u5546\u54c1\u7f16\u53f7'")
    private String goodsCode;
    @Column(name="authorization", columnDefinition="BIT(1) NOT NULL DEFAULT 0 COMMENT '\u662f\u5426\u6388\u6743'")
    private boolean authorization;
    @Column(name="initialize", columnDefinition="TINYINT NULL DEFAULT 0 COMMENT '0.\u672a\u521d\u59cb\u5316\uff0c1.\u521d\u59cb\u5316\u6210\u529f\uff0c2.\u521d\u59cb\u5316\u5931\u8d25'")
    private Integer initialize;
    @Column(name="comment", columnDefinition="VARCHAR(400) NULL DEFAULT NULL COMMENT '\u8ba2\u5355\u8bf4\u660e\u5907\u6ce8'")
    private String comment;
    @Column(name="recommended_code", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u63a8\u8350\u7801'")
    private String recommendedCode;
    @Column(name="recommended_it_code", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u63a8\u8350\u4eba\u5de5\u53f7'")
    private String recommendedItCode;
    @Column(name="recommended_it_name", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u63a8\u8350\u4eba\u59d3\u540d'")
    private String recommendedItName;
    @Column(name="recommended_depart_code", columnDefinition="VARCHAR(50) NULL DEFAULT NULL COMMENT '\u63a8\u8350\u4eba\u90e8\u95e8'")
    private String recommendedDepartCode;
    @Column(name="test_tenant", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u6d4b\u8bd5\u79df\u6237'")
    private boolean testTenant;
    @Column(name="shipment_start_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u51fa\u8d27\u8d77\u59cb\u65e5'")
    private LocalDateTime shipmentStartDate;
    @Column(name="shipment_end_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u51fa\u8d27\u7ed3\u675f\u65e5'")
    private LocalDateTime shipmentEndDate;
    @Column(name="authorization_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u9884\u8ba1\u5f00\u901a\u65e5'")
    private LocalDateTime authorizationDate;
    @Column(name="pay_count", columnDefinition="INT(11) NULL DEFAULT '0' COMMENT '\u652f\u4ed8\u6b21\u6570'")
    private Integer payCount;
    @Column(name="cart_code", columnDefinition="VARCHAR(32) NULL DEFAULT NULL COMMENT '\u8d2d\u7269\u5355\u53f7'")
    private String cartCode;
    @Column(name="shopping", columnDefinition="INT(11) NULL DEFAULT '0' COMMENT '0.\u4e00\u822c\u8ba2\u5355\uff0c1.\u8d2d\u7269\u8ba2\u5355\uff0c2.\u7ec4\u5408\u8ba2\u5355'")
    private Integer shopping;
    @Column(name="school", columnDefinition="BIT(1) NOT NULL DEFAULT 0 COMMENT '\u662f\u5426\u9662\u6821\u5ba2\u6237'")
    private boolean school;
    @Column(name="pack_code", columnDefinition="VARCHAR(32) NULL DEFAULT NULL COMMENT '\u7ec4\u5408\u8ba2\u5355\u53f7'")
    private String packCode;
    @Column(name="pack_sid", columnDefinition="BIGINT(20) NOT NULL DEFAULT '0' COMMENT '\u7ec4\u5408\u5546\u54c1sid'")
    private Long packSid;
    @Column(name="account_confirm", columnDefinition="BIT(1) NOT NULL DEFAULT 0 COMMENT '\u5e10\u52a1\u786e\u8ba4'")
    private boolean accountConfirm;
    @Column(name="account_confirm_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u5e10\u52a1\u786e\u8ba4\u65e5\u671f'")
    private LocalDate accountConfirmDate;
    @Column(name="period_no", columnDefinition="VARCHAR(32) NULL DEFAULT NULL COMMENT '\u59d4\u6258\u5355\u53f7'")
    private String periodNo;
    @Column(name="merchant_order_no", columnDefinition="VARCHAR(64) NULL DEFAULT NULL COMMENT '\u5546\u5e97\u8ba2\u5355\u7f16\u53f7'")
    private String merchantOrderNo;
    @Column(name="use_tenant_id")
    private String useTenantId;
    @Column(name="use_tenant_name")
    private String useTenantName;
    @Column(name="batch_code", columnDefinition="varchar(40) DEFAULT NULL COMMENT '\u6388\u6743\u6279\u6b21\u53f7,\u4e0d\u80fd\u53ca\u65f6\u6388\u6743\u7684\u573a\u666f\u4f7f\u7528'")
    private String batchCode;
    @Column(name="credential_file_id")
    private String credentialFileId;

    public Integer getPayCount() {
        return this.payCount;
    }

    public void setPayCount(Integer payCount) {
        this.payCount = payCount;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getOrderType() {
        return this.orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNoTaxPrice() {
        return this.noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public BigDecimal getTaxPrice() {
        return this.taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getContainTaxPrice() {
        return this.containTaxPrice;
    }

    public void setContainTaxPrice(BigDecimal containTaxPrice) {
        this.containTaxPrice = containTaxPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getPayPrice() {
        return this.payPrice;
    }

    public void setPayPrice(BigDecimal payPrice) {
        this.payPrice = payPrice;
    }

    public BigDecimal getProfitShare() {
        return this.profitShare;
    }

    public void setProfitShare(BigDecimal profitShare) {
        this.profitShare = profitShare;
    }

    public BigDecimal getDiscountPrice() {
        return this.discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getDepartCode() {
        return this.departCode;
    }

    public void setDepartCode(String departCode) {
        this.departCode = departCode;
    }

    public String getBusinessCode() {
        return this.businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Long getPaymentSid() {
        return this.paymentSid;
    }

    public void setPaymentSid(Long paymentSid) {
        this.paymentSid = paymentSid;
    }

    public Long getInvoiceSid() {
        return this.invoiceSid;
    }

    public void setInvoiceSid(Long invoiceSid) {
        this.invoiceSid = invoiceSid;
    }

    public Long getContractSid() {
        return this.contractSid;
    }

    public void setContractSid(Long contractSid) {
        this.contractSid = contractSid;
    }

    public Integer getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Integer getOriginUserNumber() {
        return this.originUserNumber;
    }

    public void setOriginUserNumber(Integer originUserNumber) {
        this.originUserNumber = originUserNumber;
    }

    public String getTossStatus() {
        return this.tossStatus;
    }

    public void setTossStatus(String tossStatus) {
        this.tossStatus = tossStatus;
    }

    public LocalDateTime getTossDate() {
        return this.tossDate;
    }

    public void setTossDate(LocalDateTime tossDate) {
        this.tossDate = tossDate;
    }

    public String getDgwFacOrderCode() {
        return this.dgwFacOrderCode;
    }

    public void setDgwFacOrderCode(String dgwFacOrderCode) {
        this.dgwFacOrderCode = dgwFacOrderCode;
    }

    public String getDgwFacContractCode() {
        return this.dgwFacContractCode;
    }

    public void setDgwFacContractCode(String dgwFacContractCode) {
        this.dgwFacContractCode = dgwFacContractCode;
    }

    public Integer getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Integer enterprise) {
        this.enterprise = enterprise;
    }

    public boolean isCheckBill() {
        return this.checkBill;
    }

    public void setCheckBill(boolean checkBill) {
        this.checkBill = checkBill;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public boolean isAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(boolean authorization) {
        this.authorization = authorization;
    }

    public Integer getInitialize() {
        return this.initialize;
    }

    public void setInitialize(Integer initialize) {
        this.initialize = initialize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getRecommendedCode() {
        return this.recommendedCode;
    }

    public void setRecommendedCode(String recommendedCode) {
        this.recommendedCode = recommendedCode;
    }

    public String getRecommendedItName() {
        return this.recommendedItName;
    }

    public void setRecommendedItName(String recommendedItName) {
        this.recommendedItName = recommendedItName;
    }

    public String getRecommendedItCode() {
        return this.recommendedItCode;
    }

    public void setRecommendedItCode(String recommendedItCode) {
        this.recommendedItCode = recommendedItCode;
    }

    public String getRecommendedDepartCode() {
        return this.recommendedDepartCode;
    }

    public void setRecommendedDepartCode(String recommendedDepartCode) {
        this.recommendedDepartCode = recommendedDepartCode;
    }

    public boolean isTestTenant() {
        return this.testTenant;
    }

    public void setTestTenant(boolean testTenant) {
        this.testTenant = testTenant;
    }

    public LocalDateTime getShipmentStartDate() {
        return this.shipmentStartDate;
    }

    public void setShipmentStartDate(LocalDateTime shipmentStartDate) {
        this.shipmentStartDate = shipmentStartDate;
    }

    public LocalDateTime getShipmentEndDate() {
        return this.shipmentEndDate;
    }

    public void setShipmentEndDate(LocalDateTime shipmentEndDate) {
        this.shipmentEndDate = shipmentEndDate;
    }

    public LocalDateTime getAuthorizationDate() {
        return this.authorizationDate;
    }

    public void setAuthorizationDate(LocalDateTime authorizationDate) {
        this.authorizationDate = authorizationDate;
    }

    public String getCartCode() {
        return this.cartCode;
    }

    public void setCartCode(String cartCode) {
        this.cartCode = cartCode;
    }

    public Integer getShopping() {
        return this.shopping;
    }

    public void setShopping(Integer shopping) {
        this.shopping = shopping;
    }

    public boolean isSchool() {
        return this.school;
    }

    public void setSchool(boolean school) {
        this.school = school;
    }

    public String getPackCode() {
        return this.packCode;
    }

    public void setPackCode(String packCode) {
        this.packCode = packCode;
    }

    public Long getPackSid() {
        return this.packSid;
    }

    public void setPackSid(Long packSid) {
        this.packSid = packSid;
    }

    public boolean isAccountConfirm() {
        return this.accountConfirm;
    }

    public void setAccountConfirm(boolean accountConfirm) {
        this.accountConfirm = accountConfirm;
    }

    public LocalDate getAccountConfirmDate() {
        return this.accountConfirmDate;
    }

    public void setAccountConfirmDate(LocalDate accountConfirmDate) {
        this.accountConfirmDate = accountConfirmDate;
    }

    public String getPeriodNo() {
        return this.periodNo;
    }

    public void setPeriodNo(String periodNo) {
        this.periodNo = periodNo;
    }

    public String getMerchantOrderNo() {
        return this.merchantOrderNo;
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        this.merchantOrderNo = merchantOrderNo;
    }

    public String getUseTenantId() {
        return this.useTenantId;
    }

    public void setUseTenantId(String useTenantId) {
        this.useTenantId = useTenantId;
    }

    public String getUseTenantName() {
        return this.useTenantName;
    }

    public void setUseTenantName(String useTenantName) {
        this.useTenantName = useTenantName;
    }

    public String generatePayCode() {
        if (this.payCount == 0) {
            return this.shopping != 0 ? this.cartCode : this.orderCode;
        }
        return this.shopping != 0 ? this.cartCode + "_" + this.payCount : this.orderCode + "_" + this.payCount;
    }

    public Order clone() {
        try {
            return (Order)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public String getCredentialFileId() {
        return this.credentialFileId;
    }

    public void setCredentialFileId(String credentialFileId) {
        this.credentialFileId = credentialFileId;
    }
}

