/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.entity;

import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.domain.pay.TradeQueryResponse;
import com.digiwin.dap.middleware.omc.domain.remote.DwPayCallback;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Entity
@Table(name="payment", indexes={@Index(name="idx_payment_ordersid", columnList="order_sid")})
public class Payment
extends BaseEntity
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Payment.class);
    @Column(name="order_sid", columnDefinition="BIGINT(20) NOT NULL DEFAULT '0' COMMENT '\u8ba2\u5355sid'")
    private Long orderSid;
    @Column(name="paytype", columnDefinition="VARCHAR(20) NULL DEFAULT NULL COMMENT '\u4ed8\u6b3e\u7c7b\u578b'")
    private String payType;
    @Column(name="paymethod", columnDefinition="VARCHAR(20) NULL DEFAULT NULL COMMENT '\u4ed8\u6b3e\u65b9\u5f0f'")
    private String payMethod;
    @Column(name="pay_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u4ed8\u6b3e\u65f6\u95f4'")
    private LocalDateTime payDate;
    @Column(name="amount", columnDefinition="DECIMAL(12,2) NULL DEFAULT '0.00' NULL COMMENT '\u91d1\u989d'")
    private BigDecimal amount;
    @Column(name="paycode", columnDefinition="VARCHAR(50) NULL DEFAULT NULL NULL COMMENT '\u4ed8\u6b3e\u7f16\u53f7'")
    private String payCode;
    @Column(name="payaccount", columnDefinition="VARCHAR(50) NULL DEFAULT NULL NULL COMMENT '\u4ed8\u6b3e\u8d26\u53f7'")
    private String payAccount;
    @Column(name="tradestatus", columnDefinition="VARCHAR(20) NULL DEFAULT NULL NULL COMMENT '\u4ea4\u6613\u72b6\u6001'")
    private String tradeStatus;
    @Column(name="feerate", columnDefinition="DECIMAL(16,6) NULL DEFAULT '0.000000'")
    private BigDecimal feeRate;
    @Column(name="feeamount", columnDefinition=" DECIMAL(12,2) NULL DEFAULT '0.00'")
    private BigDecimal feeAmount;
    @Column(name="codeno", columnDefinition="VARCHAR(64) NULL DEFAULT NULL")
    private String codeNo;
    @Column(name="expire_date", columnDefinition="DATETIME NULL DEFAULT NULL COMMENT '\u7f34\u8d39\u671f\u9650'")
    private LocalDateTime expireDate;
    @Column(name="bank_no", columnDefinition="VARCHAR(20) NULL DEFAULT NULL COMMENT '\u94f6\u884c\u4ee3\u7801'")
    private String bankNo;
    @Column(name="bank_code", columnDefinition="VARCHAR(30) NULL DEFAULT NULL COMMENT '\u8f6c\u8d26\u5e10\u53f7'")
    private String bankCode;
    @Column(name="remark", columnDefinition="VARCHAR(255) NULL DEFAULT NULL COMMENT '\u5907\u6ce8'")
    private String remark;

    public Payment() {
    }

    public Payment(TradeQueryResponse tradeQuery) {
        this.tradeStatus = tradeQuery.getTrade_status().name();
        this.amount = new BigDecimal(tradeQuery.getTotal_amount());
        this.payType = tradeQuery.getPayment_channel();
        this.payCode = tradeQuery.getTrade_no();
        this.payAccount = tradeQuery.getBuyer_logon_id();
        this.feeAmount = tradeQuery.getFee_amount() == null ? new BigDecimal(0) : new BigDecimal(tradeQuery.getFee_amount());
        this.feeRate = tradeQuery.getFee_rate() == null ? new BigDecimal(0) : new BigDecimal(tradeQuery.getFee_rate());
        this.codeNo = tradeQuery.getCode_no();
        String string = this.payMethod = tradeQuery.getPayment_type() == null ? tradeQuery.getPayment_channel() : tradeQuery.getPayment_type();
        if (!"0000-00-00 00:00:00".equals(tradeQuery.getSend_pay_date())) {
            try {
                this.payDate = LocalDateTime.parse(tradeQuery.getSend_pay_date(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                logger.error(String.format("send_pay_date: %s", tradeQuery.getSend_pay_date()));
            }
        }
        if (!"0000-00-00 00:00:00".equals(tradeQuery.getExpire_date())) {
            try {
                this.expireDate = LocalDateTime.parse(tradeQuery.getExpire_date(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                logger.error(String.format("expire_date: %s", tradeQuery.getExpire_date()));
            }
        }
        if (null != tradeQuery.getCode_no()) {
            try {
                String codeNo = tradeQuery.getCode_no();
                this.bankNo = codeNo.substring(1, codeNo.indexOf(")"));
                this.bankCode = codeNo.substring(codeNo.indexOf(")") + 1);
            }
            catch (Exception e) {
                logger.error(String.format("code_no: %s", tradeQuery.getCode_no()));
            }
        }
    }

    public Payment(TradeInfo tradeQuery) {
        this.tradeStatus = tradeQuery.getTradeStatus();
        this.amount = tradeQuery.getTotalAmount();
        this.payType = tradeQuery.getPaymentType();
        this.payMethod = tradeQuery.getPayMethod();
        this.payDate = LocalDateTime.now();
    }

    public Payment(DwPayCallback payCallback) {
        this.tradeStatus = Boolean.TRUE.equals(payCallback.getAuthStatus()) ? TradeStatusEnum.TRADE_SUCCESS.name() : TradeStatusEnum.WAIT_BUYER_PAY.name();
        this.amount = payCallback.getTotalAmount();
        this.payType = payCallback.getPaymentType();
        this.payMethod = payCallback.getPaymentMethod();
        this.payCode = payCallback.getTradeNo();
        if (!ObjectUtils.isEmpty((Object)payCallback.getPayTime())) {
            try {
                this.payDate = LocalDateTime.parse(payCallback.getPayTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                logger.error(String.format("send_pay_date: %s", payCallback.getPayTime()));
            }
        }
        this.codeNo = payCallback.getCodeNo();
        if (!ObjectUtils.isEmpty((Object)this.codeNo)) {
            try {
                this.bankNo = this.codeNo.substring(1, this.codeNo.indexOf(")"));
                this.bankCode = this.codeNo.substring(this.codeNo.indexOf(")") + 1);
            }
            catch (Exception e) {
                logger.error(String.format("code_no: %s", this.codeNo));
            }
        }
    }

    public Long getOrderSid() {
        return this.orderSid;
    }

    public void setOrderSid(Long orderSid) {
        this.orderSid = orderSid;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPayMethod() {
        return this.payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public LocalDateTime getPayDate() {
        return this.payDate;
    }

    public void setPayDate(LocalDateTime payDate) {
        this.payDate = payDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getPayCode() {
        return this.payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public String getPayAccount() {
        return this.payAccount;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    public String getTradeStatus() {
        return this.tradeStatus;
    }

    public void setTradeStatus(String tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public BigDecimal getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(BigDecimal feeRate) {
        this.feeRate = feeRate;
    }

    public BigDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(BigDecimal feeAmount) {
        this.feeAmount = feeAmount;
    }

    public String getCodeNo() {
        return this.codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public LocalDateTime getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public String getBankNo() {
        return this.bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Payment clone() {
        try {
            Payment that = (Payment)super.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            logger.error(String.format("Payment\u5bf9\u8c61\u590d\u5236\u5931\u8d25: %s", e.getMessage()));
            throw new InternalError(e);
        }
    }
}

