/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.mapper;

import com.digiwin.dap.middleware.omc.domain.ShoppingCartOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.order.OrderDetailSimpleDO;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsToEnableMessageVO;
import com.digiwin.dap.middleware.omc.domain.request.OMBillSearchConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCFC;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.OMBillSearchResultVO;
import com.digiwin.dap.middleware.omc.domain.response.OrderDetailResult;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderMapper {
    public boolean existsByGoodsSid(@Param(value="goodsSid") long var1);

    public boolean existsByGoodsCode(@Param(value="goodsCode") String var1);

    public boolean existsByGoodsSidAndStrategySid(@Param(value="goodsSid") long var1, @Param(value="strategySid") long var3);

    public int countByStrategySid(@Param(value="strategySid") long var1);

    public int findQuantityByTenantIdAndStrategySid(@Param(value="tenantId") String var1, @Param(value="strategySid") long var2);

    public int countByTenantIdAndGoodsSidPaid(@Param(value="tenantId") String var1, @Param(value="goodsSid") long var2);

    public List<OrderVO> findOrders(@Param(value="orderCondition") OrderConditionVO var1, @Param(value="pageNum") int var2, @Param(value="pageSize") int var3, @Param(value="orderBy") String var4);

    public List<OrderVO> findOrdersWithoutPolicy(@Param(value="orderCondition") OrderConditionVO var1);

    public List<OrderVO> findTenantOrders(@Param(value="orderCondition") OrderConditionVO var1, @Param(value="pageNum") int var2, @Param(value="pageSize") int var3, @Param(value="orderBy") String var4);

    public List<OrderVO> findCartOrders(@Param(value="cartCode") String var1, @Param(value="shopping") boolean var2);

    public String findMaxOrderCode(@Param(value="orderCode") String var1);

    public List<Map> findGoodsItems(@Param(value="tenantId") String var1, @Param(value="goodsCode") String var2);

    public boolean existNoPaymentOrder(@Param(value="tenantSid") long var1, @Param(value="goodsSid") long var3);

    public Long existsDealerOrder(@Param(value="tenantSid") long var1, @Param(value="userId") String var3, @Param(value="goodsSid") long var4);

    public List<GoodsToEnableMessageVO> getGoodsToEnableMessageVO(LocalDate var1);

    public GoodsToEnableMessageVO getGoodsToEnableMessageVOByOrderCode(@Param(value="orderSid") long var1, @Param(value="searchTime") LocalDate var3);

    public ShoppingCartOrderDetailVO getShoppingCartOrderDetailVo(String var1);

    public List<OrderCFC> existCustomForm(@Param(value="orderSids") List<Long> var1);

    public List<OrderVO> findTenantSimpleOrders(@Param(value="tenantSid") Long var1);

    public void deleteInOrderSids(@Param(value="sids") List<Long> var1);

    public void deleteLogsInOrderSids(@Param(value="orderSids") List<Long> var1);

    public void deleteCouponInOrderSids(@Param(value="orderSids") List<Long> var1);

    public void deleteDeviceInOrderSids(@Param(value="orderSids") List<Long> var1);

    public OrderVO getBaseOrderByPeriodNo(@Param(value="periodNo") String var1);

    public List<OrderVO> findOrdersByOrderSids(@Param(value="orderSids") List<Long> var1);

    public void updateOrderTossstatus(@Param(value="orderSids") List<Long> var1, @Param(value="tossStatus") String var2);

    public List<OrderVO> findOrdersBackend(@Param(value="orderCondition") OrderConditionVO var1);

    public int findQuantityByTenantIdAndPackSid(@Param(value="tenantId") String var1, @Param(value="packSid") Long var2);

    public List<OMBillSearchResultVO> findBillOM(@Param(value="condition") OMBillSearchConditionVO var1);

    public List<OrderVO> findOrdersByCartCodeList(@Param(value="cartCodeList") List<String> var1);

    public List<OrderVO> findOrdersByOrderCodeList(@Param(value="orderCodeList") List<String> var1);

    public List<OrderVO> findOrdersByCondition(@Param(value="tenantSid") Long var1, @Param(value="startTime") String var2, @Param(value="endTime") String var3);

    public List<OrderDetailSimpleDO> listOrderDetails(@Param(value="orderType") Integer var1, @Param(value="orderStatusList") List<Integer> var2);

    public void deleteBNPLInOrderSids(@Param(value="orderSids") List<Long> var1);

    public List<OrderDetailResult> getUnTossOrders();

    public List<OrderDetailResult> getTossFailOrders();
}

