/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.bnpl.impl;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderGoodsVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.BnplOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BnplOrderQueryServiceImpl
implements BnplOrderQueryService {
    @Autowired
    private BnplOrderMapper bnplOrderMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;

    public BnplOrderVO findBySid(Long sid) {
        BnplOrderVO bnplOrder = this.bnplOrderMapper.selectBySid(sid);
        Order order = (Order)this.orderCrudService.findBySid(bnplOrder.getOrderSid().longValue());
        bnplOrder.setBills(this.bnplOrderMapper.findBnplOrderBill(order.getOrderCode()));
        List orderVOList = this.orderMapper.findOrdersByCartCodeList(Collections.singletonList(order.getCartCode()));
        List orderSidList = orderVOList.stream().filter(x -> Objects.equals(OrderShoppingEnum.COMMON.getCode(), x.getShopping())).map(OrderVO::getSid).collect(Collectors.toList());
        List orderDetailVOList = this.orderDetailMapper.findOrderDetails(orderSidList);
        List orderCloudDeviceVOList = null;
        if (!CollectionUtils.isEmpty(orderSidList)) {
            orderCloudDeviceVOList = this.orderCloudDeviceMapper.getCloudDeviceByOrderSids(orderSidList);
        }
        Map<Object, Object> cloudDeviceCodesMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)orderCloudDeviceVOList)) {
            cloudDeviceCodesMap = orderCloudDeviceVOList.stream().collect(Collectors.groupingBy(OrderCloudDeviceVO::getOrderSid, Collectors.mapping(OrderCloudDeviceVO::getCode, Collectors.toList())));
        }
        ArrayList<BnplOrderGoodsVO> bnplOrderGoodsVOList = new ArrayList<BnplOrderGoodsVO>();
        for (OrderDetailVO orderDetailVO : orderDetailVOList) {
            BnplOrderGoodsVO bnplOrderGoodsVO = new BnplOrderGoodsVO();
            bnplOrderGoodsVO.setOrderSid(orderDetailVO.getOrderSid());
            bnplOrderGoodsVO.setCategoryName(orderDetailVO.getCategoryName());
            bnplOrderGoodsVO.setQuantity(orderDetailVO.getQuantity());
            bnplOrderGoodsVO.setCloudDeviceCodes(cloudDeviceCodesMap.getOrDefault(orderDetailVO.getOrderSid(), Collections.emptyList()));
            bnplOrderGoodsVO.setGoodsCode(orderDetailVO.getGoodsCode());
            bnplOrderGoodsVO.setGoodsName(orderDetailVO.getGoodsName());
            bnplOrderGoodsVO.setStrategyName(orderDetailVO.getStrategyName());
            bnplOrderGoodsVO.setAmountPerPeriod(orderDetailVO.getAdjustmentTotal());
            bnplOrderGoodsVOList.add(bnplOrderGoodsVO);
        }
        bnplOrder.setGoods(bnplOrderGoodsVOList);
        return bnplOrder;
    }

    public List<BnplOrderVO> findByPage(BnplOrderConditionVO condition) {
        return this.bnplOrderMapper.selectByPage(condition, condition.getPageNum().intValue(), condition.getPageSize().intValue());
    }
}

