/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.bnpl.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.BnplOrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.dao.BnplOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCloudDeviceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailItemCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDeviceCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderBillVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderTerminateVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.dto.DeleteBnplOrderDTO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.MailGoodsDetail;
import com.digiwin.dap.middleware.omc.domain.remote.MailOrder;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.OrderDetail;
import com.digiwin.dap.middleware.omc.entity.OrderDetailItem;
import com.digiwin.dap.middleware.omc.mapper.BnplOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.repository.OrderDeviceRepository;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.util.BatchCodeUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BnplOrderServiceImpl
implements BnplOrderService {
    private static final Logger logger = LoggerFactory.getLogger(BnplOrderServiceImpl.class);
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private BnplOrderCrudService bnplOrderCrudService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderDetailItemCrudService orderDetailItemCrudService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private BnplOrderMapper bnplOrderMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private OrderCloudDeviceCrudService orderCloudDeviceCrudService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private OrderDeviceRepository orderDeviceRepository;
    @Autowired
    private OrderDeviceCrudService orderDeviceCrudService;
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;

    @Transactional(rollbackFor={Exception.class})
    public String generate(OrderVO order) {
        if (order.getBnpl() != null) {
            BnplOrder bnplOrder = this.generate(order, order.getFirstOrderDetail());
            String billCartCode = this.generateBillOrder(Long.valueOf(bnplOrder.getSid()));
            return billCartCode;
        }
        return null;
    }

    private BnplOrder generate(OrderVO order, OrderDetailVO orderDetail) {
        LocalDate nextBillDate;
        if (GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(order.getCategoryId())) {
            OrderCloudDevice device = null;
            if (StringUtils.hasText((String)orderDetail.getDeviceCode())) {
                List deviceList = this.orderCloudDeviceRepository.findByCodeAndDisabled(orderDetail.getDeviceCode(), false);
                device = deviceList.stream().findFirst().orElse(null);
            }
            logger.info("\u79df\u6237{}\u4e0b\u5546\u54c1{}\u5f53\u524d\u4e91\u8d44\u6e90\u6388\u6743\u4fe1\u606f:{}", new Object[]{order.getTenantId(), order.getGoodsCode(), JsonUtils.objToJson((Object)device)});
            nextBillDate = Objects.isNull(device) || LocalDateTime.now().isAfter(device.getExpireDate()) ? LocalDate.now() : LocalDate.from(device.getExpireDate().plusDays(1L));
        } else {
            AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(order.getTenantId(), order.getGoodsCode());
            logger.info("\u79df\u6237{}\u4e0b\u5546\u54c1{}\u5f53\u524d\u6388\u6743\u4fe1\u606f:{}", new Object[]{order.getTenantId(), order.getGoodsCode(), JsonUtils.objToJson((Object)authorizationVO)});
            nextBillDate = Objects.isNull(authorizationVO) || LocalDateTime.now().isAfter(authorizationVO.getExpiredTime()) ? LocalDate.now() : LocalDate.from(authorizationVO.getExpiredTime().plusDays(1L));
        }
        BnplOrder bnplOrder = (BnplOrder)order.getBnpl().doForward();
        bnplOrder.setOrderSid(order.getSid());
        bnplOrder.setPayDate(bnplOrder.getPayDate() == null ? LocalDate.now() : bnplOrder.getPayDate());
        bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.ACTIVE.getCode()));
        bnplOrder.setAmount(order.getPayPrice());
        bnplOrder.setBilledCount(Integer.valueOf(0));
        bnplOrder.setPaidCount(Integer.valueOf(0));
        bnplOrder.setNextBillDate(nextBillDate);
        bnplOrder.setTenantSid(order.getTenantSid());
        bnplOrder.setTenantId(order.getTenantId());
        bnplOrder.setTenantName(order.getTenantName());
        bnplOrder.setTestTenant(order.getTestTenant());
        bnplOrder.setGoodsSid(orderDetail.getGoodsSid());
        bnplOrder.setGoodsCode(orderDetail.getGoodsCode());
        bnplOrder.setGoodsName(orderDetail.getGoodsName());
        bnplOrder.setStrategySid(orderDetail.getStrategySid());
        bnplOrder.setBnplCode(this.orderCrudService.generateBnplOrderCode());
        this.bnplOrderCrudService.create((BaseEntity)bnplOrder);
        return bnplOrder;
    }

    @Transactional(rollbackFor={Exception.class})
    public BnplOrder terminate(BnplOrderTerminateVO body) {
        BnplOrder bnplOrder = (BnplOrder)this.bnplOrderCrudService.findBySid(body.getSid().longValue());
        if (bnplOrder != null && BnplOrderStatusEnum.isActiveStatus((Integer)bnplOrder.getStatus())) {
            bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.TERMINATED.getCode()));
            bnplOrder.setTerminateId(UserUtils.getUserId());
            bnplOrder.setTerminateName(UserUtils.getUserName());
            bnplOrder.setTerminateDate(LocalDateTime.now());
            bnplOrder.setTerminateReason(body.getTerminateReason());
            this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
        }
        return bnplOrder;
    }

    public BnplOrder terminateApply(BnplOrderTerminateVO body) {
        BnplOrder bnplOrder = (BnplOrder)this.bnplOrderCrudService.findBySid(body.getSid().longValue());
        if (bnplOrder != null && bnplOrder.getStatus().intValue() == BnplOrderStatusEnum.ACTIVE.getCode()) {
            bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.APPLY_TERMINATION.getCode()));
            bnplOrder.setApplyTerminateId(UserUtils.getUserId());
            bnplOrder.setApplyTerminateName(UserUtils.getUserName());
            bnplOrder.setApplyTerminateDate(LocalDateTime.now());
            bnplOrder.setApplyTerminateReason(body.getTerminateReason());
            this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
        }
        return bnplOrder;
    }

    public String generateBillOrder(Long bnplSid) {
        BnplOrder bnplOrder = (BnplOrder)this.bnplOrderCrudService.findBySid(bnplSid.longValue());
        LocalDate billDate = bnplOrder.getNextBillDate();
        if (billDate == null || !LocalDate.now().equals(billDate)) {
            logger.warn("\u672a\u5230\u8d26\u5355\u65e5\u671f,\u5148\u8ba2\u540e\u4ed8\u59d4\u6258\u5355:{}", (Object)bnplOrder.getSid());
            return null;
        }
        bnplOrder.setBilledCount(Integer.valueOf(bnplOrder.getBilledCount() + 1));
        bnplOrder.setNextBillDate(billDate.plusMonths(1L));
        if (Objects.equals(bnplOrder.getBilledCount(), bnplOrder.getTotalCount())) {
            bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.COMPLETED.getCode()));
            bnplOrder.setNextBillDate(null);
        }
        this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
        Order order = (Order)this.orderCrudService.findBySid(bnplOrder.getOrderSid().longValue());
        List<Object> orderVOList = new ArrayList<OrderVO>();
        if (Objects.equals(order.getShopping(), OrderShoppingEnum.COMMON.getCode())) {
            orderVOList.add(OrderVO.orderToVO((Order)order));
        } else {
            orderVOList = this.orderMapper.findOrdersByCartCodeList(Collections.singletonList(order.getCartCode()));
        }
        orderVOList = orderVOList.stream().distinct().collect(Collectors.toList());
        String billCartCode = this.orderCrudService.generateCartOrderCode(this.envProperties.getCountry());
        logger.info("\u751f\u6210\u8d26\u5355,\u8d26\u5355\u7ec4\u5408\u7f16\u53f7:{},\u8ba2\u5355\u7ec4\u5408\u7f16\u53f7:{},\u8ba2\u5355\u6570\u91cf:{},\u8ba2\u5355\u7c7b\u578b:{}", new Object[]{billCartCode, order.getCartCode(), orderVOList.size(), order.getShopping()});
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(Collections.singletonList(bnplOrder.getTenantId()));
        boolean isv = Objects.equals("1", tenantSimplesMap.getOrDefault(bnplOrder.getTenantId(), new CommonVO()).getTeamId());
        for (OrderVO orderVO : orderVOList) {
            Goods goods;
            Order billOrder = this.convertVOToEntity(orderVO);
            if (!Objects.nonNull(billOrder)) continue;
            billOrder.setSid(0L);
            billOrder.setOrderCode(orderVO.getOrderCode() + "N" + bnplOrder.getBilledCount());
            billOrder.setCartCode(Objects.equals(OrderShoppingEnum.COMMON.getCode(), order.getShopping()) ? null : billCartCode);
            billOrder.setPackCode(Objects.equals(OrderShoppingEnum.COMMON.getCode(), order.getShopping()) ? null : this.orderCrudService.generatePackOrderCode(this.envProperties.getCountry()));
            billOrder.setOrderStatus(Integer.valueOf(OrderStatusEnum.Unpaid.getValue()));
            billOrder.setOrderType(Integer.valueOf(OrderTypeEnum.BILL.getValue()));
            billOrder.setTotalPrice(orderVO.getTotalPrice());
            billOrder.setPayPrice(orderVO.getPayPrice());
            billOrder.setPaymentSid(Long.valueOf(0L));
            List orderDetails = this.orderDetailCrudService.findByOrderSid(orderVO.getSid().longValue());
            if (GoodsCategoryEnum.isDevice((String)billOrder.getCategoryId()) && !orderDetails.isEmpty() && Boolean.TRUE.equals((goods = this.goodsMapper.findGoodsBySid(((OrderDetail)orderDetails.get(0)).getGoodsSid().longValue())).getCloud()) && isv) {
                billOrder.setPayPrice(orderVO.getPayPrice().divide(new BigDecimal(2), 4, RoundingMode.HALF_UP));
                billOrder.setRemark(StringUtils.hasLength((String)orderVO.getRemark()) ? orderVO.getRemark() + "\uff1b\u5185\u90e8ISV\u4e91\u8d44\u6e90\u8d26\u5355\u8d39\u7528\u51cf\u534a" : "\u5185\u90e8ISV\u4e91\u8d44\u6e90\u8d26\u5355\u8d39\u7528\u51cf\u534a");
            }
            this.orderCrudService.create((BaseEntity)billOrder);
            orderDetails.forEach(orderDetail -> {
                OrderDetail billOrderDetail = orderDetail.clone();
                billOrderDetail.setSid(0L);
                billOrderDetail.setOrderSid(Long.valueOf(billOrder.getSid()));
                billOrderDetail.setCreateDate(null);
                billOrderDetail.setModifyDate(null);
                this.orderDetailCrudService.create((BaseEntity)billOrderDetail);
                List orderDetailItems = this.orderDetailItemCrudService.findByOrderDetailSid(orderDetail.getSid());
                orderDetailItems.forEach(orderDetailItem -> {
                    OrderDetailItem billOrderDetailItem = orderDetailItem.clone();
                    billOrderDetailItem.setSid(0L);
                    billOrderDetailItem.setOrderDetailSid(Long.valueOf(billOrderDetail.getSid()));
                    billOrderDetailItem.setCreateDate(null);
                    billOrderDetailItem.setModifyDate(null);
                    this.orderDetailItemCrudService.create((BaseEntity)billOrderDetailItem);
                });
            });
        }
        MailOrder mailOrder = this.mailService.getMailOrder(bnplOrder.getOrderSid().longValue());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        mailOrder.setBnpl(Boolean.valueOf(true));
        mailOrder.setOrderCode(order.getOrderCode());
        mailOrder.setBnplCode(bnplOrder.getBnplCode());
        mailOrder.setBillDate(dateTimeFormatter.format(billDate));
        mailOrder.setUnpaidCount(Integer.valueOf(bnplOrder.getTotalCount() - bnplOrder.getPaidCount()));
        mailOrder.setBillDay(Integer.valueOf(billDate.getDayOfMonth()));
        mailOrder.setAmount(bnplOrder.getAmount().setScale(2, RoundingMode.HALF_UP).toString());
        ArrayList mailGoodsDetailList = new ArrayList();
        ArrayList<Long> orderSids = new ArrayList<Long>();
        if (StringUtils.hasLength((String)order.getCartCode())) {
            List orderVOS = this.orderMapper.findOrdersByCartCodeList(Collections.singletonList(order.getCartCode()));
            orderSids.addAll(orderVOS.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode())).map(OrderVO::getSid).collect(Collectors.toList()));
        } else {
            orderSids.add(bnplOrder.getOrderSid());
        }
        if (!CollectionUtils.isEmpty(orderSids)) {
            List orderDetailVOList = this.orderDetailMapper.findOrderDetails(orderSids);
            orderDetailVOList.forEach(orderDetailVO -> {
                MailGoodsDetail mailGoodsDetail = new MailGoodsDetail();
                mailGoodsDetail.setGoodsName(orderDetailVO.getGoodsName());
                mailGoodsDetail.setStrategyName(orderDetailVO.getStrategyName());
                mailGoodsDetail.setQuantity(orderDetailVO.getQuantity());
                mailGoodsDetail.setRemark(orderDetailVO.getRemark());
                mailGoodsDetailList.add(mailGoodsDetail);
            });
        }
        mailOrder.setGoodsList(mailGoodsDetailList);
        if (!StringUtils.hasText((String)mailOrder.getPackGoodsName())) {
            mailOrder.setPackGoodsName(mailOrder.getGoodsName());
        }
        this.mailService.sendSubmitBnplOrder((Object)mailOrder);
        return billCartCode;
    }

    @Transactional
    public void deleteBillOrder(DeleteBnplOrderDTO dto) {
        BnplOrderVO bnplOrderVO = this.bnplOrderMapper.findBnplOrderByBnplCode(dto.getBnplCode());
        BnplOrder bnplOrder = (BnplOrder)bnplOrderVO.doForward();
        if (Objects.isNull(bnplOrder)) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_BNPL_NOT_EXIST);
        }
        if (!Objects.equals(bnplOrder.getStatus(), BnplOrderStatusEnum.TERMINATED.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_BNPL_USED);
        }
        Order order = (Order)this.orderCrudService.findBySid(bnplOrderVO.getOrderSid().longValue());
        if (Objects.isNull(order)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{bnplOrderVO.getSid()});
        }
        ArrayList<Long> orderSidList = new ArrayList<Long>();
        List<Object> orderCodeList = new ArrayList<String>();
        orderCodeList.add(order.getOrderCode());
        orderSidList.add(order.getSid());
        if (StringUtils.hasLength((String)order.getCartCode())) {
            List orderVOList = this.orderMapper.findOrdersByCartCodeList(Collections.singletonList(order.getCartCode()));
            for (OrderVO orderVO : orderVOList) {
                orderCodeList.add(orderVO.getOrderCode());
            }
            orderSidList.addAll(orderVOList.stream().map(OrderVO::getSid).collect(Collectors.toList()));
            orderCodeList.addAll(orderVOList.stream().map(OrderVO::getOrderCode).collect(Collectors.toList()));
        }
        orderCodeList = orderCodeList.stream().distinct().collect(Collectors.toList());
        ArrayList bnplOrderBillVOList = new ArrayList();
        for (String string : orderCodeList) {
            bnplOrderBillVOList.addAll(this.bnplOrderMapper.findBnplOrderBill(string));
        }
        ArrayList billOrderSidList = new ArrayList();
        billOrderSidList.addAll(bnplOrderBillVOList.stream().map(BnplOrderBillVO::getSid).collect(Collectors.toList()));
        List list = bnplOrderBillVOList.stream().filter(x -> Objects.equals(x.getOrderStatus(), OrderStatusEnum.Paid.getValue())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_BNPL_USED);
        }
        if (!CollectionUtils.isEmpty(billOrderSidList)) {
            this.orderMapper.deleteInOrderSids(billOrderSidList);
            this.orderDetailMapper.deleteOrderDetailItemByOrderSids(billOrderSidList);
            this.orderDetailMapper.deleteOrderDetailByOrderSids(billOrderSidList);
        }
        bnplOrder.setBnplCode(bnplOrderVO.getBnplCode());
        bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.DELETED.getCode()));
        this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
        this.terminationAuthorization(bnplOrder, Boolean.valueOf(true));
    }

    public void terminationAuthorization(BnplOrder bnplOrder, Boolean terminateImmediately) {
        List orderList = new ArrayList<Order>();
        Order order = this.orderRepository.findBySid(bnplOrder.getOrderSid());
        if (Objects.equals(order.getShopping(), OrderShoppingEnum.COMMON.getCode())) {
            orderList.add(order);
        }
        if (Objects.equals(order.getShopping(), OrderShoppingEnum.PACK.getCode())) {
            orderList = this.orderRepository.findByCartCode(order.getCartCode());
        }
        String batchCode = BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.BNPL);
        if (bnplOrder.getNextBillDate() == null) {
            return;
        }
        LocalDateTime nextBillDate = bnplOrder.getNextBillDate().atTime(23, 59, 59);
        for (Order o : orderList) {
            LocalDateTime leftDateTime;
            int remainCount = bnplOrder.getTotalCount() - bnplOrder.getBilledCount();
            if (!Objects.equals(o.getShopping(), OrderShoppingEnum.COMMON.getCode()) && !Objects.equals(o.getShopping(), OrderShoppingEnum.PACK.getCode())) continue;
            if (Objects.equals(o.getCategoryId(), "device")) {
                this.orderCloudDeviceRepository.findByOrderSid(Long.valueOf(o.getSid())).forEach(orderCloudDevice -> {
                    LocalDateTime leftDateTime;
                    LocalDateTime localDateTime = leftDateTime = orderCloudDevice.getExpireDate() == null ? nextBillDate : orderCloudDevice.getExpireDate().minusMonths(remainCount);
                    if (terminateImmediately.booleanValue()) {
                        orderCloudDevice.setState(Integer.valueOf(3));
                    }
                    if (leftDateTime.isBefore(nextBillDate)) {
                        orderCloudDevice.setExpireDate(terminateImmediately != false ? LocalDateTime.now() : nextBillDate);
                    } else {
                        orderCloudDevice.setExpireDate(terminateImmediately != false ? LocalDateTime.now() : leftDateTime);
                    }
                    this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
                });
                this.orderDeviceRepository.findByOrderSid(o.getSid()).forEach(orderDevice -> {
                    LocalDateTime leftDateTime;
                    LocalDateTime localDateTime = leftDateTime = orderDevice.getExpireDate() == null ? nextBillDate : orderDevice.getExpireDate().minusMonths(remainCount);
                    if (terminateImmediately.booleanValue()) {
                        orderDevice.setStatus(Integer.valueOf(3));
                    }
                    if (leftDateTime.isBefore(nextBillDate)) {
                        orderDevice.setExpireDate(terminateImmediately != false ? LocalDateTime.now() : nextBillDate);
                    } else {
                        orderDevice.setExpireDate(terminateImmediately != false ? LocalDateTime.now() : leftDateTime);
                    }
                    this.orderDeviceCrudService.update((BaseEntity)orderDevice);
                });
            }
            ProductTypeVO productType = new ProductTypeVO();
            productType.setTenantId(bnplOrder.getTenantId());
            productType.setGoodsId(o.getGoodsCode());
            AuthorizationVO authorization = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(bnplOrder.getTenantId(), o.getGoodsCode());
            LocalDateTime localDateTime = leftDateTime = authorization == null ? nextBillDate : authorization.getExpiredTime().minusMonths(remainCount);
            if (leftDateTime.isBefore(nextBillDate)) {
                productType.setExpiredDateTime(terminateImmediately != false ? LocalDateTime.now() : nextBillDate);
            } else {
                productType.setExpiredDateTime(terminateImmediately != false ? LocalDateTime.now() : leftDateTime);
            }
            productType.setMemo(String.format("\u7ec8\u6b62\u5148\u8ba2\u540e\u4ed8%s,\u6263\u51cf\u6388\u6743%s\u6708", bnplOrder.getBnplCode(), remainCount));
            productType.setBatchCode(batchCode);
            this.cacService.updateGoodsAndModuleExpiredDateTime(productType);
        }
    }

    public void cancelTerminateApply(BnplOrderTerminateVO body) {
        BnplOrder bnplOrder = (BnplOrder)this.bnplOrderCrudService.findBySid(body.getSid().longValue());
        if (bnplOrder != null && bnplOrder.getStatus().intValue() == BnplOrderStatusEnum.APPLY_TERMINATION.getCode()) {
            bnplOrder.setStatus(Integer.valueOf(BnplOrderStatusEnum.ACTIVE.getCode()));
            this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
        }
    }

    private Order convertVOToEntity(OrderVO orderVO) {
        if (orderVO == null) {
            return null;
        }
        Order order = new Order();
        order.setSid(orderVO.getSid().longValue());
        order.setOrderCode(orderVO.getOrderCode());
        order.setOrderStatus(orderVO.getOrderStatus());
        order.setOrderType(orderVO.getOrderType());
        order.setValid(orderVO.getValid().booleanValue());
        order.setOrderSource(orderVO.getOrderSource());
        order.setTaxRate(orderVO.getTaxRate());
        order.setNoTaxPrice(orderVO.getNoTaxPrice());
        order.setTaxPrice(orderVO.getTaxPrice());
        order.setContainTaxPrice(orderVO.getContainTaxPrice());
        order.setTotalPrice(orderVO.getTotalPrice());
        order.setPayPrice(orderVO.getPayPrice());
        order.setProfitShare(orderVO.getProfitShare());
        order.setDiscountPrice(orderVO.getDiscountPrice());
        order.setTenantSid(orderVO.getTenantSid());
        order.setTenantId(orderVO.getTenantId());
        order.setTenantName(orderVO.getTenantName());
        order.setCustomerId(orderVO.getCustomerId());
        order.setUserId(orderVO.getUserId());
        order.setUserName(orderVO.getUserName());
        order.setEmail(orderVO.getEmail());
        order.setTelephone(orderVO.getTelephone());
        order.setDepartCode(orderVO.getDepartCode());
        order.setBusinessCode(orderVO.getBusinessCode());
        order.setRecommendedCode(orderVO.getRecommendedCode());
        order.setRecommendedItCode(orderVO.getRecommendedItCode());
        order.setRecommendedItName(orderVO.getRecommendedItName());
        order.setRecommendedDepartCode(orderVO.getRecommendedDepartCode());
        order.setUserNumber(orderVO.getUserNumber());
        order.setOriginUserNumber(orderVO.getOriginUserNumber());
        order.setTossStatus(orderVO.getTossStatus());
        order.setTossDate(orderVO.getTossDate());
        order.setDgwFacOrderCode(orderVO.getDgwFacOrderCode());
        order.setDgwFacContractCode(orderVO.getDgwFacContractCode());
        order.setEnterprise(orderVO.getEnterprise());
        order.setCheckBill(orderVO.getCheckBill().booleanValue());
        order.setRemark(orderVO.getRemark());
        order.setComment(orderVO.getComment());
        order.setCategoryId(orderVO.getCategoryId());
        order.setGoodsCode(orderVO.getGoodsCode());
        order.setAuthorization(orderVO.getAuthorization().booleanValue());
        order.setInitialize(orderVO.getInitialize());
        order.setCreateById(orderVO.getCreateById());
        order.setTestTenant(orderVO.getTestTenant().booleanValue());
        order.setShipmentStartDate(orderVO.getShipmentStartDate());
        order.setShipmentEndDate(orderVO.getShipmentEndDate());
        order.setAuthorizationDate(orderVO.getAuthorizationDate());
        order.setPayCount(orderVO.getPayCount());
        order.setCartCode(orderVO.getCartCode());
        order.setPackCode(orderVO.getPackCode());
        order.setPackSid(orderVO.getPackSid());
        order.setShopping(orderVO.getShopping());
        order.setSchool(orderVO.getSchool().booleanValue());
        order.setAccountConfirm(orderVO.isAccountConfirm());
        order.setAccountConfirmDate(orderVO.getAccountConfirmDate());
        order.setPeriodNo(orderVO.getPeriodNo());
        order.setMerchantOrderNo(orderVO.getMerchantOrderNo());
        return order;
    }
}

