/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormCartVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormContentVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormGoodsVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormVO;
import com.digiwin.dap.middleware.omc.entity.CustomFormCart;
import com.digiwin.dap.middleware.omc.entity.CustomFormOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.CustomFormCartMapper;
import com.digiwin.dap.middleware.omc.repository.CustomFormCartRepository;
import com.digiwin.dap.middleware.omc.repository.CustomFormOrderRepository;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.service.business.CustomFormCartService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CustomFormCartServiceImpl
implements CustomFormCartService {
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private CustomFormCartMapper customFormCartMapper;
    @Autowired
    private CustomFormCartRepository customFormCartRepository;
    @Autowired
    private CustomFormOrderRepository customFormOrderRepository;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public void save(CustomFormCartVO customFormCartVO) {
        Order order = this.orderRepository.findBySid(customFormCartVO.getCartOrderSid());
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{customFormCartVO.getCartOrderSid()});
        }
        List customFormCarts = this.customFormCartRepository.getByCartOrderSid(customFormCartVO.getCartOrderSid());
        this.customFormCartRepository.deleteByCartOrderSid(customFormCartVO.getCartOrderSid());
        List cartSids = customFormCarts.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        if (cartSids.size() > 0) {
            this.customFormCartMapper.deleteOrderByCartSids(cartSids);
        }
        this.orderRepository.flush();
        ArrayList customFormOrders = new ArrayList();
        customFormCartVO.getCustomForm().forEach(o -> o.getContent().forEach(j -> {
            CustomFormCart customFormCart = new CustomFormCart(customFormCartVO.getCartOrderSid().longValue(), o, j);
            EntityUtils.setCreateFields((BaseEntity)customFormCart);
            long sid = ((CustomFormCart)this.customFormCartRepository.save((Object)customFormCart)).getSid();
            o.getOrderSid().forEach(k -> {
                CustomFormOrder customFormOrder = new CustomFormOrder(Long.valueOf(sid), k);
                EntityUtils.setCreateFields((BaseEntity)customFormOrder);
                customFormOrders.add(customFormOrder);
            });
        }));
        this.customFormOrderRepository.saveAll(customFormOrders);
    }

    public List<CustomFormVO> getCustomFromByCartSid(long sid) {
        List customFormCarts = this.customFormCartMapper.findCustomFormByCartOrderSid(Long.valueOf(sid));
        customFormCarts.forEach(o -> {
            try {
                for (CustomFormContentVO contentVO : o.getContent()) {
                    contentVO.setValueParameter((List)objectMapper.readValue(contentVO.getValueParameterStr(), List.class));
                }
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        });
        return customFormCarts;
    }

    public CustomFormVO getCustomFromByOrderSid(long sid) {
        CustomFormVO customFormCart = this.customFormCartMapper.findCustomFormByOrderSid(Long.valueOf(sid));
        if (null != customFormCart) {
            try {
                for (CustomFormContentVO contentVO : customFormCart.getContent()) {
                    contentVO.setValueParameter((List)objectMapper.readValue(contentVO.getValueParameterStr(), List.class));
                }
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return customFormCart;
    }

    public List<CustomFormOrderVO> getCustomFormOrderList(CustomFormOrderVO condition, int pageNum, int pageSize, String orderBy) {
        if (StrUtils.isNotEmpty((String)condition.getGoodsContent())) {
            condition.setGoodsCodes(condition.getGoodsContent().split(";"));
        }
        List customFormOrderVOList = this.customFormCartMapper.findCustomFormOrders(condition, pageNum, pageSize, orderBy);
        List sids = customFormOrderVOList.stream().map(CustomFormOrderVO::getOrderSid).collect(Collectors.toList());
        List customFormValueVOS = this.customFormCartMapper.findCustomFormContentsByOrderSid(sids);
        customFormOrderVOList.forEach(o -> o.setCustomFormContentVO(customFormValueVOS.stream().filter(c -> o.getOrderSid().equals(c.getOrderSid())).collect(Collectors.toList())));
        return customFormOrderVOList;
    }

    public void update(List<CustomFormContentVO> customFormContentVOs) {
        ArrayList customFormCarts = new ArrayList();
        customFormContentVOs.forEach(o -> {
            Assert.notNull((Object)o.getSid(), (String)"sid:sid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            CustomFormCart customFormCart = this.customFormCartRepository.getBySid(o.getSid());
            if (null == customFormCart) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10012, new Object[]{o.getSid()});
            }
            customFormCart.setValue(o.getValue());
            customFormCart.setReason(o.getReason());
            EntityUtils.setModifyFields((BaseEntity)customFormCart);
            customFormCarts.add(customFormCart);
        });
        this.customFormCartRepository.saveAll(customFormCarts);
    }

    public List<CustomFormGoodsVO> getAllGoods(String customFormId) {
        List usableGoods = this.customFormCartMapper.findUsableGoodsInOrder(customFormId);
        return usableGoods;
    }
}

