/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.DevSysAuthorizationStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.remote.TenantContactInfoVO;
import com.digiwin.dap.middleware.omc.domain.request.DevSysAuthorizationDTO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.response.DevSysAuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.DevSysAuthorization;
import com.digiwin.dap.middleware.omc.mapper.DevSysAuthorizationMapper;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.repository.DevSysAuthorizationRepository;
import com.digiwin.dap.middleware.omc.service.business.DevSysAuthorizationService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DevSysAuthorizationServiceImpl
implements DevSysAuthorizationService {
    @Autowired
    private DevSysAuthorizationRepository devSysAuthorizationRepository;
    @Autowired
    private DevSysAuthorizationMapper devSysAuthorizationMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private IamService iamService;
    @Autowired
    private CacService cacService;

    @Transactional
    public DevSysAuthorization save(DevSysAuthorizationDTO dto) {
        DevSysAuthorization authorization = (DevSysAuthorization)dto.doForward();
        authorization.setCode("dev-" + UUID.randomUUID());
        authorization.setStatus(DevSysAuthorizationStatusEnum.CODE_NOT_USED.getValue());
        Goods goods = this.goodsMapper.findGoodsByCode(authorization.getDevSysId());
        if (null == goods) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5e94\u7528[%s]\u5bf9\u5e94\u7684\u5546\u54c1[%s]\u4e0d\u5b58\u5728", authorization.getDevSysId(), authorization.getDevSysId()));
        }
        GoodsStrategy strategy = this.goodsMapper.findFirstStrategyByGoodsCode(authorization.getDevSysId());
        if (null == strategy) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5e94\u7528[%s]\u5bf9\u5e94\u7684\u5546\u54c1[%s]\u6ca1\u6709\u9500\u552e\u65b9\u6848", authorization.getDevSysId(), authorization.getDevSysId()));
        }
        authorization.setStrategySid(strategy.getId());
        EntityUtils.setCreateFields((BaseEntity)authorization);
        return (DevSysAuthorization)this.devSysAuthorizationRepository.save((Object)authorization);
    }

    public PageSerializable<DevSysAuthorizationVO> getDevSysAuthorizations(Integer pageNum, Integer pageSize, String orderBy, DevSysAuthorizationDTO dto) {
        List authorizations = this.devSysAuthorizationMapper.getDevSysAuthorizations(pageNum.intValue(), pageSize.intValue(), orderBy, dto);
        return new PageSerializable(authorizations);
    }

    @Transactional
    public String stopAuthorization(DevSysAuthorization authorization) {
        ResponseResult responseResult = this.cacService.updateGoodsAndModuleExpiredDateTime(new ProductTypeVO(authorization.getTenantId(), authorization.getDevSysId(), String.format("\u505c\u7528\u4f01\u4e1a\u6388\u6743\u7801[%s]", authorization.getCode())));
        if (!responseResult.isSuccess()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u505c\u7528\u4f01\u4e1a\u6388\u6743\u7801\u7684\u5e94\u7528\u8fc7\u671f\u65f6\u95f4\u5931\u8d25");
        }
        authorization.setStatus(DevSysAuthorizationStatusEnum.CODE_STOPPED.getValue());
        authorization.setStopDate(LocalDateTime.now());
        EntityUtils.setCreateFields((BaseEntity)authorization);
        this.devSysAuthorizationRepository.save((Object)authorization);
        return authorization.getCode();
    }

    @Transactional
    public Long createPreOrder(String code, AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_SID_ERROR, new Object[]{authoredUser.getUserId()});
        }
        if (StrUtils.isEmpty((String)authoredUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_ERROR, new Object[]{authoredUser.getUserId()});
        }
        DevSysAuthorization authorization = Optional.ofNullable(this.devSysAuthorizationRepository.findByCode(code)).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_NOT_EXISTED, new Object[]{code}));
        if (DevSysAuthorizationStatusEnum.CODE_USED.getValue().equals(authorization.getStatus())) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_USED, new Object[]{code});
        }
        if (DevSysAuthorizationStatusEnum.CODE_STOPPED.getValue().equals(authorization.getStatus())) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_STOPP, new Object[]{code});
        }
        if (!DevSysAuthorizationStatusEnum.CODE_NOT_USED.getValue().equals(authorization.getStatus())) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_STATUS_ERROR, new Object[]{code});
        }
        Goods goods = this.goodsMapper.findGoodsByCode(authorization.getDevSysId());
        if (null == goods) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_GOODS_ERROR, new Object[]{code});
        }
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(authorization.getStrategySid().longValue());
        if (null == strategy) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_STRATEGY_ERROR, new Object[]{code});
        }
        PreOrderDTO preOrderDTO = new PreOrderDTO();
        preOrderDTO.setSourceBillCode(code);
        preOrderDTO.setOrderType(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue());
        preOrderDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        preOrderDTO.setTenantId(authoredUser.getTenantId());
        preOrderDTO.setTenantName(authoredUser.getTenantName());
        preOrderDTO.setRemark(String.format("\u4f01\u4e1a\u6388\u6743\u7801[%s]\u5f00\u901a", code));
        preOrderDTO.setSendEmail(Boolean.TRUE);
        preOrderDTO.setDetailInfo(goods, strategy);
        PreOrderVO preOrderVO = this.preOrderService.checkAndSave(preOrderDTO);
        if (!PreOrderDetailAuthorizationEnum.OPENED.getValue().equals(preOrderVO.getFirstOrderDetail().getAuthorization())) {
            throw new BusinessException((ErrorHandler)I18nError.DEV_SYS_AUTHORIZATION_ERROR, new Object[]{code});
        }
        this.updateCodeUsed(Long.valueOf(authoredUser.getTenantSid()), authoredUser.getTenantId(), authoredUser.getTenantName(), authorization);
        return preOrderVO.getSid();
    }

    @Transactional
    public void updateCodeUsed(Long tenantSid, String tenantId, String tenantName, DevSysAuthorization authorization) {
        TenantContactInfoVO tenantContactInfoVO = this.iamService.getTenantContactInfoVO(tenantId);
        authorization.setStatus(DevSysAuthorizationStatusEnum.CODE_USED.getValue());
        authorization.setTenantSid(tenantSid);
        authorization.setTenantId(tenantId);
        authorization.setTenantName(tenantName);
        if (tenantContactInfoVO != null) {
            authorization.setContacts(tenantContactInfoVO.getContacts());
        }
        authorization.setBeginDate(LocalDateTime.now());
        EntityUtils.setModifyFields((BaseEntity)authorization);
        this.devSysAuthorizationRepository.save((Object)authorization);
    }
}

