/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceStateEnum;
import com.digiwin.dap.middleware.omc.dao.BnplOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCloudDeviceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.DeviceAttributeVO;
import com.digiwin.dap.middleware.omc.domain.DeviceCloudExpiredNoticeDTO;
import com.digiwin.dap.middleware.omc.domain.OrderCustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceAutoVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceDbVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.PreOrder;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.repository.PreOrderRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderDetailService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.util.MailUtil;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrderCloudDeviceServiceImpl
implements OrderCloudDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(OrderCloudDeviceServiceImpl.class);
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private OrderCloudDeviceCrudService orderCloudDeviceCrudService;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private PreOrderRepository preOrderRepository;
    @Autowired
    private PreOrderDetailService preOrderDetailService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private BnplOrderCrudService bnplOrderCrudService;
    @Autowired
    private GoodsMapper goodsMapper;

    public OrderCloudDeviceVO setAttributeValue(Long strategySid, PreOrderVO preOrderVO) {
        try {
            OrderCloudDeviceVO orderCloudDeviceVO = new OrderCloudDeviceVO();
            orderCloudDeviceVO.setTenantId(preOrderVO.getTenantId());
            orderCloudDeviceVO.setTenantName(preOrderVO.getTenantName());
            orderCloudDeviceVO.setGoodsCode(preOrderVO.getFirstOrderDetail().getGoodsCode());
            orderCloudDeviceVO.setGoodsName(preOrderVO.getFirstOrderDetail().getGoodsName());
            orderCloudDeviceVO.setOrderSid(preOrderVO.getSid());
            String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValues(strategySid.longValue());
            if (StrUtils.isNotEmpty((String)customAttributeStr)) {
                List customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (CustomAttributeVO attribute : customAttributeVOS) {
                    if ("area".equalsIgnoreCase(attribute.getId())) {
                        orderCloudDeviceVO.setArea(attribute.getValue());
                    }
                    if (!"kind".equalsIgnoreCase(attribute.getId())) continue;
                    orderCloudDeviceVO.setKind(attribute.getValue());
                }
            }
            return orderCloudDeviceVO;
        }
        catch (IOException e) {
            throw new BusinessException(String.format("%s\u9500\u552e\u65b9\u6848\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", strategySid), (Throwable)e);
        }
    }

    public OrderCloudDeviceVO setAttributeValue(Long strategySid, OrderVO orderVO) {
        try {
            OrderCloudDeviceVO orderCloudDeviceVO = new OrderCloudDeviceVO();
            orderCloudDeviceVO.setTenantId(orderVO.getTenantId());
            orderCloudDeviceVO.setTenantName(orderVO.getTenantName());
            orderCloudDeviceVO.setGoodsCode(orderVO.getFirstOrderDetail().getGoodsCode());
            orderCloudDeviceVO.setGoodsName(orderVO.getFirstOrderDetail().getGoodsName());
            orderCloudDeviceVO.setOrderSid(orderVO.getSid());
            String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValues(strategySid.longValue());
            if (StrUtils.isNotEmpty((String)customAttributeStr)) {
                List customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (CustomAttributeVO attribute : customAttributeVOS) {
                    if ("area".equalsIgnoreCase(attribute.getId())) {
                        orderCloudDeviceVO.setArea(attribute.getValue());
                    }
                    if (!"kind".equalsIgnoreCase(attribute.getId())) continue;
                    orderCloudDeviceVO.setKind(attribute.getValue());
                }
            }
            return orderCloudDeviceVO;
        }
        catch (IOException e) {
            throw new BusinessException(String.format("%s\u9500\u552e\u65b9\u6848\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", strategySid), (Throwable)e);
        }
    }

    public PageSerializable<OrderCloudDeviceVO> getCloudDevices(Integer pageNum, Integer pageSize, String orderBy, CloudDeviceConditionVO deviceCondition) {
        List orderCloudDeviceVOS = this.orderCloudDeviceMapper.getDeviceClouds(deviceCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        this.populateCustomAttributes(orderCloudDeviceVOS);
        Map strategyMap = this.orderQueryService.getStrategyMap(orderCloudDeviceVOS.stream().map(OrderCloudDeviceVO::getStrategySid).collect(Collectors.toList()));
        orderCloudDeviceVOS.forEach(a -> a.setStrategy((GoodsStrategy)strategyMap.get(a.getStrategySid())));
        return new PageSerializable(orderCloudDeviceVOS);
    }

    public void populateCustomAttributes(List<OrderCloudDeviceVO> orderCloudDeviceVOS) {
        List strategySids = orderCloudDeviceVOS.stream().map(OrderCloudDeviceVO::getStrategySid).distinct().collect(Collectors.toList());
        if (strategySids.isEmpty()) {
            return;
        }
        List customAttributeVOS = this.orderCloudDeviceMapper.getAllCustomAttributeValues(strategySids);
        Map attributeMap = customAttributeVOS.stream().filter(attr -> StrUtils.isNotEmpty((String)attr.getCustomAttributes())).collect(Collectors.toMap(OrderCustomAttributeVO::getSid, Function.identity(), (v1, v2) -> v1));
        orderCloudDeviceVOS.forEach(device -> {
            OrderCustomAttributeVO customAttr = (OrderCustomAttributeVO)attributeMap.get(device.getStrategySid());
            if (customAttr != null) {
                DeviceAttributeVO deviceAttributes = DeviceAttributeVO.parseDeviceAttributes((String)customAttr.getCustomAttributes());
                BeanUtils.copyProperties((Object)deviceAttributes, (Object)device);
            }
        });
    }

    public OrderCloudDeviceVO getCloudDevice(Long sid) {
        try {
            OrderCloudDeviceVO orderCloudDeviceVO = this.orderCloudDeviceMapper.getDetail(sid.longValue());
            if (orderCloudDeviceVO == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u8bbe\u5907\u4e91\u8d44\u6e90\u4e0d\u5b58\u5728", sid));
            }
            if (orderCloudDeviceVO.getExpireDate() != null && 2 == orderCloudDeviceVO.getState()) {
                int days = (int)Duration.between(LocalDateTime.now(), orderCloudDeviceVO.getExpireDate()).toDays();
                orderCloudDeviceVO.setExpiredDays(Integer.valueOf(days));
            }
            Long orderSid = orderCloudDeviceVO.getOrderSid();
            String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValuesByOrderSid(orderSid.longValue());
            try {
                if (StrUtils.isNotEmpty((String)customAttributeStr)) {
                    List customAttributeVOList = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    orderCloudDeviceVO.setGoodsInfos(customAttributeVOList);
                }
            }
            catch (IOException e) {
                throw new BusinessException(String.format("%s\u8ba2\u5355\u8d2d\u4e70\u7684\u9500\u552e\u65b9\u6848\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", orderSid), (Throwable)e);
            }
            Map strategyMap = this.orderQueryService.getStrategyMap(Collections.singletonList(orderCloudDeviceVO.getStrategySid()));
            orderCloudDeviceVO.setStrategy((GoodsStrategy)strategyMap.get(orderCloudDeviceVO.getStrategySid()));
            this.setDeviceTenancyPeriod(orderCloudDeviceVO);
            return orderCloudDeviceVO;
        }
        catch (Exception ex) {
            throw new BusinessException((Throwable)ex);
        }
    }

    private void setDeviceTenancyPeriod(OrderCloudDeviceVO orderCloudDeviceVO) {
        BnplOrder bnplOrder;
        Integer tenancyPeriod = orderCloudDeviceVO.getTenancyPeriod();
        orderCloudDeviceVO.setDeviceTenancyPeriod(tenancyPeriod);
        if (!"order".equals(orderCloudDeviceVO.getSourceType())) {
            return;
        }
        Order order = (Order)this.orderCrudService.findBySid(orderCloudDeviceVO.getOrderSid().longValue());
        Long orderSid = order.getSid();
        if (StringUtils.hasLength((String)order.getPackCode())) {
            OrderConditionVO condition = new OrderConditionVO();
            condition.setPackCode(order.getPackCode());
            condition.setShopping(Integer.valueOf(2));
            condition.setInclude(Integer.valueOf(2));
            List orders = this.orderMapper.findOrdersWithoutPolicy(condition);
            if (!orders.isEmpty()) {
                orderSid = ((OrderVO)orders.get(0)).getSid();
            }
        }
        if (orderSid != null && (bnplOrder = this.bnplOrderCrudService.findByOrderSid(orderSid)) != null) {
            orderCloudDeviceVO.setDeviceTenancyPeriod(Integer.valueOf(tenancyPeriod * bnplOrder.getTotalCount()));
        }
    }

    @Transactional
    public void batchApplyCloudDevice(List<OrderCloudDeviceVO> orderCloudDeviceVOs) {
        ArrayList<OrderCloudDeviceVO> mails = new ArrayList<OrderCloudDeviceVO>();
        for (OrderCloudDeviceVO vo : orderCloudDeviceVOs) {
            OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(vo.getSid().longValue());
            if (orderCloudDevice == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u8bbe\u5907\u4e91\u8d44\u6e90\u4e0d\u5b58\u5728", vo.getSid()));
            }
            if (0 != orderCloudDevice.getState()) {
                logger.error(String.format("\u8bbe\u5907\u4e91\u8d44\u6e90%s\u7684\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7", orderCloudDevice.getCode(), orderCloudDevice.getState()));
                return;
            }
            OrderCloudDeviceVO orderCloudDeviceVO = this.getOrderCloudDeviceVO(vo, orderCloudDevice);
            mails.add(orderCloudDeviceVO);
        }
        this.mailService.sendEmailActivateCloudDeviceMerged(mails);
    }

    @Transactional(rollbackOn={Exception.class})
    public void applyCloudDevice(OrderCloudDeviceVO vo) {
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(vo.getSid().longValue());
        if (orderCloudDevice == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u8bbe\u5907\u4e91\u8d44\u6e90\u4e0d\u5b58\u5728", vo.getSid()));
        }
        if (0 != orderCloudDevice.getState()) {
            logger.error(String.format("\u8bbe\u5907\u4e91\u8d44\u6e90%s\u7684\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7", orderCloudDevice.getCode(), orderCloudDevice.getState()));
            return;
        }
        OrderCloudDeviceVO orderCloudDeviceVO = this.getOrderCloudDeviceVO(vo, orderCloudDevice);
        this.mailService.sendEmailActivateCloudDeviceMerged(Collections.singletonList(orderCloudDeviceVO));
    }

    private OrderCloudDeviceVO getOrderCloudDeviceVO(OrderCloudDeviceVO vo, OrderCloudDevice orderCloudDevice) {
        OrderCloudDeviceVO orderCloudDeviceVO;
        String userId = vo.getUserId();
        String userName = vo.getUserName();
        String description = vo.getDescription();
        PreOrder preOrder = this.preOrderRepository.findBySid(orderCloudDevice.getOrderSid().longValue());
        if (null != preOrder) {
            PreOrderVO preOrderVO = new PreOrderVO();
            preOrderVO.doBackward((Object)preOrder);
            preOrderVO.setDetails(this.preOrderDetailService.getPreOrderDetails(orderCloudDevice.getOrderSid()));
            orderCloudDevice.setState(Integer.valueOf(1));
            orderCloudDevice.setApplicantId(Optional.ofNullable(vo.getApplicantId()).orElse(UserUtils.getUserId()));
            orderCloudDevice.setApplicantName(Optional.ofNullable(vo.getApplicantName()).orElse(UserUtils.getUserName()));
            orderCloudDevice.setApplicantDate(LocalDateTime.now());
            orderCloudDevice.setDescription(Optional.ofNullable(description).orElse(orderCloudDevice.getDescription()));
            this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
            orderCloudDeviceVO = this.setAttributeValue(preOrderVO.getFirstOrderDetail().getStrategySid(), preOrderVO);
            orderCloudDeviceVO.setCode(orderCloudDevice.getCode());
            orderCloudDeviceVO.setSid(Long.valueOf(orderCloudDevice.getSid()));
            orderCloudDeviceVO.setApplicantId(orderCloudDevice.getApplicantId());
            orderCloudDeviceVO.setApplicantName(orderCloudDevice.getApplicantName());
            orderCloudDeviceVO.setApplicantDate(orderCloudDevice.getApplicantDate());
            orderCloudDeviceVO.setCloud(orderCloudDevice.getCloud());
            orderCloudDeviceVO.setUserId(userId);
            orderCloudDeviceVO.setUserName(userName);
        } else {
            OrderVO orderVO = this.orderQueryService.getOrderBySid(orderCloudDevice.getOrderSid().longValue());
            if (orderVO == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u8ba2\u5355%s\u4e0d\u5b58\u5728", orderCloudDevice.getOrderSid()));
            }
            if (1 != orderVO.getOrderStatus()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u8ba2\u5355\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u80fd\u7533\u8bf7\u5f00\u7acb", orderVO.getOrderStatus()));
            }
            if (1 == orderVO.getOrderStatus()) {
                orderCloudDevice.setState(Integer.valueOf(1));
                orderCloudDevice.setApplicantId(Optional.ofNullable(vo.getApplicantId()).orElse(UserUtils.getUserId()));
                orderCloudDevice.setApplicantName(Optional.ofNullable(vo.getApplicantName()).orElse(UserUtils.getUserName()));
                orderCloudDevice.setApplicantDate(LocalDateTime.now());
                orderCloudDevice.setDescription(Optional.ofNullable(description).orElse(orderCloudDevice.getDescription()));
                this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
                orderCloudDeviceVO = this.setAttributeValue(orderVO.getFirstOrderDetail().getStrategySid(), orderVO);
                orderCloudDeviceVO.setCode(orderCloudDevice.getCode());
                orderCloudDeviceVO.setSid(Long.valueOf(orderCloudDevice.getSid()));
                orderCloudDeviceVO.setApplicantId(orderCloudDevice.getApplicantId());
                orderCloudDeviceVO.setApplicantName(orderCloudDevice.getApplicantName());
                orderCloudDeviceVO.setApplicantDate(orderCloudDevice.getApplicantDate());
                orderCloudDeviceVO.setCloud(orderCloudDevice.getCloud());
                orderCloudDeviceVO.setUserId(userId);
                orderCloudDeviceVO.setUserName(userName);
            } else {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u8ba2\u5355%s\u7684\u72b6\u6001\u4e0d\u662f\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u7533\u8bf7\u5f00\u7acb", orderVO.getOrderCode()));
            }
        }
        return orderCloudDeviceVO;
    }

    @Transactional(rollbackOn={Exception.class})
    public void completeApplication(OrderCloudDeviceVO cloudDeviceVO) {
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(cloudDeviceVO.getSid().longValue());
        if (orderCloudDevice == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u8bbe\u5907\u4e91\u8d44\u6e90\u4e0d\u5b58\u5728", cloudDeviceVO.getSid()));
        }
        this.updateBasicInfo(orderCloudDevice, cloudDeviceVO);
        switch (orderCloudDevice.getState()) {
            case 1: {
                this.handlePendingState(orderCloudDevice, cloudDeviceVO);
                break;
            }
            case 2: 
            case 3: {
                this.handleCompletedOrExpiredState(orderCloudDevice, cloudDeviceVO);
                break;
            }
            default: {
                String errorMsg = String.format("\u8bbe\u5907\u4e91\u8d44\u6e90%s\u7684\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u80fd\u5b8c\u6210\u7533\u8bf7\u5f00\u7acb", orderCloudDevice.getCode(), orderCloudDevice.getState());
                logger.error(errorMsg);
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, errorMsg);
            }
        }
    }

    private void updateBasicInfo(OrderCloudDevice orderCloudDevice, OrderCloudDeviceVO cloudDeviceVO) {
        orderCloudDevice.setCaseNumber(cloudDeviceVO.getCaseNumber());
        orderCloudDevice.setStartDate(cloudDeviceVO.getStartDate());
        orderCloudDevice.setExpireDate(cloudDeviceVO.getExpireDate());
        orderCloudDevice.setRemark(cloudDeviceVO.getRemark());
        orderCloudDevice.setDescription(cloudDeviceVO.getDescription());
        orderCloudDevice.setTag(cloudDeviceVO.getTag());
        Optional.ofNullable(cloudDeviceVO.getDbUrl()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setDbUrl(arg_0));
        Optional.ofNullable(cloudDeviceVO.getDbUsername()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setDbUsername(arg_0));
        Optional.ofNullable(cloudDeviceVO.getDbName()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setDbName(arg_0));
        Optional.ofNullable(cloudDeviceVO.getCostDeptId()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setCostDeptId(arg_0));
        Optional.ofNullable(cloudDeviceVO.getCostDeptName()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setCostDeptName(arg_0));
        Optional.ofNullable(cloudDeviceVO.getCostEmpId()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setCostEmpId(arg_0));
        Optional.ofNullable(cloudDeviceVO.getCostEmpName()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setCostEmpName(arg_0));
        orderCloudDevice.setArcheryId(cloudDeviceVO.getArcheryId());
        orderCloudDevice.setArcheryUrl(cloudDeviceVO.getArcheryUrl());
        orderCloudDevice.setArcheryPwd(cloudDeviceVO.getArcheryPwd());
        orderCloudDevice.setDbAdmin(cloudDeviceVO.getDbAdmin());
        orderCloudDevice.setActualCore(cloudDeviceVO.getActualCore());
        orderCloudDevice.setActualMemory(cloudDeviceVO.getActualMemory());
    }

    private void handlePendingState(OrderCloudDevice orderCloudDevice, OrderCloudDeviceVO cloudDeviceVO) {
        orderCloudDevice.setState(Optional.ofNullable(cloudDeviceVO.getExpireDate()).map(date -> date.isBefore(LocalDateTime.now()) ? 3 : 2).orElse(2));
        orderCloudDevice.setDbAdminPwd(cloudDeviceVO.getDbAdminPwd());
        this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
        if (!Boolean.FALSE.equals(cloudDeviceVO.getSendNotice()) && CloudDeviceStateEnum.COMPLETE.getValue().equals(orderCloudDevice.getState())) {
            this.sendCompleteNotification(orderCloudDevice);
        }
    }

    private void handleCompletedOrExpiredState(OrderCloudDevice orderCloudDevice, OrderCloudDeviceVO cloudDeviceVO) {
        orderCloudDevice.setState(Integer.valueOf(cloudDeviceVO.getExpireDate().isBefore(LocalDateTime.now()) ? 3 : 2));
        this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
    }

    public void sendCompleteNotification(OrderCloudDevice orderCloudDevice) {
        this.sendCompleteNotification(orderCloudDevice, null);
    }

    public void sendCompleteNotification(OrderCloudDevice orderCloudDevice, String userId) {
        OrderCloudDeviceVO emailVO;
        PreOrder preOrder = this.preOrderRepository.findBySid(orderCloudDevice.getOrderSid().longValue());
        if (null != preOrder) {
            PreOrderVO preOrderVO = new PreOrderVO();
            preOrderVO.doBackward((Object)preOrder);
            preOrderVO.setDetails(this.preOrderDetailService.getPreOrderDetails(orderCloudDevice.getOrderSid()));
            emailVO = this.setAttributeValue(preOrderVO.getFirstOrderDetail().getStrategySid(), preOrderVO);
        } else {
            OrderVO orderVO = this.orderQueryService.getOrderBySid(orderCloudDevice.getOrderSid().longValue());
            if (orderVO == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u8ba2\u5355%s\u4e0d\u5b58\u5728", orderCloudDevice.getOrderSid()));
            }
            emailVO = this.setAttributeValue(orderVO.getFirstOrderDetail().getStrategySid(), orderVO);
        }
        this.setEmailAttributes(emailVO, orderCloudDevice, userId);
        this.mailService.sendEmailCompleteCloudDevice(emailVO);
    }

    private void setEmailAttributes(OrderCloudDeviceVO emailVO, OrderCloudDevice orderCloudDevice, String userId) {
        emailVO.setApplicantDate(orderCloudDevice.getApplicantDate());
        emailVO.setApplicantId(orderCloudDevice.getApplicantId());
        emailVO.setExpireDate(orderCloudDevice.getExpireDate());
        emailVO.setRemark(orderCloudDevice.getRemark());
        emailVO.setCode(orderCloudDevice.getCode());
        emailVO.setCloud(orderCloudDevice.getCloud());
        emailVO.setTag(orderCloudDevice.getTag());
        emailVO.setDbUrl(orderCloudDevice.getDbUrl());
        emailVO.setArcheryId(orderCloudDevice.getArcheryId());
        emailVO.setArcheryUrl(orderCloudDevice.getArcheryUrl());
        emailVO.setArcheryPwd(orderCloudDevice.getArcheryPwd());
        emailVO.setKind(orderCloudDevice.getKind());
        emailVO.setUserId(userId);
    }

    public void autoApplication(OrderCloudDeviceAutoVO vo) {
        List devices = this.orderCloudDeviceRepository.findByOrderSid(vo.getOrderSid());
        for (OrderCloudDevice device : devices) {
            device.setStartDate(Optional.ofNullable(vo.getStartDate()).orElse(vo.getStartDate()));
            device.setExpireDate(Optional.ofNullable(vo.getExpireDate()).orElse(vo.getExpireDate()));
            device.setTag(Optional.ofNullable(vo.getTag()).orElse(vo.getTag()));
            device.setDescription(Optional.ofNullable(vo.getDescription()).orElse(vo.getDescription()));
            device.setState(Integer.valueOf(2));
        }
        this.orderCloudDeviceRepository.saveAll((Iterable)devices);
    }

    @Transactional
    public void changeDbPassword(@Valid OrderCloudDeviceDbVO vo) {
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceRepository.findById((Object)vo.getSid()).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL));
        Optional.ofNullable(vo.getArcheryPwd()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setArcheryPwd(arg_0));
        Optional.ofNullable(vo.getDbAdminPwd()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setDbAdminPwd(arg_0));
        this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
        if (vo.isSendMail()) {
            this.sendCompleteNotification(orderCloudDevice);
        }
    }

    public void checkExpiredCloudDevice() {
        List expiredDevices = this.orderCloudDeviceMapper.getExpiredDevices();
        expiredDevices.removeIf(a -> !MailUtil.shouldSendToday((Integer)a.getExpiredDays(), (int)a.getNotificationCycle()));
        Map<String, List<OrderCloudDeviceVO>> map = expiredDevices.stream().collect(Collectors.groupingBy(OrderCloudDeviceVO::getTenantId));
        for (Map.Entry<String, List<OrderCloudDeviceVO>> entry : map.entrySet()) {
            DeviceCloudExpiredNoticeDTO dto = new DeviceCloudExpiredNoticeDTO();
            dto.setTenantId(entry.getKey());
            dto.setTenantName(entry.getValue().get(0).getTenantName());
            dto.setExpiredDevices(entry.getValue());
            this.mailService.sendEmailExpiredCloudDevice(dto);
        }
    }

    public void sendStopSyncImageEmail() {
        List expiredDevices = this.orderCloudDeviceMapper.getAzureCloudExpiredDevices();
        for (OrderCloudDeviceVO expiredDevice : expiredDevices) {
            this.mailService.sendStopSyncImageEmail(expiredDevice);
        }
    }

    public void modApplication(OrderCloudDeviceVO cloudDeviceVO) {
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(cloudDeviceVO.getSid().longValue());
        if (orderCloudDevice == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("%s\u8bbe\u5907\u4e91\u8d44\u6e90\u4e0d\u5b58\u5728", cloudDeviceVO.getSid()));
        }
        orderCloudDevice.setCostDeptId(cloudDeviceVO.getCostDeptId());
        orderCloudDevice.setCostDeptName(cloudDeviceVO.getCostDeptName());
        orderCloudDevice.setCostEmpId(cloudDeviceVO.getCostEmpId());
        orderCloudDevice.setCostEmpName(cloudDeviceVO.getCostEmpName());
        Optional.ofNullable(cloudDeviceVO.getResAcquireMode()).ifPresent(arg_0 -> ((OrderCloudDevice)orderCloudDevice).setResAcquireMode(arg_0));
        this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
    }

    public void extendCloudDevice(OrderVO orderVO, OrderDetailVO detail) {
        String[] split;
        String deviceCode = detail.getDeviceCode();
        for (String deviceCodeSplit : split = deviceCode.split(String.valueOf(','))) {
            this.extendSingleDevice(orderVO, detail, deviceCodeSplit);
        }
    }

    private void extendSingleDevice(OrderVO orderVO, OrderDetailVO detail, String deviceCode) {
        LocalDateTime now;
        List deviceList = this.orderCloudDeviceRepository.findByCodeAndDisabled(deviceCode, false);
        OrderCloudDevice old = (OrderCloudDevice)deviceList.stream().findFirst().orElseThrow(() -> new BusinessException(CharSequenceUtil.format((CharSequence)"\u8bbe\u5907\u4e91\u8d44\u6e90[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{deviceCode})));
        OrderCloudDevice newDevice = new OrderCloudDevice();
        BeanUtils.copyProperties((Object)old, (Object)newDevice);
        newDevice.setSid(0L);
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(detail.getStrategySid().longValue());
        Integer tenancyPeriod = strategy.getTenancyPeriod();
        tenancyPeriod = Optional.ofNullable(orderVO.getBnpl()).map(BnplOrderVO::getTotalCount).orElse(tenancyPeriod);
        LocalDateTime expireTimeStart = now = LocalDateTime.now();
        if (old.getExpireDate() != null && old.getExpireDate().isAfter(now)) {
            expireTimeStart = newDevice.getExpireDate();
        }
        newDevice.setExpireDate(expireTimeStart.plusMonths(tenancyPeriod.intValue()).with(LocalTime.of(23, 59, 59)));
        newDevice.setState(CloudDeviceStateEnum.COMPLETE.getValue());
        newDevice.setOrderSid(orderVO.getSid());
        newDevice.setSourceFlag(CloudDeviceSourceEnum.ORDER.getValue());
        newDevice.setCreateDate(LocalDateTime.now());
        newDevice.setApplicantDate(LocalDateTime.now());
        newDevice.setApplicantId(orderVO.getUserId());
        newDevice.setApplicantName(orderVO.getUserName());
        EntityUtils.setCreateFields((BaseEntity)newDevice);
        old.setDisabled(true);
        old.setState(CloudDeviceStateEnum.EXPIRED.getValue());
        EntityUtils.setModifyFields((BaseEntity)old);
        this.orderCloudDeviceRepository.save((Object)old);
        this.orderCloudDeviceRepository.save((Object)newDevice);
    }

    public DeviceAttributeVO getStrategyAttributeByOrderSid(Long orderSid) {
        String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValuesByOrderSid(orderSid.longValue());
        return DeviceAttributeVO.parseDeviceAttributes((String)customAttributeStr);
    }

    public DeviceAttributeVO getStrategyAttributeByStrategySid(Long strategySid) {
        String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValues(strategySid.longValue());
        return DeviceAttributeVO.parseDeviceAttributes((String)customAttributeStr);
    }
}

