/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.dao.OrderDeviceCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.DeviceAttributeVO;
import com.digiwin.dap.middleware.omc.domain.remote.CloudDeviceInitVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.OrderDevice;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderDetailMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.business.OrderDeviceService;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrderDeviceServiceImpl
implements OrderDeviceService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderDeviceCrudService orderDeviceCrudService;
    @Autowired
    private PreOrderDetailMapper preOrderDetailMapper;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private IamService iamService;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private AuthService authService;

    public Integer createOrderEquip(long orderSid) {
        Integer count = this.goodsMapper.getOrderEquipCount(orderSid);
        if (count != null && count > 0) {
            ArrayList<OrderDevice> equips = new ArrayList<OrderDevice>();
            for (int i = 0; i < count; ++i) {
                OrderDevice device = new OrderDevice();
                device.setOrderSid(Long.valueOf(orderSid));
                device.setStatus(Integer.valueOf(0));
                device.setCode(UUID.randomUUID().toString());
                EntityUtils.setCreateFields((BaseEntity)device);
                equips.add(device);
            }
            this.orderDeviceCrudService.saveAll(equips);
            this.orderUpdateMapper.updateOrderAuthInit(orderSid);
        }
        return count;
    }

    public Integer createOrderEquip(PreOrderVO preOrderVO) {
        PreOrderDetailVO detail = preOrderVO.getFirstOrderDetail();
        Integer count = detail.getTotalUsageBound();
        boolean isCloud = Boolean.TRUE.equals(this.goodsMapper.findGoodsByCode(detail.getGoodsCode()).getCloud());
        if (isCloud) {
            Long strategySid = detail.getStrategySid();
            if (null != strategySid) {
                GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(strategySid.longValue());
                this.createCloudDevices(count, preOrderVO.getSid(), strategy, preOrderVO);
            }
        } else {
            this.createDevice(preOrderVO, count);
        }
        this.preOrderDetailMapper.updateOrderAuthorization(preOrderVO.getSid());
        return count;
    }

    private String getCloudString(PreOrderDetailVO detail) {
        List customAttributeVOList;
        String cloud = "";
        String customAttributeStr = this.orderCloudDeviceMapper.getCustomAttributeValues(detail.getStrategySid().longValue());
        try {
            customAttributeVOList = (List)JsonUtils.createObjectMapper().readValue(customAttributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new BusinessException(String.format("%s\u9500\u552e\u65b9\u6848\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", detail.getStrategySid()), (Throwable)e);
        }
        for (CustomAttributeVO attribute : customAttributeVOList) {
            if (!"cloud".equalsIgnoreCase(attribute.getId())) continue;
            cloud = attribute.getValue();
        }
        return cloud;
    }

    private void createDevice(PreOrderVO preOrderVO, Integer count) {
        if (count != null && count > 0) {
            ArrayList<OrderDevice> equips = new ArrayList<OrderDevice>();
            for (int i = 0; i < count; ++i) {
                OrderDevice device = new OrderDevice();
                device.setOrderSid(preOrderVO.getSid());
                device.setExpireDate(preOrderVO.getFirstOrderDetail().getExpiredDateTime());
                device.setOrderSource(Integer.valueOf(1));
                device.setStatus(Integer.valueOf(0));
                device.setCode(UUID.randomUUID().toString());
                EntityUtils.setCreateFields((BaseEntity)device);
                equips.add(device);
            }
            this.orderDeviceCrudService.saveAll(equips);
        }
    }

    public Integer createOrderEquip(long orderSid, String authCode) {
        Integer count = this.goodsMapper.getOrderEquipCount(orderSid);
        if (count != null && count > 0) {
            ArrayList<OrderDevice> equips = new ArrayList<OrderDevice>();
            for (int i = 0; i < count; ++i) {
                OrderDevice device = new OrderDevice();
                device.setOrderSid(Long.valueOf(orderSid));
                device.setStatus(Integer.valueOf(0));
                device.setCode(authCode);
                EntityUtils.setCreateFields((BaseEntity)device);
                equips.add(device);
            }
            this.orderDeviceCrudService.saveAll(equips);
            this.orderUpdateMapper.updateOrderAuthInit(orderSid);
        }
        return count;
    }

    public void createCloudDevices(Integer count, Long orderSid, GoodsStrategy strategy, PreOrderVO preOrderVO) {
        DeviceAttributeVO deviceAttributes = DeviceAttributeVO.parseDeviceAttributes((String)strategy.getCustomAttributesStr());
        String tenantId = preOrderVO.getTenantId();
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(Collections.singletonList(tenantId));
        CommonVO tenantInfo = tenantSimplesMap.getOrDefault(tenantId, new CommonVO());
        ArrayList<OrderCloudDevice> cloudDeviceVOS = new ArrayList<OrderCloudDevice>();
        for (int i = 0; i < count; ++i) {
            OrderCloudDevice device = new OrderCloudDevice();
            device.setOrderSid(orderSid);
            device.setCode(UUID.randomUUID().toString());
            device.setState(Integer.valueOf(0));
            device.setCloud(deviceAttributes.getCloud());
            device.setKind(deviceAttributes.getKind());
            device.setActualCore(deviceAttributes.getCore());
            device.setActualMemory(deviceAttributes.getMemory());
            device.setArea(deviceAttributes.getArea());
            device.setStartDate(preOrderVO.getFirstOrderDetail().getEffectiveDateTime());
            device.setExpireDate(preOrderVO.getFirstOrderDetail().getExpiredDateTime());
            device.setCostDeptId(tenantInfo.getCostDeptId());
            device.setCostDeptName(tenantInfo.getCostDeptName());
            device.setCostEmpId(tenantInfo.getCostEmpId());
            device.setCostEmpName(tenantInfo.getCostEmpName());
            device.setSourceFlag(CloudDeviceSourceEnum.PRE.getValue());
            device.setResAcquireMode(tenantInfo.getResAcquireMode());
            cloudDeviceVOS.add(device);
        }
        cloudDeviceVOS.forEach(EntityUtils::setCreateFields);
        this.orderCloudDeviceRepository.saveAll(cloudDeviceVOS);
        ArrayList<OrderCloudDeviceVO> orderCloudDeviceVOS = new ArrayList<OrderCloudDeviceVO>();
        for (OrderCloudDevice device : cloudDeviceVOS) {
            OrderCloudDeviceVO orderCloudDeviceVO = new OrderCloudDeviceVO();
            orderCloudDeviceVO.setSid(Long.valueOf(device.getSid()));
            orderCloudDeviceVO.setApplicantId(UserUtils.getUserId());
            orderCloudDeviceVO.setApplicantName(UserUtils.getUserName());
            orderCloudDeviceVO.setApplicantDate(LocalDateTime.now());
            orderCloudDeviceVOS.add(orderCloudDeviceVO);
        }
        this.orderCloudDeviceService.batchApplyCloudDevice(orderCloudDeviceVOS);
        preOrderVO.setCloudDevices(cloudDeviceVOS.stream().map(a -> new CloudDeviceInitVO(Long.valueOf(a.getSid()), a.getCode())).collect(Collectors.toList()));
    }

    public void createCloudDevices(OrderVO orderVO, Integer count, Long orderSid) {
        OrderDetailVO detail = orderVO.getFirstOrderDetail();
        if (StringUtils.hasLength((String)detail.getDeviceCode())) {
            this.orderCloudDeviceService.extendCloudDevice(orderVO, detail);
        } else {
            this.buyNewCloudDevice(orderVO, count, orderSid);
            this.authService.initGoods(orderVO, null);
        }
    }

    private void buyNewCloudDevice(OrderVO orderVO, Integer count, Long orderSid) {
        DeviceAttributeVO attribute = this.orderCloudDeviceService.getStrategyAttributeByOrderSid(orderSid);
        String tenantId = orderVO.getTenantId();
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(Collections.singletonList(tenantId));
        CommonVO tenantInfo = tenantSimplesMap.getOrDefault(tenantId, new CommonVO());
        ArrayList<OrderCloudDevice> cloudDeviceVOS = new ArrayList<OrderCloudDevice>();
        for (int i = 0; i < count; ++i) {
            OrderCloudDevice device = new OrderCloudDevice();
            device.setOrderSid(orderSid);
            device.setCode(UUID.randomUUID().toString());
            device.setState(Integer.valueOf(0));
            device.setCloud(attribute.getCloud());
            device.setKind(attribute.getKind());
            device.setActualCore(attribute.getCore());
            device.setActualMemory(attribute.getMemory());
            device.setArea(attribute.getArea());
            device.setCostDeptId(tenantInfo.getCostDeptId());
            device.setCostDeptName(tenantInfo.getCostDeptName());
            device.setCostEmpId(tenantInfo.getCostEmpId());
            device.setCostEmpName(tenantInfo.getCostEmpName());
            device.setSourceFlag(CloudDeviceSourceEnum.ORDER.getValue());
            device.setResAcquireMode(tenantInfo.getResAcquireMode());
            cloudDeviceVOS.add(device);
        }
        cloudDeviceVOS.forEach(EntityUtils::setCreateFields);
        this.orderCloudDeviceRepository.saveAll(cloudDeviceVOS);
        ArrayList<OrderCloudDeviceVO> orderCloudDeviceVOS = new ArrayList<OrderCloudDeviceVO>();
        for (OrderCloudDevice device : cloudDeviceVOS) {
            OrderCloudDeviceVO orderCloudDeviceVO = new OrderCloudDeviceVO();
            orderCloudDeviceVO.setSid(Long.valueOf(device.getSid()));
            orderCloudDeviceVO.setApplicantId(orderVO.getUserId());
            orderCloudDeviceVO.setApplicantName(orderVO.getUserName());
            orderCloudDeviceVO.setApplicantDate(LocalDateTime.now());
            orderCloudDeviceVOS.add(orderCloudDeviceVO);
        }
        this.orderCloudDeviceService.batchApplyCloudDevice(orderCloudDeviceVOS);
        orderVO.setCloudDevices(cloudDeviceVOS.stream().map(a -> new CloudDeviceInitVO(Long.valueOf(a.getSid()), a.getCode())).collect(Collectors.toList()));
    }

    public void createDevices(OrderVO orderVO, String userToken) {
        boolean created;
        Goods goods = this.goodsMapper.findGoodsBySid(orderVO.getFirstOrderDetail().getGoodsSid().longValue());
        boolean bl = created = goods != null && (goods.getEquip() != false || GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(goods.getCategoryId())) && goods.getCloud() != false;
        if (created) {
            AuthoredUser authoredUser = UserUtils.getAuthoredUser();
            if (authoredUser == null) {
                authoredUser = this.iamService.getUserInfo(userToken);
            }
            Integer userCount = this.goodsMapper.getUserCount(orderVO.getFirstOrderDetail().getStrategySid().longValue());
            Integer count = orderVO.getFirstOrderDetail().getQuantity() * userCount;
            this.createCloudDevices(orderVO, count, orderVO.getSid());
        }
    }
}

