/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.InvoiceTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.TossStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderLogEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.dao.InvoiceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderLogCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.EsCustomer;
import com.digiwin.dap.middleware.omc.domain.EscloudOrder;
import com.digiwin.dap.middleware.omc.domain.EscloudOrderDetail;
import com.digiwin.dap.middleware.omc.domain.EscloudTenantAuthorization;
import com.digiwin.dap.middleware.omc.domain.EscloudTenantGoods;
import com.digiwin.dap.middleware.omc.domain.pay.TradeQueryResponse;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.DwPayCallback;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Invoice;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderLog;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderSyncMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PaymentMapper;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.repository.PaymentRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderSyncService;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.util.ValidationUtil;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.I18nUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrderSyncServiceImpl
implements OrderSyncService {
    private static final Logger logger = LoggerFactory.getLogger(OrderSyncServiceImpl.class);
    private static final String INVOICE_TYPE_EMPTY = "\u767c\u7968\u985e\u578b\u4e0d\u53ef\u7a7a\u767d";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderLogCrudService orderLogCrudService;
    @Autowired
    private OrderSyncMapper orderSyncMapper;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private InvoiceCrudService invoiceCrudService;
    @Autowired
    private MailService mailService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private PaymentRepository paymentRepository;
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private OrderFlowService orderFlowService;
    @Autowired
    private CacService cacService;
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ProducerService producerService;
    @Value(value="${dap.middleware.deploy-area}")
    private String deployArea;

    public List<EscloudOrder> selectUnTossedOrder() {
        LinkedList<EscloudOrder> ret = new LinkedList<EscloudOrder>();
        boolean ali = DeployAreaEnum.isAliyun((String)this.deployArea);
        List orders = this.orderSyncMapper.selectUnTossedOrder(this.envProperties.getCountry(), ali);
        boolean isAzure = DeployAreaEnum.isAzure((String)this.deployArea);
        LinkedList sids = new LinkedList();
        HashMap errs = new HashMap();
        for (EscloudOrder o : orders) {
            if (isAzure && this.filterCheckbill(o, sids, errs)) continue;
            o.setSalesOrderDetailList(this.setDetails(Long.parseLong(o.getOrderId())));
            if (o.getEnterprise() == 0 && InvoiceTypeEnum.TRIPLET.name().equals(o.getInvoiceType())) {
                o.setCustomerName(o.getCompanyName());
            }
            if (StrUtils.isEmpty((String)o.getServiceCode()) && !InvoiceTypeEnum.PERSONAL_VAT_ORDINARY_INVOICE.name().equals(o.getInvoiceType()) && !InvoiceTypeEnum.DUPLEX.name().equals(o.getInvoiceType())) {
                EsCustomer customer = new EsCustomer();
                customer.setAccountId(o.getTenantSid());
                customer.setUserId(o.getEmail());
                customer.setCompany(o.getCustomerName());
                customer.setBusinessNumber(o.getUniformNumbers());
                customer.setContact(o.getUserName());
                customer.sethPhone(o.getCompanyTelephone());
                customer.setmPhone(o.getPhone());
                customer.setAddress(o.getCompanyAddress());
                customer.setDeliAddress(o.getRegisterAddress());
                customer.setInvoiceAddress(o.getAddress());
                customer.setCodeOfBank(o.getBankName());
                customer.setBankAccount(o.getBankAccount());
                o.setCustomer(customer);
            }
            ret.add(o);
        }
        if (isAzure && !CollectionUtils.isEmpty(sids)) {
            this.orderService.updateOrderCheckBillBatch(sids);
        }
        if (isAzure && !CollectionUtils.isEmpty(errs)) {
            try {
                this.producerService.msg(MessageBody.of((String)MailTypeEnum.OMC_CHECK_BILL_FAIL.name(), errs));
            }
            catch (Exception e) {
                logger.error("\u3010\u53d6\u5f97\u672a\u629b\u8f6c\u8d22\u52a1\u7684\u8ba2\u5355-\u53d1\u9001\u6821\u9a8c\u5931\u8d25\u8ba2\u5355\u90ae\u4ef6\u5931\u8d25\u3011", (Throwable)e);
            }
        }
        return ret;
    }

    private boolean filterCheckbill(EscloudOrder o, List<Long> list, Map<String, String> errs) {
        long sid = Long.parseLong(o.getOrderId());
        String orderCode = o.getOrderCode();
        boolean bool = this.goodsMapper.needContractDate(sid);
        if (bool) {
            errs.put(orderCode, I18nUtils.getMessage((String)I18nCode.CODE_10003.getCode(), (Locale)Locale.CHINA));
            return true;
        }
        Invoice invoice = this.invoiceCrudService.findByOrderSid(sid);
        if (invoice == null) {
            errs.put(orderCode, I18nUtils.getMessage((String)I18nCode.CODE_30001.getCode(), (Locale)Locale.CHINA));
            return true;
        }
        String error = this.checkInvoice(invoice);
        if (error != null) {
            errs.put(orderCode, error);
            return true;
        }
        list.add(sid);
        return false;
    }

    public String checkInvoice(Invoice invoice) {
        String error = null;
        if (InvoiceTypeEnum.ENTERPRISE_VAT_TRANSFER_INVOICE.name().equals(invoice.getType())) {
            error = ValidationUtil.validate((Object)invoice.getCompany());
        } else if (InvoiceTypeEnum.ENTERPRISE_VAT_ORDINARY_INVOICE.name().equals(invoice.getType())) {
            error = ValidationUtil.validate((Object)invoice.getCompany1());
        } else if (InvoiceTypeEnum.PERSONAL_VAT_ORDINARY_INVOICE.name().equals(invoice.getType())) {
            error = ValidationUtil.validate((Object)invoice.getPerson());
        } else if (InvoiceTypeEnum.TRIPLET.name().equalsIgnoreCase(invoice.getType())) {
            error = ValidationUtil.validate((Object)invoice.getTriplet());
        } else if (InvoiceTypeEnum.DUPLEX.name().equalsIgnoreCase(invoice.getType())) {
            error = ValidationUtil.validate((Object)invoice.getDuplex());
        } else if (!StringUtils.hasLength((String)invoice.getType())) {
            error = INVOICE_TYPE_EMPTY;
        }
        return error;
    }

    public List<EscloudOrder> selectNoInvoiceCodeOrder() {
        List orders = this.orderSyncMapper.selectNoInvoiceCodeOrder();
        orders.forEach(o -> o.setSalesOrderDetailList(this.setDetails(Long.parseLong(o.getOrderId()))));
        return orders;
    }

    private List<EscloudOrderDetail> setDetails(long orderSid) {
        List mailFinanceDetails = this.orderSyncMapper.findUnTossedOrderDetailByOrderSid(orderSid);
        ArrayList<EscloudOrderDetail> salesOrderDetailList = new ArrayList<EscloudOrderDetail>();
        mailFinanceDetails.forEach(i -> {
            EscloudOrderDetail detail = new EscloudOrderDetail();
            detail.setItemId(i.getItemId());
            detail.setItemName(i.getItemName());
            if (i.getQuantity() != null) {
                detail.setQuantity((double)i.getQuantity().intValue());
            }
            detail.setTaxRate(i.getTaxRate());
            detail.setDiscountPrice(i.getDiscountPrice());
            double unitPrice = 0.0;
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
                unitPrice = i.getNoTaxPrice() / (double)i.getQuantity().intValue();
                detail.setStandardPrice(i.getNoTaxPrice());
            } else {
                if (i.getQuantity() != null) {
                    unitPrice = i.getTotalPrice() / (double)i.getQuantity().intValue();
                }
                detail.setStandardPrice(i.getTotalPrice());
            }
            if (i.getQuantity() != null) {
                BigDecimal bg = BigDecimal.valueOf(unitPrice);
                unitPrice = bg.setScale(2, 6).doubleValue();
                detail.setUnitPrice(unitPrice);
            }
            salesOrderDetailList.add(detail);
        });
        return salesOrderDetailList;
    }

    public void updateInvoiceCode(long orderSid, String invoiceCode) {
        Invoice invoice = this.invoiceCrudService.findByOrderSid(orderSid);
        if (invoice != null) {
            invoice.setInvoiceCode(invoiceCode);
            this.invoiceCrudService.update((BaseEntity)invoice);
        }
    }

    public void updateOrderTossStatus(boolean isSucceed, long orderSid, String dgwFacOrderCode, String dgwFacContractCode) {
        if (isSucceed) {
            this.orderRepository.findById((Object)orderSid).ifPresent(row -> {
                row.setDgwFacOrderCode(dgwFacOrderCode);
                row.setDgwFacContractCode(dgwFacContractCode);
                row.setTossStatus(TossStatusEnum.Y.name());
                row.setTossDate(LocalDateTime.now());
                this.orderRepository.save(row);
                this.mailService.sendTossSuccess(orderSid);
            });
        } else {
            OrderLog orderLog = new OrderLog();
            orderLog.setOrderSid(Long.valueOf(orderSid));
            orderLog.setType(OrderLogEnum.TOSS_FINANCE.name());
            orderLog.setReason(dgwFacOrderCode);
            this.orderLogCrudService.create((BaseEntity)orderLog);
            this.orderRepository.findById((Object)orderSid).ifPresent(row -> {
                row.setTossStatus(TossStatusEnum.E.name());
                row.setTossDate(LocalDateTime.now());
                this.orderRepository.save(row);
                if (row.getShopping() == 0) {
                    this.mailService.sendTossFail(row, dgwFacOrderCode);
                }
            });
        }
    }

    public void dwPayCallback(DwPayCallback payCallback, long orderSid) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (order.getShopping() == 0) {
            Payment payment = new Payment(payCallback);
            this.orderService.payOrder(order.getSid(), order.getPayPrice(), payment, true);
            OrderVO orderVO = this.orderQueryService.getOrderByOrderCode(order.getOrderCode());
            this.orderFlowService.checkCallbackBaseOrder(orderVO);
        } else if (order.getShopping() == 1) {
            List orders = this.orderQueryService.getCartOrders(order.getCartCode(), Boolean.TRUE.booleanValue());
            List payments = orders.stream().map(it -> {
                Payment payment = new Payment(payCallback);
                payment.setOrderSid(it.getSid());
                payment.setAmount(payment.getAmount() == null ? it.getPayPrice() : payment.getAmount());
                EntityUtils.setCreateFields((BaseEntity)payment);
                return payment;
            }).collect(Collectors.toList());
            this.orderService.payOrderCart(order.getCartCode(), TradeStatusEnum.TRADE_SUCCESS.name(), payments, true);
            this.orderFlowService.checkCallbackCartOrder(order.getSid(), order.getCartCode(), orders);
        }
    }

    public void payCallback(TradeQueryResponse tradeQuery, long orderSid) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (order.getShopping() == 0) {
            Payment payment = new Payment(tradeQuery);
            this.orderService.payOrder(order.getSid(), order.getPayPrice(), payment, true);
            OrderVO orderVO = this.orderQueryService.getOrderByOrderCode(order.getOrderCode());
            this.orderFlowService.checkCallbackBaseOrder(orderVO);
        } else if (order.getShopping() == 1) {
            List orders = this.orderQueryService.getCartOrders(order.getCartCode(), Boolean.TRUE.booleanValue());
            List payments = orders.stream().map(it -> {
                Payment payment = new Payment(tradeQuery);
                payment.setOrderSid(it.getSid());
                payment.setAmount(payment.getAmount() == null ? it.getPayPrice() : payment.getAmount());
                EntityUtils.setCreateFields((BaseEntity)payment);
                return payment;
            }).collect(Collectors.toList());
            this.orderService.payOrderCart(order.getCartCode(), tradeQuery.getTrade_status().name(), payments, true);
            this.orderFlowService.checkCallbackCartOrder(order.getSid(), order.getCartCode(), orders);
        }
    }

    public EscloudTenantAuthorization getTenantAuthorization(String tenantId) {
        EscloudTenantAuthorization escloudTenantAuthorization = null;
        List authorizationResultVOS = this.cacService.queryAllAuthorization(tenantId);
        if (!CollectionUtils.isEmpty((Collection)authorizationResultVOS)) {
            ArrayList<String> tenantIds = new ArrayList<String>();
            tenantIds.add(tenantId);
            List tenantInfos = this.iamService.getTenantSimples(tenantIds);
            if (CollectionUtils.isEmpty((Collection)tenantInfos)) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", tenantId));
            }
            escloudTenantAuthorization = new EscloudTenantAuthorization((CommonVO)tenantInfos.get(0));
            List goodsCodes = authorizationResultVOS.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
            List products = this.orderSyncMapper.getAuthProduct(tenantId, goodsCodes);
            List businessCodes = this.orderSyncMapper.getBusinessCodesByOrder(tenantId, goodsCodes);
            List queryCodes = businessCodes.stream().map(EscloudTenantGoods::getModuleCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(queryCodes)) {
                businessCodes.addAll(this.orderSyncMapper.getBusinessCodesByPreOrder(tenantId, goodsCodes));
            } else {
                goodsCodes.removeAll(queryCodes);
                if (!CollectionUtils.isEmpty(goodsCodes)) {
                    businessCodes.addAll(this.orderSyncMapper.getBusinessCodesByPreOrder(tenantId, goodsCodes));
                }
            }
            products.forEach(product -> product.getProductModules().forEach(goods -> {
                authorizationResultVOS.forEach(a -> {
                    if (goods.getModuleCode().equals(a.getCode())) {
                        String contractState = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? (a.getExpiredTime().isBefore(LocalDateTime.now()) ? "G" : "B") : (a.getExpiredTime().isBefore(LocalDateTime.now()) ? "G0" : "B0");
                        goods.setContractState(contractState);
                        goods.setContractStartDate(a.getEffectiveTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                        goods.setContractExpiryDate(a.getExpiredTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                    }
                });
                businessCodes.forEach(b -> {
                    if (b.getModuleCode().equals(goods.getModuleCode())) {
                        goods.setSalesItCode(b.getBusinessCodes().isEmpty() ? null : (String)b.getBusinessCodes().get(0));
                    }
                });
            }));
            escloudTenantAuthorization.setCustomerService(products);
        }
        return escloudTenantAuthorization;
    }
}

