/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderReportRequestVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderReportVO;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.service.business.ReportDataService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.github.pagehelper.page.PageMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ReportDataServiceImpl
implements ReportDataService {
    @Resource
    private IamService iamService;
    @Resource
    private PreOrderMapper preOrderMapper;
    @Resource
    private CacService cacService;

    public List<PreOrderReportVO> queryReport(PreOrderReportRequestVO input) {
        input.setShipmentScenarios(Optional.ofNullable(input.getShipmentScenarios()).orElse(Arrays.asList(ShipmentScenarioEnum.PURCHASE.getValue(), ShipmentScenarioEnum.EXTENSION.getValue())));
        input.setTestTenant(Boolean.valueOf(false));
        PageMethod.startPage((int)input.getPageNum(), (int)input.getPageSize());
        return this.preOrderMapper.findPreorder4Report(input);
    }

    public List<PreOrderReportVO> queryOrderCode(PreOrderRelateCodeVO input) {
        input.setShipmentScenarios(Optional.ofNullable(input.getShipmentScenarios()).orElse(Arrays.asList(ShipmentScenarioEnum.PURCHASE.getValue(), ShipmentScenarioEnum.EXTENSION.getValue())));
        input.setStatus(Optional.ofNullable(input.getStatus()).orElse(Arrays.asList(1)));
        input.setSourceId("OrderPayment");
        List cac = this.cacService.queryCacRecordCode(input);
        List omc = this.preOrderMapper.findRelateOrderCode(input);
        omc.addAll(cac);
        return omc;
    }
}

