/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.business.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.ServiceStatusEnum;
import com.digiwin.dap.middleware.omc.dao.ServicerOrderDetailCrudService;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.ServicerOrderDetail;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.business.ServicerOrderDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServicerOrderDetailServiceImpl
implements ServicerOrderDetailService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private ServicerOrderDetailCrudService servicerOrderDetailCrudService;

    @Transactional
    public long createServicerOrderDetail(OrderVO orderVO) {
        OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
        Goods goods = this.goodsMapper.findGoodsByCode(orderDetailVO.getGoodsCode());
        if (goods == null || StrUtils.isEmpty((String)goods.getServicerId())) {
            return 0L;
        }
        ServicerOrderDetail detail = new ServicerOrderDetail();
        detail.setOrderDetailSid(orderDetailVO.getSid());
        detail.setServicerId(goods.getServicerId());
        detail.setServicerName(goods.getServicerName());
        detail.setServiceStatus(ServiceStatusEnum.UNDELIVERED.getValue());
        return this.servicerOrderDetailCrudService.create((BaseEntity)detail);
    }
}

