/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.dealer.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.AuthDataVO;
import com.digiwin.dap.middleware.omc.domain.DealerOrderVO;
import com.digiwin.dap.middleware.omc.domain.ImportExcelResultVO;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.excel.BatchAuthErrorExcel;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.dealer.DealerOrderAuthorService;
import com.digiwin.dap.middleware.omc.service.dealer.DealerOrderService;
import com.digiwin.dap.middleware.omc.support.remote.DmcSdkService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DealerOrderAuthorServiceImpl
implements DealerOrderAuthorService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private DealerOrderService dealerOrderService;
    @Autowired
    private IamService iamService;
    @Autowired
    private DmcSdkService dmcSdkService;

    public StdData<String> paramCheck(DealerOrderVO dealerOrderVO) {
        AuthDataVO authDataVO = this.goodsMapper.getAuthDataVO(dealerOrderVO.getAuthCode());
        if (authDataVO == null) {
            return StdData.of((int)I18nCode.CODE_10014.getId(), (String)I18nCode.CODE_10014.getMessage(new Object[]{dealerOrderVO.getAuthCode()}));
        }
        dealerOrderVO.setAuthEmail(authDataVO.getAuthEmail());
        if (authDataVO.getStatus() == 1) {
            if (authDataVO.getTenantSid() == UserUtils.getTenantSid()) {
                return StdData.of((int)I18nCode.CODE_10011.getId(), (String)I18nCode.CODE_10011.getMessage());
            }
            return StdData.of((int)I18nCode.CODE_10012.getId(), (String)I18nCode.CODE_10012.getMessage());
        }
        if (authDataVO.getStatus() == 2) {
            return StdData.of((int)I18nCode.CODE_10013.getId(), (String)I18nCode.CODE_10013.getMessage());
        }
        List details = this.goodsMapper.findOrderDetail(authDataVO.getAuthSid().longValue());
        if (details.isEmpty()) {
            return StdData.of((int)I18nCode.CODE_10015.getId(), (String)I18nCode.CODE_10015.getMessage(new Object[]{dealerOrderVO.getAuthCode()}));
        }
        details.forEach(OrderDetailVO::handleCustomUnit);
        List goodsCodes = details.stream().map(OrderDetailVO::getGoodsCode).collect(Collectors.toList());
        List validCodes = this.goodsMapper.getOnSaleByGoodsCode(goodsCodes);
        goodsCodes.removeAll(validCodes);
        if (!goodsCodes.isEmpty()) {
            return StdData.of((int)I18nCode.CODE_50001.getId(), (String)I18nCode.CODE_50001.getMessage(new Object[]{String.join((CharSequence)",", goodsCodes)}));
        }
        long count = details.stream().filter(OrderDetailVO::getEquip).count();
        if (count > 1L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10002);
        }
        dealerOrderVO.setAuthData(authDataVO);
        dealerOrderVO.setOrderDetails(details);
        dealerOrderVO.setAuthoredUser(UserUtils.getAuthoredUser());
        TenantVO tenant = this.iamService.getTenantSimple(UserUtils.getTenantId(), UserUtils.getUserSid());
        if (tenant != null) {
            dealerOrderVO.getOrder().setTestTenant(tenant.getTestTenant());
            dealerOrderVO.getOrder().setCustomerId(tenant.getCustomerId());
            dealerOrderVO.getOrder().setEmail(tenant.getUserEmail());
            dealerOrderVO.getOrder().setTelephone(tenant.getUserTelephone());
        }
        return StdData.ok((Object)"");
    }

    public ImportExcelResultVO batchDealerAuthor(String fileId) {
        List batchAuthExcels = this.dmcSdkService.getAuthData(fileId);
        ArrayList batchAuthErrorExcels = new ArrayList();
        batchAuthExcels.forEach(batchAuthExcel -> {
            DealerOrderVO dealerOrderVO = new DealerOrderVO();
            dealerOrderVO.setAuthCode(batchAuthExcel.getAuthorCode());
            StdData stdData = this.paramCheck(dealerOrderVO);
            if (!stdData.getSuccess().booleanValue()) {
                BatchAuthErrorExcel batchAuthErrorExcel = new BatchAuthErrorExcel();
                batchAuthErrorExcel.setAuthorCode(batchAuthExcel.getAuthorCode());
                batchAuthErrorExcel.setRemark(stdData.getMessage());
                batchAuthErrorExcels.add(batchAuthErrorExcel);
                return;
            }
            this.dealerOrderService.createOrder(dealerOrderVO);
        });
        ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
        importExcelResultVO.setErrorCount(Integer.valueOf(batchAuthErrorExcels.size()));
        importExcelResultVO.setSuccessCount(Integer.valueOf(batchAuthExcels.size() - batchAuthErrorExcels.size()));
        this.dmcSdkService.uploadFileAndShare(batchAuthErrorExcels, importExcelResultVO);
        return importExcelResultVO;
    }
}

