/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.dealer.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailItemCrudService;
import com.digiwin.dap.middleware.omc.dao.PaymentCrudService;
import com.digiwin.dap.middleware.omc.domain.DealerOrderVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderDetail;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.service.business.OrderDeviceService;
import com.digiwin.dap.middleware.omc.service.dealer.DealerOrderService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DealerOrderServiceImpl
implements DealerOrderService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private PaymentCrudService paymentCrudService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderDetailItemCrudService orderDetailItemCrudService;
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderDeviceService orderDeviceService;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public List<Long> createOrder(DealerOrderVO dealerOrderVO) {
        ArrayList orders = new ArrayList();
        ArrayList orderDetails = new ArrayList();
        ArrayList orderDetailItems = new ArrayList();
        ArrayList payments = new ArrayList();
        ArrayList equips = new ArrayList();
        dealerOrderVO.getOrderDetails().forEach(detailVO -> {
            Order order = (Order)dealerOrderVO.getOrder().doForward();
            order.setSid(SnowFlake.getInstance().newId());
            order.setOrderCode(this.orderCrudService.generateDealOrderCode(this.envProperties.getCountry()));
            order.setOrderStatus(Integer.valueOf(1));
            order.setOrderSource(OrderSourceEnum.BossOffline.name());
            order.setRemark(I18nCode.CODE_10016.getMessage(new Object[]{dealerOrderVO.getAuthCode(), dealerOrderVO.getAuthData().getDealerName()}));
            order.setComment(dealerOrderVO.getAuthCode());
            order.setCategoryId(detailVO.getCategoryId());
            order.setGoodsCode(detailVO.getGoodsCode());
            orders.add(order);
            if (detailVO.getEquip().booleanValue() || GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(detailVO.getCategoryId())) {
                equips.add(order.getSid());
            }
            OrderDetail orderDetail = (OrderDetail)detailVO.doForward();
            orderDetail.setSid(SnowFlake.getInstance().newId());
            orderDetail.setOrderSid(Long.valueOf(order.getSid()));
            orderDetails.add(orderDetail);
            List orderDetailItemList = this.goodsMapper.findOrderDetailItem(detailVO.getStrategySid().longValue());
            for (OrderDetailItemVO itemVO : orderDetailItemList) {
                itemVO.setOrderDetailSid(Long.valueOf(orderDetail.getSid()));
                orderDetailItems.add(itemVO.doForward());
            }
            Payment payment = this.paymentService.getPayment(order.getSid(), BigDecimal.ZERO, PaymentTypeEnum.Offline);
            payments.add(payment);
        });
        orders.forEach(EntityUtils::setCreateFields);
        orderDetails.forEach(EntityUtils::setCreateFields);
        orderDetailItems.forEach(EntityUtils::setCreateFields);
        this.orderCrudService.saveAll(orders);
        this.orderDetailCrudService.saveAll(orderDetails);
        this.orderDetailItemCrudService.saveAll(orderDetailItems);
        this.paymentCrudService.saveAll(payments);
        equips.forEach(o -> this.orderDeviceService.createOrderEquip(o.longValue(), dealerOrderVO.getAuthCode()));
        List<Long> orderSids = orders.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        StdData stdData = this.cacService.batchAuth(orderSids, dealerOrderVO.getAuthData(), UserUtils.getToken());
        if (!stdData.getSuccess().booleanValue()) {
            this.mailService.sendEmailDealerOrderFail(dealerOrderVO, I18nCode.CODE_10004.getMessage());
            for (OrderDetailVO orderDetailVO : dealerOrderVO.getOrderDetails()) {
                this.mailService.sendEmailDealerOrderFailToPm(dealerOrderVO, orderDetailVO, I18nCode.CODE_10004.getMessage());
            }
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10008);
        }
        this.orderUpdateMapper.updateOrdersAuthorization(orderSids);
        this.goodsMapper.updateAuthData(dealerOrderVO.getOrder().getTenantSid().longValue(), dealerOrderVO.getOrder().getTenantId(), dealerOrderVO.getOrder().getTenantName(), dealerOrderVO.getAuthCode());
        return orderSids;
    }
}

