/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderFlowEnum;
import com.digiwin.dap.middleware.omc.domain.CartOrderVO;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OfflineVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChainProxy;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderStepComparator;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderStepComparator;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderFlowService {
    @Autowired
    private List<BaseOrderFlow> baseOrderFlows;
    @Autowired
    private List<CartOrderFlow> cartOrderFlows;

    public void submitBaseOrder(OrderVO orderVO) {
        OrderFlowChainProxy ofc = new OrderFlowChainProxy(this.baseOrderFlows, (Comparator)BaseOrderStepComparator.INSTANCE);
        ofc.doBegin(OrderComm.baseOrder((OrderFlowEnum)OrderFlowEnum.UNPAID, (OrderVO)orderVO));
    }

    public void checkBaseOrder(OrderVO orderVO) {
        OrderComm orderComm = OrderComm.baseOrder((OrderFlowEnum)OrderFlowEnum.PAID, (OrderVO)orderVO);
        OrderFlowChainProxy ofc = new OrderFlowChainProxy(this.baseOrderFlows, (Comparator)BaseOrderStepComparator.INSTANCE);
        ofc.doBegin(orderComm);
    }

    public void checkOfflineBaseOrder(OrderVO orderVO, OfflineVO offline) {
        OrderComm orderComm = OrderComm.baseOrder((OrderFlowEnum)OrderFlowEnum.PAID, (OrderVO)orderVO);
        orderComm.setOff(Boolean.valueOf(true));
        orderComm.setOffline(offline);
        OrderFlowChainProxy ofc = new OrderFlowChainProxy(this.baseOrderFlows, (Comparator)BaseOrderStepComparator.INSTANCE);
        ofc.doBegin(orderComm);
    }

    public void checkCallbackBaseOrder(OrderVO orderVO) {
        OrderComm orderComm = OrderComm.baseOrder((OrderFlowEnum)OrderFlowEnum.PAID, (OrderVO)orderVO);
        orderComm.setOff(Boolean.valueOf(true));
        orderComm.setCallback(Boolean.valueOf(true));
        OrderFlowChainProxy ofc = new OrderFlowChainProxy(this.baseOrderFlows, (Comparator)BaseOrderStepComparator.INSTANCE);
        ofc.doBegin(orderComm);
    }

    public void submitCartOrder(CartOrderVO cartOrderVO) {
        OrderFlowChainProxy osc = new OrderFlowChainProxy(this.cartOrderFlows, (Comparator)CartOrderStepComparator.INSTANCE);
        osc.doBegin(OrderComm.cartOrder((OrderFlowEnum)OrderFlowEnum.UNPAID, (CartOrderVO)cartOrderVO));
    }

    public void submitPackOrder(PackOrderVO packOrderVO) {
        OrderFlowChainProxy ofc = new OrderFlowChainProxy(this.cartOrderFlows, (Comparator)CartOrderStepComparator.INSTANCE);
        ofc.doBegin(OrderComm.packOrder((OrderFlowEnum)OrderFlowEnum.UNPAID, (PackOrderVO)packOrderVO));
    }

    public void checkCartOrder(long cartSid, String cartCode) {
        OrderComm orderComm = OrderComm.checkCartOrder((OrderFlowEnum)OrderFlowEnum.PAID, (long)cartSid, (String)cartCode);
        OrderFlowChainProxy osc = new OrderFlowChainProxy(this.cartOrderFlows, (Comparator)CartOrderStepComparator.INSTANCE);
        osc.doBegin(orderComm);
    }

    public void checkOfflineCartOrder(long cartSid, String cartCode, OfflineVO offline) {
        OrderComm orderComm = OrderComm.checkCartOrder((OrderFlowEnum)OrderFlowEnum.PAID, (long)cartSid, (String)cartCode);
        orderComm.setOff(Boolean.valueOf(true));
        orderComm.setOffline(offline);
        OrderFlowChainProxy osc = new OrderFlowChainProxy(this.cartOrderFlows, (Comparator)CartOrderStepComparator.INSTANCE);
        osc.doBegin(orderComm);
    }

    public void checkCallbackCartOrder(long cartSid, String cartCode, List<OrderVO> orders) {
        OrderComm orderComm = OrderComm.checkCartOrder((OrderFlowEnum)OrderFlowEnum.PAID, (long)cartSid, (String)cartCode);
        orderComm.setOrders(orders);
        orderComm.setOff(Boolean.valueOf(true));
        orderComm.setCallback(Boolean.valueOf(true));
        OrderFlowChainProxy osc = new OrderFlowChainProxy(this.cartOrderFlows, (Comparator)CartOrderStepComparator.INSTANCE);
        osc.doBegin(orderComm);
    }
}

