/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.core.domian;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderFlowEnum;
import com.digiwin.dap.middleware.omc.domain.CartOrderVO;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OfflineVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.GoodsType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderComm {
    private OrderFlowEnum step;
    private OrderCategoryEnum category;
    private Long cartSid;
    private String cartCode;
    private OrderVO order;
    private CartOrderVO cartOrder;
    private PackOrderVO packOrder;
    private List<OrderVO> orders;
    private Map<String, GoodsType> goodsType = new HashMap();
    private Boolean off;
    private OfflineVO offline;
    private Boolean callback;
    private Boolean bnpl;

    public static OrderComm baseOrder(OrderFlowEnum step, OrderVO order) {
        OrderComm orderComm = new OrderComm();
        orderComm.setStep(step);
        orderComm.setCategory(OrderCategoryEnum.BASE_ORDER);
        orderComm.setCartSid(order.getSid());
        orderComm.setCartCode(order.getOrderCode());
        orderComm.setOrder(order);
        orderComm.setOff(Boolean.valueOf(false));
        orderComm.setCallback(Boolean.valueOf(false));
        return orderComm;
    }

    public static OrderComm cartOrder(OrderFlowEnum step, CartOrderVO cartOrder) {
        OrderComm orderComm = new OrderComm();
        orderComm.setStep(step);
        orderComm.setCategory(OrderCategoryEnum.CART_ORDER);
        orderComm.setCartOrder(cartOrder);
        orderComm.setOrders(cartOrder.getOrders());
        orderComm.setOff(Boolean.valueOf(false));
        orderComm.setCallback(Boolean.valueOf(false));
        return orderComm;
    }

    public static OrderComm packOrder(OrderFlowEnum step, PackOrderVO packOrder) {
        OrderComm orderComm = new OrderComm();
        orderComm.setStep(step);
        orderComm.setCategory(OrderCategoryEnum.PACK_ORDER);
        orderComm.setPackOrder(packOrder);
        orderComm.setOrders(packOrder.getOrders());
        orderComm.setOff(Boolean.valueOf(false));
        orderComm.setCallback(Boolean.valueOf(false));
        return orderComm;
    }

    public static OrderComm checkCartOrder(OrderFlowEnum step, long cartSid, String cartCode) {
        OrderComm orderComm = new OrderComm();
        orderComm.setStep(step);
        orderComm.setCategory(OrderCategoryEnum.CART_ORDER);
        orderComm.setCartSid(Long.valueOf(cartSid));
        orderComm.setCartCode(cartCode);
        orderComm.setOff(Boolean.valueOf(false));
        orderComm.setCallback(Boolean.valueOf(false));
        return orderComm;
    }

    public OrderFlowEnum getStep() {
        return this.step;
    }

    public void setStep(OrderFlowEnum step) {
        this.step = step;
    }

    public OrderCategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(OrderCategoryEnum category) {
        this.category = category;
    }

    public Long getCartSid() {
        return this.cartSid;
    }

    public void setCartSid(Long cartSid) {
        this.cartSid = cartSid;
    }

    public String getCartCode() {
        return this.cartCode;
    }

    public void setCartCode(String cartCode) {
        this.cartCode = cartCode;
    }

    public OrderVO getOrder() {
        return this.order;
    }

    public void setOrder(OrderVO order) {
        this.order = order;
    }

    public CartOrderVO getCartOrder() {
        return this.cartOrder;
    }

    public void setCartOrder(CartOrderVO cartOrder) {
        this.cartOrder = cartOrder;
    }

    public PackOrderVO getPackOrder() {
        return this.packOrder;
    }

    public void setPackOrder(PackOrderVO packOrder) {
        this.packOrder = packOrder;
    }

    public List<OrderVO> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderVO> orders) {
        this.orders = orders;
    }

    public GoodsType getGoodsType(String orderCode) {
        return (GoodsType)this.goodsType.get(orderCode);
    }

    public void setGoodsType(String orderCode, GoodsType goodsType) {
        this.goodsType.put(orderCode, goodsType);
    }

    public Boolean getOff() {
        return this.off;
    }

    public void setOff(Boolean off) {
        this.off = off;
    }

    public OfflineVO getOffline() {
        return this.offline;
    }

    public void setOffline(OfflineVO offline) {
        this.offline = offline;
    }

    public Boolean getCallback() {
        return this.callback;
    }

    public void setCallback(Boolean callback) {
        this.callback = callback;
    }

    public Boolean getBnpl() {
        return this.bnpl;
    }

    public void setBnpl(Boolean bnpl) {
        this.bnpl = bnpl;
    }
}

