/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.paid;

import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationPaidStep
implements BaseOrderFlow {
    @Autowired
    private AuthService authService;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        AuthorizationVO authorizationVO;
        OrderVO orderVO = body.getOrder();
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        if (!orderVO.getAuthorization().booleanValue()) {
            ResponseResult result = body.getOff() != false || OrderSourceEnum.BossOnline.name().equalsIgnoreCase(orderVO.getOrderSource()) || OrderSourceEnum.BossOffline.name().equalsIgnoreCase(orderVO.getOrderSource()) ? this.authService.addAuthorizationDefault(orderVO) : this.authService.addAuthorization(orderVO);
            context.setAuth(Boolean.valueOf(result.isSuccess()));
            context.setAuthMessage(result.getMessage());
            context.setAuthInfo(result.getAuthInfo());
        } else {
            context.setAuth(Boolean.valueOf(true));
            context.setAuthMessage("\u5df2\u7ecf\u6388\u6743");
        }
        if (GoodsCategoryEnum.isApp((String)orderVO.getFirstOrderDetail().getCategoryId()) && null != (authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(orderVO.getTenantId(), orderVO.getFirstOrderDetail().getGoodsCode()))) {
            this.orderUpdateMapper.updateOrderShipmentDate(LocalDateTime.now(), authorizationVO.getExpiredTime(), orderVO.getSid().longValue());
        }
        OrderFlowContextHolder.setContext((OrderFlowVO)context);
        chain.doNextStep(body);
    }
}

