/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.paid;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.DeviceAttributeVO;
import com.digiwin.dap.middleware.omc.domain.remote.CloudDeviceInitVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.service.business.OrderDeviceService;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.GoodsType;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.order.paid.InitGoodsPaidStep;
import com.digiwin.dap.middleware.omc.service.flow.order.paid.PlatformGoodsPaidStep;
import com.digiwin.dap.middleware.omc.service.flow.order.paid.SendMailPaidStep;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DeviceCodePaidStep
implements BaseOrderFlow {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderDeviceService orderDeviceService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private IamService iamService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        OrderVO orderVO = body.getOrder();
        OrderDetailVO detail = orderVO.getFirstOrderDetail();
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        if (Boolean.FALSE.equals(context.getFirstPay())) {
            return;
        }
        Goods goods = this.goodsMapper.findGoodsBySid(detail.getGoodsSid().longValue());
        if (goods == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_50002, new Object[]{orderVO.getGoodsCode()});
        }
        GoodsType goodsType = new GoodsType(goods);
        if (goodsType.isEquip() && !goodsType.isCloud()) {
            if (!orderVO.getAuthorization().booleanValue()) {
                Integer count = this.orderDeviceService.createOrderEquip(orderVO.getSid().longValue());
                context.setAuthResponse(new ResponseResult(true, String.format("\u751f\u6210\u8bbe\u5907\u5e8f\u53f7\u6210\u529f\uff0c\u6570\u91cf[%s]", count)));
            } else {
                context.setAuthResponse(new ResponseResult(true, "\u5df2\u7ecf\u751f\u6210\u8fc7\u8bbe\u5907\u5e8f\u53f7"));
            }
            context.setAuth(Boolean.valueOf(true));
            context.setInit(Boolean.valueOf(true));
            chain.doNextStep(body, SendMailPaidStep.class);
        } else if (goodsType.isCloud() && !Objects.equals(orderVO.getOrderType(), OrderTypeEnum.BILL.getValue())) {
            detail.setCategoryId(goods.getCategoryId());
            detail.setEquip(goods.getEquip());
            detail.setCloud(goods.getCloud());
            if (StringUtils.hasLength((String)detail.getDeviceCode())) {
                this.orderCloudDeviceService.extendCloudDevice(orderVO, detail);
                this.orderUpdateMapper.updateOrderAuthInit(orderVO.getSid().longValue());
                chain.doNextStep(body, PlatformGoodsPaidStep.class);
            } else {
                this.buyNewCloudDevice(orderVO);
                this.orderUpdateMapper.updateOrderAuthInit(orderVO.getSid().longValue());
                chain.doNextStep(body, InitGoodsPaidStep.class);
            }
        } else if (goodsType.getOpenMode() == 2) {
            context.setOpenMode(Integer.valueOf(goodsType.getOpenMode()));
            context.setAuthResponse(new ResponseResult(true, "\u4eba\u5de5\u5f00\u901a\u5546\u54c1\uff0c\u4e0d\u9700\u8981\u6388\u6743\u548c\u521d\u59cb\u5316"));
            chain.doNextStep(body, SendMailPaidStep.class);
        } else {
            chain.doNextStep(body);
        }
    }

    private void buyNewCloudDevice(OrderVO orderVO) {
        DeviceAttributeVO attribute = this.orderCloudDeviceService.getStrategyAttributeByOrderSid(orderVO.getSid());
        ArrayList<OrderCloudDevice> devices = new ArrayList<OrderCloudDevice>();
        Integer count = this.goodsMapper.getOrderEquipCount(orderVO.getSid().longValue());
        String tenantId = orderVO.getTenantId();
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(Collections.singletonList(tenantId));
        CommonVO tenantInfo = tenantSimplesMap.getOrDefault(tenantId, new CommonVO());
        for (int i = 0; i < count; ++i) {
            OrderCloudDevice device = new OrderCloudDevice();
            device.setOrderSid(orderVO.getSid());
            device.setCode(UUID.randomUUID().toString());
            device.setState(Integer.valueOf(0));
            device.setCloud(attribute.getCloud());
            device.setKind(attribute.getKind());
            device.setActualCore(attribute.getCore());
            device.setActualMemory(attribute.getMemory());
            device.setArea(attribute.getArea());
            device.setCostDeptId(tenantInfo.getCostDeptId());
            device.setCostDeptName(tenantInfo.getCostDeptName());
            device.setCostEmpId(tenantInfo.getCostEmpId());
            device.setCostEmpName(tenantInfo.getCostEmpName());
            device.setSourceFlag(CloudDeviceSourceEnum.ORDER.getValue());
            device.setResAcquireMode(tenantInfo.getResAcquireMode());
            devices.add(device);
        }
        if (!devices.isEmpty()) {
            devices.forEach(EntityUtils::setCreateFields);
            this.orderCloudDeviceRepository.saveAll(devices);
        }
        ArrayList<OrderCloudDeviceVO> orderCloudDeviceVOS = new ArrayList<OrderCloudDeviceVO>();
        for (OrderCloudDevice device : devices) {
            OrderCloudDeviceVO orderCloudDeviceVO = new OrderCloudDeviceVO();
            orderCloudDeviceVO.setSid(Long.valueOf(device.getSid()));
            orderCloudDeviceVO.setApplicantId(orderVO.getUserId());
            orderCloudDeviceVO.setApplicantName(orderVO.getUserName());
            orderCloudDeviceVO.setApplicantDate(LocalDateTime.now());
            orderCloudDeviceVOS.add(orderCloudDeviceVO);
        }
        this.orderCloudDeviceService.batchApplyCloudDevice(orderCloudDeviceVOS);
        orderVO.setCloudDevices(devices.stream().map(a -> new CloudDeviceInitVO(Long.valueOf(a.getSid()), a.getCode())).collect(Collectors.toList()));
    }
}

