/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.paid;

import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitGoodsPaidStep
implements BaseOrderFlow {
    @Autowired
    private AuthService authService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        OrderVO orderVO = body.getOrder();
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        if (orderVO.getInitialize() != 1) {
            ResponseResult result = this.authService.initGoods(orderVO, context.getAuthInfo());
            context.setInit(Boolean.valueOf(result.isSuccess()));
            context.setInitMessage(result.getMessage());
        } else {
            context.setInit(Boolean.valueOf(true));
            context.setInitMessage("\u5df2\u7ecf\u521d\u59cb\u5316");
        }
        ResponseResult auth = new ResponseResult();
        auth.setSuccess(context.getAuth() != false && context.getInit() != false);
        auth.setMessage(String.format("%s;%s", context.getAuthMessage(), context.getInitMessage()));
        context.setAuthResponse(auth);
        OrderFlowContextHolder.setContext((OrderFlowVO)context);
        chain.doNextStep(body);
    }
}

