/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.paid;

import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrderPaymentPaidStep
implements BaseOrderFlow {
    @Autowired
    private OrderService orderService;
    @Autowired
    private DwPayService dwPayService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        if (body.getCallback().booleanValue()) {
            chain.doNextStep(body);
            return;
        }
        OrderVO orderVO = body.getOrder();
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        if (orderVO.getOrderStatus() == 1) {
            context.setData((Object)"True");
            context.setErrMsg("\u8ba2\u5355\u5df2\u652f\u4ed8");
            context.setFirstPay(Boolean.valueOf(false));
            return;
        }
        if (!orderVO.getValid().booleanValue() && orderVO.getOrderStatus() == 0) {
            context.setData((Object)"False");
            context.setCode(Integer.valueOf(I18nCode.CODE_10019.getId()));
            context.setErrMsg(I18nCode.CODE_10019.getMessage());
            return;
        }
        if (orderVO.isCreditAutoRenew() && !StringUtils.hasLength((String)orderVO.getPeriodNo())) {
            context.setData((Object)"False");
            context.setErrMsg("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u8bf7\u7ee7\u7eed\u5b8c\u6210\u652f\u4ed8");
            return;
        }
        if (orderVO.getPayPrice().compareTo(BigDecimal.ZERO) == 0) {
            this.orderService.payOrder(orderVO.getSid().longValue(), orderVO.getPayPrice(), PaymentTypeEnum.Free, null);
        } else if (body.getOff().booleanValue()) {
            this.orderService.payOrder(orderVO.getSid().longValue(), orderVO.getPayPrice(), PaymentTypeEnum.Offline, body.getOffline());
        } else if (orderVO.getBnpl() != null) {
            this.orderService.payOrder(orderVO.getSid().longValue(), orderVO.getPayPrice(), PaymentTypeEnum.BNPL, null);
            body.setBnpl(Boolean.valueOf(true));
        } else {
            TradeInfo entity = this.dwPayService.queryPayInfo(orderVO.getOrderCode());
            if (entity == null) {
                context.setData((Object)"False");
                context.setErrMsg("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u8bf7\u7ee7\u7eed\u5b8c\u6210\u652f\u4ed8");
                return;
            }
            Payment payment = new Payment(entity);
            if (TradeStatusEnum.TRADE_SUCCESS.name().equals(entity.getTradeStatus()) || TradeStatusEnum.TRADE_FINISHED.name().equals(entity.getTradeStatus())) {
                this.orderService.payOrder(orderVO.getSid().longValue(), orderVO.getPayPrice(), payment, true);
            } else {
                this.orderService.payOrder(orderVO.getSid().longValue(), orderVO.getPayPrice(), payment, false);
                context.setData((Object)"False");
                context.setErrMsg("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u8bf7\u7ee7\u7eed\u5b8c\u6210\u652f\u4ed8");
                return;
            }
        }
        chain.doNextStep(body);
    }
}

