/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.paid;

import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMailPaidStep
implements BaseOrderFlow {
    @Autowired
    private MailService mailService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        OrderVO orderVO = body.getOrder();
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        if (context.getFirstPay().booleanValue()) {
            if (!OrderSourceEnum.BossOffline.name().equals(orderVO.getOrderSource()) && !Boolean.TRUE.equals(body.getBnpl())) {
                this.mailService.sendEmailPaySuccess(orderVO.getSid().longValue());
            }
            if (OrderSourceEnum.BossOnline.name().equalsIgnoreCase(orderVO.getOrderSource()) || OrderSourceEnum.BossOffline.name().equalsIgnoreCase(orderVO.getOrderSource())) {
                this.mailService.sendGoodsByOrderSidToEnableEmail(orderVO.getSid().longValue());
            }
            if (GoodsCategoryEnum.API.name().equalsIgnoreCase(orderVO.getCategoryId())) {
                this.mailService.sendApiGoodsSuccess(orderVO);
            }
        }
        if (context.getOpenMode() == 2) {
            this.mailService.sendEmailAuthManual(orderVO.getSid().longValue());
        }
        if (Boolean.TRUE.equals(body.getBnpl())) {
            this.mailService.sendNoticeBnplEntrustOrder(Collections.singletonList(body.getOrder()), body.getPackOrder());
        }
        chain.doNextStep(body);
    }
}

