/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.unpaid;

import com.digiwin.dap.middleware.omc.domain.ShoppingCartOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessoryGoodsUnpaidStep
implements BaseOrderFlow {
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderFlowService orderFlowService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        List accessoryOrders = this.orderService.createAccessoryOrder(body.getOrder(), null);
        if (accessoryOrders.isEmpty()) {
            chain.doNextStep(body);
        } else {
            ShoppingCartOrderDetailVO cartOrder = this.orderMapper.getShoppingCartOrderDetailVo(((OrderVO)accessoryOrders.get(0)).getCartCode());
            if (cartOrder != null) {
                this.orderFlowService.checkCartOrder(cartOrder.getSid().longValue(), cartOrder.getCode());
                OrderFlowContextHolder.getContext().setData((Object)String.format("%s;%s;%s", cartOrder.getCartCode(), cartOrder.getCode(), cartOrder.getSid()));
            }
        }
    }
}

