/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.unpaid;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderFlowEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPrepareUnpaidStep
implements BaseOrderFlow {
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;
    @Autowired
    private OrderCrudService orderCrudService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        boolean bool;
        OrderVO orderVO = body.getOrder();
        if (orderVO.getOrderType().intValue() != OrderTypeEnum.APP_ADD_USER.getValue() && !(bool = this.goodsMapper.existsOnSaleByGoodsCode(orderVO.getGoodsCode()))) {
            OrderFlowVO context = OrderFlowContextHolder.getContext();
            context.setCode(Integer.valueOf(I18nCode.CODE_50001.getId()));
            context.setMessage(I18nCode.CODE_50001.getMessage(new Object[]{orderVO.getGoodsCode()}));
            context.setSuccess(Boolean.valueOf(false));
            OrderFlowContextHolder.setContext((OrderFlowVO)context);
            return;
        }
        TenantVO tenant = this.iamService.getTenantSimple(orderVO.getTenantId(), 0L);
        if (tenant != null) {
            orderVO.setTestTenant(tenant.getTestTenant());
            orderVO.setCustomerId(tenant.getCustomerId());
            if (orderVO.getEmail() == null) {
                orderVO.setEmail(tenant.getUserEmail());
            }
            if (orderVO.getTelephone() == null) {
                orderVO.setTelephone(tenant.getUserTelephone());
            }
        }
        if (orderVO.getUseRecommendedCoupon().booleanValue()) {
            this.orderService.getMyCoupon(orderVO, orderVO.getTenantSid().longValue(), orderVO.getUserSid().longValue());
        }
        this.orderService.fillCredentialFileId(Collections.singletonList(orderVO));
        if (BigDecimal.ZERO.equals(orderVO.getPayPrice())) {
            body.setStep(OrderFlowEnum.PAID);
        }
        if (orderVO.getBnpl() != null) {
            body.setStep(OrderFlowEnum.PAID);
            body.setBnpl(Boolean.valueOf(true));
        }
        if (StrUtils.isNotEmpty((String)orderVO.getPeriodNo()) && Objects.equals(orderVO.getOrderStatus(), OrderStatusEnum.Paid.getValue())) {
            body.setStep(OrderFlowEnum.PAID);
        }
        chain.doNextStep(body);
    }
}

