/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.order.unpaid;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.order.BaseOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMailUnpaidStep
implements BaseOrderFlow {
    @Autowired
    private MailService mailService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        OrderVO orderVO = body.getOrder();
        if (!(OrderSourceEnum.BossOffline.name().equals(orderVO.getOrderSource()) || Objects.equals(orderVO.getOrderType(), OrderTypeEnum.BILL.getValue()) || Boolean.TRUE.equals(body.getBnpl()))) {
            this.mailService.sendEmailSubmitOrder(orderVO.getSid().longValue());
        }
        chain.doNextStep(body);
    }
}

