/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.service.business.OrderDeviceService;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.GoodsType;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.SysNoticeService;
import com.digiwin.dap.middleware.omc.util.BatchCodeUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthInitCartPaidStep
implements CartOrderFlow {
    @Autowired
    private AuthService authService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderDeviceService orderDeviceService;
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderCrudService orderCrudService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        String batchCode = BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.MARKET);
        List orders = body.getOrders();
        orders.sort((a, b) -> a.getShopping() == 2 ? 1 : (b.getShopping() == 2 ? -1 : 0));
        this.accessoryProcess(orders);
        this.setDeviceBnpl(orders);
        for (OrderVO order : orders) {
            AuthorizationVO authorizationVO;
            order.setBatchCode(batchCode);
            GoodsType goodsType = body.getGoodsType(order.getOrderCode());
            if (order.getShopping() == 0) {
                if (goodsType.isEquip()) {
                    if (!goodsType.isCloud()) {
                        this.orderDeviceService.createOrderEquip(order.getSid().longValue());
                    } else {
                        this.orderDeviceService.createDevices(order, UserUtils.getToken());
                    }
                    this.orderUpdateMapper.updateOrderAuthInit(order.getSid().longValue());
                }
                if (goodsType.getOpenMode() != 2) {
                    ResponseResult result = body.getOff() != false || OrderSourceEnum.BossOnline.name().equalsIgnoreCase(order.getOrderSource()) || OrderSourceEnum.BossOffline.name().equalsIgnoreCase(order.getOrderSource()) ? this.authService.addAuthorizationDefault(order) : this.authService.authorization(order, UserUtils.getToken());
                    if (!goodsType.isCloud()) {
                        this.authService.initGoods(order, result.getAuthInfo());
                    }
                } else {
                    Order orderEntity = (Order)this.orderCrudService.findBySid(order.getSid().longValue());
                    orderEntity.setBatchCode(batchCode);
                    this.orderCrudService.update((BaseEntity)orderEntity);
                }
            }
            if (order.getShopping() == 2) {
                this.setPackTenancyPeriod(order, orders);
                this.authService.authorization(order, UserUtils.getToken());
            }
            if ((null == goodsType || goodsType.getOpenMode() == 2) && order.getShopping() != 2 || !GoodsCategoryEnum.isApp((String)order.getFirstOrderDetail().getCategoryId()) || null == (authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(order.getTenantId(), order.getFirstOrderDetail().getGoodsCode()))) continue;
            this.orderUpdateMapper.updateOrderShipmentDate(LocalDateTime.now(), authorizationVO.getExpiredTime(), order.getSid().longValue());
        }
        this.sysNoticeService.pushPackOrder(orders);
        chain.doNextStep(body);
    }

    private void setPackTenancyPeriod(OrderVO packOrder, List<OrderVO> orders) {
        List plainOrders = orders.stream().filter(a -> a.getShopping() == 0).collect(Collectors.toList());
        String tenantId = packOrder.getTenantId();
        LocalDateTime minExpiredTime = null;
        for (OrderVO plainOrder : plainOrders) {
            AuthorizationResultVO auth = this.cacService.queryAuthorizationByTenantAndApp(tenantId, plainOrder.getFirstOrderDetail().getGoodsCode());
            if (auth == null || !GoodsCategoryEnum.includeInCalculationOfPackExpireTime((String)auth.getCategoryId())) continue;
            LocalDateTime expiredTime = auth.getExpiredTime();
            if (minExpiredTime != null && !expiredTime.isBefore(minExpiredTime)) continue;
            minExpiredTime = expiredTime;
        }
        packOrder.setExpireTime(minExpiredTime);
    }

    private void setDeviceBnpl(List<OrderVO> orders) {
        orders.stream().filter(a -> a.getShopping() == 2).findFirst().ifPresent(a -> {
            BnplOrderVO bnpl = a.getBnpl();
            if (bnpl != null) {
                orders.forEach(b -> b.setBnpl(bnpl));
            }
        });
    }

    private void accessoryProcess(List<OrderVO> orders) {
        if (orders.isEmpty()) {
            return;
        }
        if (orders.get(0).getCartCode().contains("MATC")) {
            orders.sort(Comparator.comparing(OrderVO::getSid));
            OrderVO original = orders.get(0);
            for (OrderVO order : orders) {
                if (order.equals(original)) continue;
                order.setAccessoryFlag(true);
                order.setAccessoryOf(original.getGoodsCode());
            }
        }
    }
}

