/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.dao.BnplOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid.SendMailCartPaidStep;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BnplOrderCartPaidStep
implements CartOrderFlow {
    private static final Logger logger = LoggerFactory.getLogger(BnplOrderCartPaidStep.class);
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private BnplOrderCrudService bnplOrderCrudService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        List billOrderList = body.getOrders();
        if (!CollectionUtils.isEmpty((Collection)billOrderList) && ((OrderVO)billOrderList.get(0)).getOrderType().intValue() == OrderTypeEnum.BILL.getValue()) {
            OrderVO billOrderVO = (OrderVO)billOrderList.stream().filter(x -> Objects.equals(x.getShopping(), OrderShoppingEnum.PACK.getCode())).collect(Collectors.toList()).stream().findFirst().get();
            Order mainOrder = this.orderCrudService.findByOrderCode(billOrderVO.getOrderCode().split("N")[0]);
            BnplOrder bnplOrder = this.bnplOrderCrudService.findByOrderSid(Long.valueOf(mainOrder.getSid()));
            bnplOrder.setPaidCount(Integer.valueOf(bnplOrder.getPaidCount() + 1));
            bnplOrder.setLastPayDate(LocalDate.now());
            this.bnplOrderCrudService.update((BaseEntity)bnplOrder);
            this.orderUpdateMapper.updateOrderAuthInit(mainOrder.getSid());
            OrderFlowVO context = OrderFlowContextHolder.getContext();
            context.setAuth(Boolean.valueOf(true));
            context.setInit(Boolean.valueOf(true));
            context.setMessage("\u5148\u7528\u540e\u4ed8\u8d26\u5355\uff0c\u4e0d\u9700\u8981\u6388\u6743\u548c\u521d\u59cb\u5316");
            chain.doNextStep(body, SendMailCartPaidStep.class);
        } else {
            chain.doNextStep(body);
        }
    }
}

