/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.GoodsType;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPrepareCartPaidStep
implements CartOrderFlow {
    @Autowired
    private GoodsMapper goodsMapper;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        for (OrderVO order : body.getOrders()) {
            if (order.getShopping() == 0) {
                Goods goods = this.goodsMapper.findGoodsBySid(order.getFirstOrderDetail().getGoodsSid().longValue());
                if (goods == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_50002, new Object[]{order.getGoodsCode()});
                }
                GoodsType goodsType = new GoodsType(goods);
                body.setGoodsType(order.getOrderCode(), goodsType);
            }
            if (order.getBnpl() == null) continue;
            body.setBnpl(Boolean.valueOf(true));
        }
        chain.doNextStep(body);
    }
}

