/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.CartOrderResponse;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPaymentCartPaidStep
implements CartOrderFlow {
    @Autowired
    private DwPayService dwPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderQueryService orderQueryService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        if (body.getCallback().booleanValue()) {
            chain.doNextStep(body);
            return;
        }
        OrderVO cart = this.orderQueryService.getOrderBySid(body.getCartSid().longValue());
        List orders = this.orderQueryService.getCartOrders(cart.getCartCode(), Boolean.TRUE.booleanValue());
        body.setOrders(orders);
        OrderFlowVO context = OrderFlowContextHolder.getContext();
        context.setData((Object)StdData.ok((Object)CartOrderResponse.of((OrderVO)cart, (List)orders)));
        if (cart.getOrderStatus() == 1) {
            context.setFirstPay(Boolean.valueOf(false));
            return;
        }
        if (cart.getPayPrice().doubleValue() == 0.0) {
            this.orderService.payOrderCart(cart, orders, PaymentTypeEnum.Free, null);
        } else if (body.getOff().booleanValue()) {
            this.orderService.payOrderCart(cart, orders, PaymentTypeEnum.Offline, body.getOffline());
        } else if (orders.stream().anyMatch(o -> o.getBnpl() != null)) {
            this.orderService.payOrderCart(cart, orders, PaymentTypeEnum.BNPL, null);
            body.setBnpl(Boolean.valueOf(true));
        } else {
            TradeInfo entity = this.dwPayService.queryPayInfo(cart.getOrderCode());
            if (entity == null) {
                context.setData((Object)StdData.of((int)I18nCode.CODE_10002.getId(), (String)I18nCode.CODE_10002.getMessage()));
                return;
            }
            Payment payment = new Payment(entity);
            List payments = orders.stream().map(order -> {
                Payment temp = payment.clone();
                temp.setOrderSid(order.getSid());
                temp.setAmount(payment.getAmount() == null ? order.getPayPrice() : payment.getAmount());
                EntityUtils.setCreateFields((BaseEntity)payment);
                return temp;
            }).collect(Collectors.toList());
            if (TradeStatusEnum.TRADE_SUCCESS.name().equals(entity.getTradeStatus()) || TradeStatusEnum.TRADE_FINISHED.name().equals(entity.getTradeStatus())) {
                this.orderService.payOrderCart(cart.getCartCode(), entity.getTradeStatus(), payments, true);
            } else {
                this.orderService.payOrderCart(cart.getCartCode(), entity.getTradeStatus(), payments, false);
                context.setData((Object)StdData.of((int)I18nCode.CODE_10002.getId(), (String)I18nCode.CODE_10002.getMessage()));
                return;
            }
        }
        chain.doNextStep(body);
    }
}

