/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.paid;

import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.GoodsType;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendMailCartPaidStep
implements CartOrderFlow {
    @Autowired
    private MailService mailService;
    @Autowired
    private GoodsService goodsService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        long cartSid = body.getCartSid();
        List orders = body.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            chain.doNextStep(body);
            return;
        }
        Optional<Long> anyGoodsSid = body.getOrders().stream().map(OrderVO::getFirstOrderDetail).map(OrderDetailVO::getGoodsSid).filter(Objects::nonNull).findAny();
        if (anyGoodsSid.isPresent() && this.goodsService.usedForCertifiedTest(anyGoodsSid.get().longValue())) {
            chain.doNextStep(body);
            return;
        }
        if (!Boolean.TRUE.equals(body.getBnpl())) {
            this.mailService.sendEmailShoppingCartPaySuccess(cartSid);
        }
        Optional<OrderVO> packOrder = orders.stream().filter(o -> o.getShopping() == 2).findFirst();
        packOrder.ifPresent(orderVO -> {
            if (!Boolean.TRUE.equals(body.getBnpl())) {
                this.mailService.sendEmailPackOrderPaySuccessToPM(orderVO.getSid().longValue());
            }
        });
        for (OrderVO order : orders) {
            if (order.getShopping() != 0) continue;
            GoodsType goodsType = body.getGoodsType(order.getOrderCode());
            if (goodsType.getOpenMode() == 2) {
                this.mailService.sendEmailAuthManual(order.getSid().longValue());
            }
            if (!Boolean.TRUE.equals(body.getBnpl())) {
                this.mailService.sendEmailShoppingCartPaySuccessToPm(order.getSid().longValue());
            }
            if (!GoodsCategoryEnum.API.name().equalsIgnoreCase(order.getCategoryId())) continue;
            this.mailService.sendApiGoodsSuccess(order);
        }
        if (Boolean.TRUE.equals(body.getBnpl())) {
            this.mailService.sendNoticeBnplEntrustOrder(body.getOrders(), body.getPackOrder());
        }
        chain.doNextStep(body);
    }
}

