/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.unpaid;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderCategoryEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessoryGoodsCartUnpaidStep
implements CartOrderFlow {
    @Autowired
    private OrderService orderService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        ArrayList accessoryOrders = new ArrayList();
        for (OrderVO order : body.getOrders()) {
            if (!OrderCategoryEnum.BASE_ORDER.getValue().equals(order.getShopping())) continue;
            accessoryOrders.addAll(this.orderService.createAccessoryOrder(order, body.getCartCode()));
        }
        body.getOrders().addAll(accessoryOrders);
        chain.doNextStep(body);
    }
}

