/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.unpaid;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderCategoryEnum;
import com.digiwin.dap.middleware.omc.domain.response.CartOrderResponse;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderCartService;
import com.digiwin.dap.middleware.omc.service.order.OrderPackService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateOrderCartUnpaidStep
implements CartOrderFlow {
    @Autowired
    private OrderCartService orderCartService;
    @Autowired
    private OrderPackService orderPackService;
    @Autowired
    private OrderQueryService orderQueryService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        CartOrderResponse cartOrderResponse;
        if (body.getCategory() == OrderCategoryEnum.CART_ORDER) {
            cartOrderResponse = this.orderCartService.createOrder(body.getCartOrder());
        } else if (body.getCategory() == OrderCategoryEnum.PACK_ORDER) {
            cartOrderResponse = this.orderPackService.createOrder(body.getPackOrder());
        } else {
            throw new BusinessException("\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u7c7b\u578b\uff1a" + body.getCategory());
        }
        body.setCartSid(cartOrderResponse.getSid());
        body.setCartCode(cartOrderResponse.getCartCode());
        OrderFlowContextHolder.getContext().setData((Object)StdData.ok((Object)cartOrderResponse));
        List orders = this.orderQueryService.getCartOrders(body.getCartCode(), Boolean.TRUE.booleanValue());
        body.setOrders(orders);
        chain.doNextStep(body);
    }
}

