/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.unpaid;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderFlowEnum;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPrepareCartUnpaidStep
implements CartOrderFlow {
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderService orderService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        List orders = body.getOrders();
        List goodsCodes = orders.stream().map(OrderVO::getGoodsCode).collect(Collectors.toList());
        List validCodes = this.goodsMapper.getOnSaleByGoodsCode(goodsCodes);
        goodsCodes.removeAll(validCodes);
        if (!goodsCodes.isEmpty()) {
            OrderFlowContextHolder.getContext().setData((Object)StdData.of((int)I18nCode.CODE_50001.getId(), (String)I18nCode.CODE_50001.getMessage(new Object[]{String.join((CharSequence)",", goodsCodes)})));
            return;
        }
        TenantVO tenant = this.iamService.getTenantSimple(((OrderVO)orders.get(0)).getTenantId(), 0L);
        if (tenant != null) {
            for (OrderVO order2 : orders) {
                order2.setTestTenant(tenant.getTestTenant());
                order2.setCustomerId(tenant.getCustomerId());
                if (order2.getEmail() == null) {
                    order2.setEmail(tenant.getUserEmail());
                }
                if (order2.getTelephone() != null) continue;
                order2.setTelephone(tenant.getUserTelephone());
            }
        }
        if (body.getCategory() == OrderCategoryEnum.CART_ORDER) {
            for (OrderVO order2 : orders) {
                if (!order2.getUseRecommendedCoupon().booleanValue()) continue;
                this.orderService.getMyCoupon(order2, UserUtils.getTenantSid(), UserUtils.getUserSid());
            }
        }
        this.orderService.fillCredentialFileId(orders);
        orders.stream().filter(p -> OrderCategoryEnum.CART_ORDER.getValue().equals(p.getShopping()) && BigDecimal.ZERO.equals(p.getPayPrice())).findFirst().ifPresent(order -> body.setStep(OrderFlowEnum.PAID));
        orders.stream().filter(p -> p.getBnpl() != null).findFirst().ifPresent(order -> {
            body.setStep(OrderFlowEnum.PAID);
            body.setBnpl(Boolean.valueOf(true));
        });
        chain.doNextStep(body);
    }
}

