/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.flow.shoppingcart.unpaid;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderCategoryEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlow;
import com.digiwin.dap.middleware.omc.service.flow.core.OrderFlowChain;
import com.digiwin.dap.middleware.omc.service.flow.core.domian.OrderComm;
import com.digiwin.dap.middleware.omc.service.flow.shoppingcart.CartOrderFlow;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMailCartUnpaidStep
implements CartOrderFlow {
    @Autowired
    private MailService mailService;
    @Autowired
    private GoodsService goodsService;

    public void doNextStep(OrderComm body, Class<? extends OrderFlow> targetStep, OrderFlowChain chain) {
        Optional<Long> anyGoodsSid = body.getOrders().stream().map(OrderVO::getFirstOrderDetail).map(OrderDetailVO::getGoodsSid).filter(Objects::nonNull).findAny();
        if (anyGoodsSid.isPresent() && this.goodsService.usedForCertifiedTest(anyGoodsSid.get().longValue())) {
            chain.doNextStep(body);
            return;
        }
        for (OrderVO order : body.getOrders()) {
            if (OrderCategoryEnum.BASE_ORDER.getValue().equals(order.getShopping()) && !Boolean.TRUE.equals(body.getBnpl())) {
                this.mailService.sendEmailSubmitShoppingCartOrderToPm(order.getSid().longValue());
                continue;
            }
            if (OrderCategoryEnum.CART_ORDER.getValue().equals(order.getShopping()) && !Boolean.TRUE.equals(body.getBnpl())) {
                this.mailService.sendEmailSubmitShoppingCartOrder(order.getSid().longValue());
                continue;
            }
            if (!OrderCategoryEnum.PACK_ORDER.getValue().equals(order.getShopping()) || Boolean.TRUE.equals(body.getBnpl())) continue;
            this.mailService.sendEmailSubmitPackOrderToPM(order.getSid().longValue());
        }
        chain.doNextStep(body);
    }
}

