/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.installment.impl;

import com.digiwin.dap.middleware.omc.domain.LanguageResource;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ServicerOrderDetailVO;
import com.digiwin.dap.middleware.omc.mapper.InstallmentOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.LanguageMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.installment.InstallmentOrderQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InstallmentOrderQueryServiceImpl
implements InstallmentOrderQueryService {
    @Autowired
    private InstallmentOrderMapper installmentOrderMapper;
    @Autowired
    private LanguageMapper languageMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderMapper orderMapper;

    public List<InstallmentOrderVO> getOrdersByCondition(InstallmentOrderConditionVO condition, int pageNum, int pageSize, String orderBy) {
        List orders = this.installmentOrderMapper.findOrders(condition, pageNum, pageSize, orderBy);
        this.fillOrderDetail(orders);
        return orders;
    }

    private void fillOrderDetail(List<InstallmentOrderVO> installmentOrders) {
        if (CollectionUtils.isEmpty(installmentOrders)) {
            return;
        }
        List orderSids = installmentOrders.stream().map(InstallmentOrderVO::getOrderSid).collect(Collectors.toList());
        List orders = this.orderMapper.findOrdersByOrderSids(orderSids);
        Map orderMap = Optional.ofNullable(orders).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(OrderVO::getSid, Function.identity(), (k1, k2) -> k1));
        List orderDetails = this.orderDetailMapper.findOrderDetails(orderSids);
        Map<Long, List<OrderDetailVO>> orderDetailMap = orderDetails.stream().collect(Collectors.groupingBy(OrderDetailVO::getOrderSid));
        List orderDetailSids = orderDetails.stream().map(OrderDetailVO::getSid).collect(Collectors.toList());
        List orderDetailItems = this.orderDetailMapper.findOrderDetailItems(orderDetailSids);
        Map<Long, List<OrderDetailItemVO>> orderDetailItemMap = orderDetailItems.stream().collect(Collectors.groupingBy(OrderDetailItemVO::getOrderDetailSid));
        List servicerOrderDetails = this.orderDetailMapper.findServicerOrderDetails(orderDetailSids);
        Map<Long, ServicerOrderDetailVO> servicerOrderDetailMap = servicerOrderDetails.stream().collect(Collectors.toMap(ServicerOrderDetailVO::getOrderDetailSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(ServicerOrderDetailVO::getSid))));
        List goodsName = new ArrayList();
        List goodSids = orderDetails.stream().map(OrderDetailVO::getGoodsSid).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(goodSids)) {
            goodsName = this.languageMapper.findByDataSidInAndFieldName(goodSids, "goodsName");
        }
        Map<Long, String> goodsNameMap = goodsName.stream().filter(a -> StringUtils.hasLength((String)a.getContent()) && a.getLanguage().equals(LocaleContextHolder.getLocale().toLanguageTag())).collect(Collectors.toMap(LanguageResource::getDataSid, LanguageResource::getContent, (k1, k2) -> k1));
        installmentOrders.forEach(io -> {
            List details = (List)orderDetailMap.get(io.getOrderSid());
            if (!CollectionUtils.isEmpty((Collection)details)) {
                details.forEach(d -> {
                    ServicerOrderDetailVO servicerOrderDetailVO;
                    List items = (List)orderDetailItemMap.get(d.getSid());
                    if (null != items) {
                        d.setItems(items);
                    }
                    if (null != (servicerOrderDetailVO = (ServicerOrderDetailVO)servicerOrderDetailMap.get(d.getSid()))) {
                        d.setServicerOrderDetail(servicerOrderDetailVO);
                    }
                    if (goodsNameMap.containsKey(d.getGoodsSid())) {
                        d.setGoodsName((String)goodsNameMap.get(d.getGoodsSid()));
                    }
                });
                io.setOrderDetails(details);
            }
            if (orderMap.containsKey(io.getOrderSid())) {
                io.setOrderStatus(((OrderVO)orderMap.get(io.getOrderSid())).getOrderStatus());
                io.setValid(((OrderVO)orderMap.get(io.getOrderSid())).getValid());
            }
        });
    }
}

