/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.installment.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderAuthCrudService;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderCallbackVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrder;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrderAuth;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.installment.InstallmentOrderService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstallmentOrderServiceImpl
implements InstallmentOrderService {
    private static final Logger logger = LoggerFactory.getLogger(InstallmentOrderServiceImpl.class);
    @Autowired
    private InstallmentOrderCrudService installmentOrderCrudService;
    @Autowired
    private InstallmentOrderAuthCrudService installmentOrderAuthCrudService;
    @Autowired
    private OrderFlowService orderFlowService;
    @Autowired
    private DwPayService payService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private PaymentService paymentService;

    public void applyStopOrder(InstallmentOrder installmentOrder) {
        StdData result = this.payService.stopPay(installmentOrder.getOrderCode(), installmentOrder.getPeriodNo());
        if (!result.getSuccess().booleanValue()) {
            logger.error("\u7533\u8bf7\u7ec8\u6b62\u59d4\u6258\u5355\u5931\u8d25,result:{}", (Object)result);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u7533\u8bf7\u5931\u8d25");
        }
        installmentOrder.setPeriodStatus("terminate");
        installmentOrder.setApplyStopTime(LocalDateTime.now());
        this.installmentOrderCrudService.update((BaseEntity)installmentOrder);
    }

    public void callback(InstallmentOrderCallbackVO callbackVO, OrderVO baseOrderVO, OrderVO currentOrderVO) {
        InstallmentOrder installmentOrder = this.installmentOrderCrudService.findByOrderCode(callbackVO.getOutTradeNo());
        if (Objects.isNull(installmentOrder)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u59d4\u6258\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        installmentOrder.setNextPayTime(callbackVO.getNextAuthDate());
        if (Objects.isNull(installmentOrder.getFirstAuthTime())) {
            installmentOrder.setFirstAuthTime(callbackVO.getAuthDate());
        }
        installmentOrder.setPaidPeriods(callbackVO.getAlreadyTimes());
        installmentOrder.setPeriodNo(callbackVO.getPeriodNo());
        if (!callbackVO.getAuthStatus().booleanValue() && Objects.equals(callbackVO.getAlreadyTimes(), 1)) {
            installmentOrder.setPeriodStatus("terminate");
            installmentOrder.setApplyStopUserId(baseOrderVO.getUserId());
            installmentOrder.setApplyStopUserName(baseOrderVO.getUserName());
            installmentOrder.setApplyStopReason("\u9996\u671f\u4fe1\u7528\u5361\u652f\u4ed8\u5931\u6557");
            installmentOrder.setApplyStopTime(LocalDateTime.now());
        } else {
            installmentOrder.setPeriodStatus("restart");
        }
        this.installmentOrderCrudService.update((BaseEntity)installmentOrder);
        String authOrderCode = Objects.equals(callbackVO.getAlreadyTimes(), 1) ? callbackVO.getOutTradeNo() : callbackVO.getOrderNo();
        this.installmentOrderAuthCrudService.deleteByOrderCode(authOrderCode);
        InstallmentOrderAuth installmentOrderAuth = new InstallmentOrderAuth();
        installmentOrderAuth.setOrderCode(authOrderCode);
        installmentOrderAuth.setAuthOrderCode(callbackVO.getOrderNo());
        installmentOrderAuth.setPaidPeriods(callbackVO.getAlreadyTimes());
        installmentOrderAuth.setAuthorization(callbackVO.getAuthStatus().booleanValue());
        installmentOrderAuth.setAuthorizationDate(callbackVO.getAuthDate());
        installmentOrderAuth.setPeriodNo(callbackVO.getPeriodNo());
        this.installmentOrderAuthCrudService.create((BaseEntity)installmentOrderAuth);
        if (Objects.isNull(currentOrderVO)) {
            baseOrderVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            baseOrderVO.setOrderType(Integer.valueOf(2));
            baseOrderVO.setOrderCode(callbackVO.getOrderNo());
            baseOrderVO.setOrderStatus(Integer.valueOf(OrderStatusEnum.Unpaid.getValue()));
            baseOrderVO.setPeriodNo(callbackVO.getPeriodNo());
            baseOrderVO.setMerchantOrderNo(callbackVO.getTradeNo());
            if (callbackVO.getAuthStatus().booleanValue()) {
                baseOrderVO.setOrderStatus(Integer.valueOf(OrderStatusEnum.Paid.getValue()));
                this.paymentService.createPayment(baseOrderVO.getSid().longValue(), callbackVO.getPeriodAmount(), PaymentTypeEnum.mpg, "Period");
            }
            this.clearOrderData(baseOrderVO);
            this.orderFlowService.submitBaseOrder(baseOrderVO);
        } else {
            if (callbackVO.getAuthStatus().booleanValue()) {
                this.paymentService.createPayment(currentOrderVO.getSid().longValue(), callbackVO.getPeriodAmount(), PaymentTypeEnum.mpg, "Period");
                currentOrderVO.setOrderStatus(Integer.valueOf(OrderStatusEnum.Paid.getValue()));
            } else if (Objects.equals(callbackVO.getAlreadyTimes(), 1)) {
                currentOrderVO.setValid(Boolean.valueOf(false));
            }
            currentOrderVO.setPeriodNo(callbackVO.getPeriodNo());
            currentOrderVO.setMerchantOrderNo(callbackVO.getTradeNo());
            this.orderCrudService.update((BaseEntity)currentOrderVO.doForward());
            if (callbackVO.getAuthStatus().booleanValue()) {
                this.orderFlowService.checkBaseOrder(currentOrderVO);
            }
        }
    }

    private void clearOrderData(OrderVO baseOrderVO) {
        baseOrderVO.setUseRecommendedCoupon(Boolean.valueOf(false));
        baseOrderVO.setOrderCoupons(null);
        baseOrderVO.setAuthorization(Boolean.valueOf(false));
        baseOrderVO.setAuthorizationDate(null);
        baseOrderVO.setInitialize(Integer.valueOf(0));
        baseOrderVO.setOrderPromotionMixVO(null);
        Optional.ofNullable(baseOrderVO.getOrderDetails()).ifPresent(list -> list.forEach(e -> {
            e.setSid(null);
            Optional.ofNullable(e.getItems()).ifPresent(items -> items.forEach(i -> i.setSid(null)));
            Optional.ofNullable(e.getServicerOrderDetail()).ifPresent(i -> i.setSid(null));
        }));
        Optional.ofNullable(baseOrderVO.getInvoice()).ifPresent(e -> e.setSid(null));
        Optional.ofNullable(baseOrderVO.getPayment()).ifPresent(e -> e.setSid(null));
        Optional.ofNullable(baseOrderVO.getRefund()).ifPresent(e -> e.setSid(null));
        Optional.ofNullable(baseOrderVO.getContract()).ifPresent(e -> e.setSid(null));
    }
}

