/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.dao.OrderCouponCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailItemCrudService;
import com.digiwin.dap.middleware.omc.domain.CartOrderVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.request.OrderCouponVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.CartOrderResponse;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderCoupon;
import com.digiwin.dap.middleware.omc.entity.OrderPromotionMix;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.repository.OrderPromotionMixRepository;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.service.order.OrderCartService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderCartServiceImpl
implements OrderCartService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderCouponCrudService orderCouponCrudService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderDetailItemCrudService orderDetailItemCrudService;
    @Autowired
    private OrderPromotionMixRepository orderPromotionMixRepository;
    @Autowired
    private BnplOrderService bnplOrderService;

    @Transactional(rollbackFor={Exception.class})
    public CartOrderResponse createOrder(CartOrderVO cartOrderVO) {
        ArrayList<Order> orders = new ArrayList<Order>();
        ArrayList orderDetails = new ArrayList();
        ArrayList orderDetailItems = new ArrayList();
        ArrayList orderCoupons = new ArrayList();
        String cartCode = this.orderCrudService.generateCartOrderCode(this.envProperties.getCountry());
        cartOrderVO.setCartCode(cartCode);
        Order cartOrder = (Order)cartOrderVO.getCartOrder().doForward();
        cartOrder.setSid(SnowFlake.getInstance().newId());
        cartOrder.setCartCode(cartCode);
        cartOrder.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
        cartOrderVO.setCartSid(Long.valueOf(cartOrder.getSid()));
        orders.add(cartOrder);
        ArrayList promotionMixs = new ArrayList();
        cartOrderVO.getOrders().forEach(orderVO -> {
            orderVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            if (orderVO.getServicer().booleanValue()) {
                orderVO.setOrderCode(this.orderCrudService.generateServiceOrderCode(this.envProperties.getCountry()));
            } else {
                orderVO.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
            }
            orderVO.setCartCode(cartCode);
            orders.add((Order)orderVO.doForward());
            OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
            orderDetailVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            orderDetailVO.setOrderSid(orderVO.getSid());
            orderDetails.add(orderDetailVO.doForward());
            for (OrderDetailItemVO itemVO : orderDetailVO.getItems()) {
                if (null == itemVO.getPayPrice()) {
                    itemVO.setPayPrice(itemVO.getTotalPrice());
                }
                itemVO.setOrderDetailSid(orderDetailVO.getSid());
                orderDetailItems.add(itemVO.doForward());
            }
            if (!orderVO.getOrderCoupons().isEmpty()) {
                List myCouponSids = orderVO.getOrderCoupons().stream().map(OrderCouponVO::getMyCouponSid).collect(Collectors.toList());
                List coupons = this.goodsMapper.findCouponByMyCouponSid(myCouponSids);
                coupons.forEach(coupon -> {
                    coupon.setOrderSid(orderVO.getSid());
                    coupon.setUsedDate(LocalDateTime.now());
                    coupon.setDiscountPrice(orderVO.getDiscountPrice());
                });
                orderCoupons.addAll(coupons);
            }
            if (orderVO.getOrderPromotionMixVO() != null) {
                orderVO.getOrderPromotionMixVO().setOrderSid(orderVO.getSid());
                if (orderVO.getOrderPromotionMixVO().getDiscountPrice() == null) {
                    orderVO.getOrderPromotionMixVO().setDiscountPrice(orderVO.getDiscountPrice());
                }
                OrderPromotionMix orderPromotionMix = orderVO.getOrderPromotionMixVO().genarateDO();
                orderPromotionMix.setUsedDate(LocalDateTime.now());
                EntityUtils.setCreateFields((BaseEntity)orderPromotionMix);
                promotionMixs.add(orderPromotionMix);
            }
        });
        orders.forEach(EntityUtils::setCreateFields);
        orderDetails.forEach(EntityUtils::setCreateFields);
        orderDetailItems.forEach(EntityUtils::setCreateFields);
        orderCoupons.forEach(EntityUtils::setCreateFields);
        this.orderCrudService.saveAll(orders);
        this.orderDetailCrudService.saveAll(orderDetails);
        this.orderDetailItemCrudService.saveAll(orderDetailItems);
        this.orderCouponCrudService.saveAll(orderCoupons);
        this.orderPromotionMixRepository.saveAll(promotionMixs);
        if (!orderCoupons.isEmpty()) {
            List myCouponSids = orderCoupons.stream().map(OrderCoupon::getMyCouponSid).collect(Collectors.toList());
            this.goodsMapper.batchUpdateMyCouponUsed(myCouponSids);
        }
        cartOrderVO.getOrders().forEach(order -> this.bnplOrderService.generate(order));
        return CartOrderResponse.of((Order)cartOrder, orders);
    }
}

