/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.omc.domain.DealerOrderVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.service.order.ContractService;
import com.digiwin.dap.middleware.omc.service.order.OrderOtherService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OrderOtherServiceImpl
implements OrderOtherService {
    @Autowired
    private AuthService authService;
    @Autowired
    private MailService mailService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private PreOrderService preOrderService;

    public ResponseResult authorize(long sid) {
        OrderVO order = this.orderQueryService.getOrderBySid(sid);
        return this.authService.addAuthorizationDefault(order);
    }

    public ResponseResult initialize(long sid) {
        OrderVO order = this.orderQueryService.getOrderBySid(sid);
        order.setRetryInit(Boolean.valueOf(true));
        return this.authService.initGoods(order, null);
    }

    public ResponseResult initializePre(long sid) {
        PreOrderVO preOrderVO = this.preOrderService.findPreOrderAndDtlBySid(Long.valueOf(sid));
        preOrderVO.setRetryInit(Boolean.valueOf(true));
        return this.authService.initGoods(preOrderVO, null);
    }

    @Async
    public void afterOrderPaid(List<Long> orderSids, String userToken, DealerOrderVO dealerOrderVO) {
        orderSids.forEach(o -> {
            OrderVO orderVO = this.orderQueryService.getOrderBySid(o.longValue());
            if (!Boolean.TRUE.equals(orderVO.getFirstOrderDetail().getEquip())) {
                AuthorizationVO authorizationVO = new AuthorizationVO();
                authorizationVO.setCode(orderVO.getFirstOrderDetail().getGoodsCode());
                authorizationVO.setInitialize(Integer.valueOf(0));
                this.authService.initGoods(orderVO, authorizationVO);
            }
            this.contractService.doNothing(orderVO, userToken);
        });
        this.mailService.sendEmailDealerOrderSuccess(dealerOrderVO);
        this.mailService.sendEmailDealerOrderSuccessToPm(dealerOrderVO);
    }
}

