/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailItemCrudService;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.CartOrderResponse;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.service.order.OrderPackService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPackServiceImpl
implements OrderPackService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderDetailItemCrudService orderDetailItemCrudService;
    @Autowired
    private BnplOrderService bnplOrderService;

    @Transactional(rollbackFor={Exception.class})
    public CartOrderResponse createOrder(PackOrderVO packOrderVO) {
        ArrayList<Order> orders = new ArrayList<Order>();
        ArrayList<Object> orderDetails = new ArrayList<Object>();
        ArrayList orderDetailItems = new ArrayList();
        String cartCode = this.orderCrudService.generateCartOrderCode(this.envProperties.getCountry());
        packOrderVO.setCartCode(cartCode);
        String packCode = this.orderCrudService.generatePackOrderCode(this.envProperties.getCountry());
        Order cartOrder = (Order)packOrderVO.getCartOrder().doForward();
        cartOrder.setSid(SnowFlake.getInstance().newId());
        cartOrder.setCartCode(cartCode);
        cartOrder.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
        cartOrder.setPackSid(packOrderVO.getGoodsSid());
        packOrderVO.setCartSid(Long.valueOf(cartOrder.getSid()));
        orders.add(cartOrder);
        Order packOrder = (Order)packOrderVO.getPackOrder().doForward();
        packOrder.setSid(SnowFlake.getInstance().newId());
        packOrder.setCartCode(cartCode);
        packOrder.setPackCode(packCode);
        packOrder.setPackSid(packOrderVO.getGoodsSid());
        packOrder.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
        packOrder.setCategoryId("pack");
        packOrder.setGoodsCode(packOrderVO.getGoodsCode());
        packOrder.setCredentialFileId(packOrderVO.getCredentialFileId());
        orders.add(packOrder);
        OrderDetailVO packOrderDetailVO = new OrderDetailVO();
        packOrderDetailVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
        packOrderDetailVO.setOrderSid(Long.valueOf(packOrder.getSid()));
        packOrderDetailVO.setQuantity(packOrderVO.getQuantity());
        packOrderDetailVO.setGoodsSid(packOrderVO.getGoodsSid());
        packOrderDetailVO.setGoodsCode(packOrderVO.getGoodsCode());
        packOrderDetailVO.setGoodsName(packOrderVO.getGoodsName());
        orderDetails.add(packOrderDetailVO.doForward());
        packOrderVO.getOrders().forEach(orderVO -> {
            orderVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            orderVO.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
            orderVO.setCartCode(cartCode);
            orderVO.setPackCode(packCode);
            orderVO.setPackSid(packOrderVO.getGoodsSid());
            orderVO.setCredentialFileId(packOrderVO.getCredentialFileId());
            orders.add((Order)orderVO.doForward());
            OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
            orderDetailVO.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
            orderDetailVO.setOrderSid(orderVO.getSid());
            orderDetails.add(orderDetailVO.doForward());
            for (OrderDetailItemVO itemVO : orderDetailVO.getItems()) {
                if (null == itemVO.getPayPrice()) {
                    itemVO.setPayPrice(itemVO.getTotalPrice());
                }
                itemVO.setOrderDetailSid(orderDetailVO.getSid());
                orderDetailItems.add(itemVO.doForward());
            }
        });
        orders.forEach(EntityUtils::setCreateFields);
        orderDetails.forEach(EntityUtils::setCreateFields);
        orderDetailItems.forEach(EntityUtils::setCreateFields);
        this.orderCrudService.saveAll(orders);
        this.orderDetailCrudService.saveAll(orderDetails);
        this.orderDetailItemCrudService.saveAll(orderDetailItems);
        String billCartCode = orders.stream().filter(order -> Objects.equals(OrderShoppingEnum.PACK.getCode(), order.getShopping())).findFirst().map(order -> {
            OrderVO orderVO = new OrderVO();
            BeanUtils.copyProperties((Object)order, (Object)orderVO);
            orderVO.setOrderDetails(Collections.singletonList(packOrderDetailVO));
            orderVO.setBnpl(((OrderVO)packOrderVO.getOrders().get(0)).getBnpl());
            return this.bnplOrderService.generate(orderVO);
        }).orElse("");
        return CartOrderResponse.of((Order)cartOrder, (Order)packOrder, orders, (String)billCartCode);
    }
}

