/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.LanguageResource;
import com.digiwin.dap.middleware.omc.domain.PackGoodsVO;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.order.dto.OrderDetailSimpleDTO;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.request.ContractVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.InvoiceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCFC;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCouponVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderLogVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPromotionMixVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PaymentVO;
import com.digiwin.dap.middleware.omc.domain.response.OrderDetailResult;
import com.digiwin.dap.middleware.omc.domain.response.ServicerOrderDetailVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.InstallmentOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.LanguageMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.remote.BossiamService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrderQueryServiceImpl
implements OrderQueryService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private LanguageMapper languageMapper;
    @Autowired
    private InstallmentOrderMapper installmentOrderMapper;
    @Autowired
    private BossiamService bossiamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private IamService iamService;

    public List<OrderVO> getOrdersByCondition(OrderConditionVO orderCondition, int pageNum, int pageSize, String orderBy) {
        List orders = this.orderMapper.findOrders(orderCondition, pageNum, pageSize, orderBy);
        this.getOrderSub(orders);
        return orders;
    }

    public List<OrderVO> findOrdersWithoutPolicy(OrderConditionVO orderCondition) {
        return this.orderMapper.findOrdersWithoutPolicy(orderCondition);
    }

    public List<OrderVO> getOrdersByConditionBackend(OrderConditionVO orderCondition) {
        List orders = this.orderMapper.findOrdersBackend(orderCondition);
        this.getOrderSub4Backend(orders);
        return orders;
    }

    public List<OrderDetailSimpleDTO> listOrderDetailSimpleByCondition(Integer orderType, List<Integer> orderStatusList) {
        return this.orderMapper.listOrderDetails(orderType, orderStatusList).stream().map(OrderDetailSimpleDTO::convertDOToDTO).collect(Collectors.toList());
    }

    public List<OrderDetailResult> getUnTossOrders() {
        List orderDetails = this.orderMapper.getUnTossOrders();
        Map tenantSimplesMap = this.iamService.getTenantSimplesMap(orderDetails.stream().map(OrderDetailResult::getTenantId).collect(Collectors.toList()));
        orderDetails.removeIf(o -> {
            CommonVO tenantInfo = tenantSimplesMap.getOrDefault(o.getTenantId(), new CommonVO());
            return null != tenantInfo && "1".equals(tenantInfo.getTeamId());
        });
        return orderDetails;
    }

    public List<OrderDetailResult> getTossFailedOrders() {
        return this.orderMapper.getTossFailOrders();
    }

    public List<OrderVO> getTenantOrders(OrderConditionVO orderCondition, int pageNum, int pageSize, String orderBy) {
        List orders = this.orderMapper.findTenantOrders(orderCondition, pageNum, pageSize, orderBy);
        this.getOrderSub(orders);
        return orders;
    }

    public List<OrderVO> getCartOrders(String cartCode, boolean shopping) {
        List orders = this.orderMapper.findCartOrders(cartCode, shopping);
        this.getOrderSub(orders);
        return orders;
    }

    public OrderVO getOrderBySid(long sid) {
        Order order = (Order)this.orderCrudService.findBySid(sid);
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{sid});
        }
        return this.getOrderSub(order);
    }

    public OrderVO findOrderByOrderCode(String orderCode) {
        Order order = this.orderCrudService.findByOrderCode(orderCode);
        if (null == order) {
            return null;
        }
        return this.getOrderSub(order);
    }

    public OrderVO getOrderByOrderCode(String orderCode) {
        Order order = this.orderCrudService.findByOrderCode(orderCode);
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{orderCode});
        }
        return this.getOrderSub(order);
    }

    private OrderVO getOrderSub(Order order) {
        OrderVO orderVO = OrderVO.orderToVO((Order)order);
        this.getOrderSub(Collections.singletonList(orderVO));
        return orderVO;
    }

    private void getOrderSub(List<OrderVO> orders) {
        if (orders.isEmpty()) {
            return;
        }
        HashMap packOrderDetailsMap = new HashMap();
        List<String> cartCodeList = orders.stream().filter(order -> Objects.equals(OrderShoppingEnum.PACK.getCode(), order.getShopping()) && StringUtils.hasLength((String)order.getCartCode())).map(OrderVO::getCartCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(cartCodeList)) {
            List packOrderList = this.orderMapper.findOrdersByCartCodeList(cartCodeList);
            Map<String, List<OrderVO>> packOrderMap = packOrderList.stream().collect(Collectors.groupingBy(OrderVO::getCartCode));
            List packOrderSids = packOrderList.stream().map(OrderVO::getSid).collect(Collectors.toList());
            List packOrderDetails = this.orderDetailMapper.findOrderDetails(packOrderSids);
            Map<Long, List<OrderDetailVO>> packOrderDetailMap = packOrderDetails.stream().collect(Collectors.groupingBy(OrderDetailVO::getOrderSid));
            List packOrderDetailSids = packOrderDetails.stream().map(OrderDetailVO::getSid).collect(Collectors.toList());
            List packOrderDetailItems = this.orderDetailMapper.findOrderDetailItems(packOrderDetailSids);
            Map<Long, List<OrderDetailItemVO>> packOrderDetailItemMap = packOrderDetailItems.stream().collect(Collectors.groupingBy(OrderDetailItemVO::getOrderDetailSid));
            cartCodeList.forEach(cartCode -> {
                List packOrders = packOrderMap.getOrDefault(cartCode, Collections.emptyList());
                List packCommonOrderSids = packOrders.stream().filter(order -> Objects.equals(OrderShoppingEnum.COMMON.getCode(), order.getShopping())).map(OrderVO::getSid).distinct().collect(Collectors.toList());
                List orderDetails = packCommonOrderSids.stream().map(packOrderDetailMap::get).filter(Objects::nonNull).flatMap(Collection::stream).peek(orderDetailVO -> orderDetailVO.setItems(packOrderDetailItemMap.getOrDefault(orderDetailVO.getSid(), Collections.emptyList()))).collect(Collectors.toList());
                packOrderDetailsMap.put(cartCode, orderDetails);
            });
        }
        List orderSids = orders.stream().map(OrderVO::getSid).collect(Collectors.toList());
        List orderDetails = this.orderDetailMapper.findOrderDetails(orderSids);
        Map<Long, List<OrderDetailVO>> orderDetailMap = orderDetails.stream().collect(Collectors.groupingBy(OrderDetailVO::getOrderSid));
        List orderDetailSids = orderDetails.stream().map(OrderDetailVO::getSid).collect(Collectors.toList());
        List orderDetailItems = this.orderDetailMapper.findOrderDetailItems(orderDetailSids);
        Map<Long, List<OrderDetailItemVO>> orderDetailItemMap = orderDetailItems.stream().collect(Collectors.groupingBy(OrderDetailItemVO::getOrderDetailSid));
        List servicerOrderDetails = this.orderDetailMapper.findServicerOrderDetails(orderDetailSids);
        Map<Long, ServicerOrderDetailVO> servicerOrderDetailMap = servicerOrderDetails.stream().collect(Collectors.toMap(ServicerOrderDetailVO::getOrderDetailSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(ServicerOrderDetailVO::getSid))));
        List orderLogs = this.orderDetailMapper.findOrderLogs(orderSids);
        Map<Long, OrderLogVO> orderLogMap = orderLogs.stream().collect(Collectors.toMap(OrderLogVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(OrderLogVO::getSid))));
        List orderCoupons = this.orderDetailMapper.findOrderCoupons(orderSids);
        Map<Long, List<OrderCouponVO>> orderCouponMap = orderCoupons.stream().collect(Collectors.groupingBy(OrderCouponVO::getOrderSid));
        List orderInvoices = this.orderDetailMapper.findOrderInvoices(orderSids);
        Map<Long, InvoiceVO> orderInvoiceMap = orderInvoices.stream().collect(Collectors.toMap(InvoiceVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(InvoiceVO::getSid))));
        List orderPayments = this.orderDetailMapper.findOrderPayments(orderSids, TradeStatusEnum.TRADE_SUCCESS.name());
        Map<Long, PaymentVO> orderPaymentMap = orderPayments.stream().collect(Collectors.toMap(PaymentVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(PaymentVO::getSid))));
        List orderRefunds = this.orderDetailMapper.findOrderPayments(orderSids, TradeStatusEnum.TRADE_CLOSED.name());
        Map<Long, PaymentVO> orderRefundMap = orderRefunds.stream().collect(Collectors.toMap(PaymentVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(PaymentVO::getSid))));
        List orderContracts = this.orderDetailMapper.findOrderContracts(orderSids);
        Map<Long, ContractVO> orderContractMap = orderContracts.stream().collect(Collectors.toMap(ContractVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(ContractVO::getSid))));
        List orderPromotionMixVOS = this.orderDetailMapper.findOrderPromotionMixs(orderSids);
        Map<Long, OrderPromotionMixVO> orderPromotionMixMap = orderPromotionMixVOS.stream().collect(Collectors.toMap(OrderPromotionMixVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(OrderPromotionMixVO::getSid))));
        List packSids = orders.stream().map(OrderVO::getPackSid).distinct().collect(Collectors.toList());
        List packs = this.orderDetailMapper.findPacks(packSids);
        Map<Long, PackGoodsVO> packsMap = packs.stream().collect(Collectors.toMap(PackGoodsVO::getGoodsSid, a -> a, (k1, k2) -> k1));
        List formCounts = this.orderMapper.existCustomForm(orderSids);
        Map<Long, Integer> formCountMap = formCounts.stream().collect(Collectors.toMap(OrderCFC::getOrderSid, OrderCFC::getCount));
        List periodNoList = orders.stream().map(OrderVO::getPeriodNo).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        List installmentOrderList = new ArrayList();
        if (!CollectionUtils.isEmpty(periodNoList)) {
            installmentOrderList = this.installmentOrderMapper.findOrdersByPeriodNo(periodNoList);
        }
        Map periodsMap = Optional.ofNullable(installmentOrderList).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(InstallmentOrderVO::getPeriodNo, Function.identity(), (k1, k2) -> k1));
        List installmentOrderBySidList = this.installmentOrderMapper.findOrdersByOrderSids(orderSids);
        Map orderSidPeriodsMap = Optional.ofNullable(installmentOrderBySidList).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(InstallmentOrderVO::getOrderSid, Function.identity(), (k1, k2) -> k1));
        List goodsName = new ArrayList();
        List goodSids = orderDetails.stream().map(OrderDetailVO::getGoodsSid).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(goodSids)) {
            goodsName = this.languageMapper.findByDataSidInAndFieldName(goodSids, "goodsName");
        }
        Map<Long, String> goodsNameMap = goodsName.stream().filter(a -> StrUtils.isNotEmpty((String)a.getContent()) && a.getLanguage().equals(LocaleContextHolder.getLocale().toLanguageTag())).collect(Collectors.toMap(LanguageResource::getDataSid, LanguageResource::getContent, (k1, k2) -> k1));
        List bnplOrders = this.orderDetailMapper.findBnplOrder(orderSids);
        Map<Long, BnplOrderVO> bnplOrderMap = bnplOrders.stream().collect(Collectors.toMap(BnplOrderVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(BnplOrderVO::getSid))));
        Map tenantSimpleMap = this.iamService.getTenantSimplesMap(orders.stream().map(OrderVO::getTenantId).distinct().collect(Collectors.toList()));
        List categories = this.goodsMapper.findCategories();
        Map<String, String> categoryMap = categories.stream().collect(Collectors.toMap(CommonVO::getId, CommonVO::getName, (k1, k2) -> k1));
        orders.forEach(o -> {
            InstallmentOrderVO installmentOrder;
            List coupons;
            List details;
            if (Objects.equals(o.getShopping(), OrderShoppingEnum.PACK.getCode())) {
                o.setPackOrderDetails((List)packOrderDetailsMap.get(o.getCartCode()));
            }
            if (null != (details = (List)orderDetailMap.get(o.getSid())) && !details.isEmpty()) {
                details.forEach(d -> {
                    ServicerOrderDetailVO servicerOrderDetailVO;
                    List items = (List)orderDetailItemMap.get(d.getSid());
                    if (null != items) {
                        d.setItems(items);
                    }
                    if (null != (servicerOrderDetailVO = (ServicerOrderDetailVO)servicerOrderDetailMap.get(d.getSid()))) {
                        d.setServicerOrderDetail(servicerOrderDetailVO);
                    }
                    if (goodsNameMap.containsKey(d.getGoodsSid())) {
                        d.setGoodsName((String)goodsNameMap.get(d.getGoodsSid()));
                    }
                });
                o.setOrderDetails(details);
                o.setNeedInit(((OrderDetailVO)details.get(0)).getNeedInit());
                o.setServicer(Boolean.valueOf(StrUtils.isNotEmpty((String)((OrderDetailVO)details.get(0)).getServicerId())));
            }
            if (null != (coupons = (List)orderCouponMap.get(o.getSid()))) {
                o.setOrderCoupons(coupons);
            }
            o.setInvoice((InvoiceVO)orderInvoiceMap.get(o.getSid()));
            o.setPayment((PaymentVO)orderPaymentMap.get(o.getSid()));
            o.setRefund((PaymentVO)orderRefundMap.get(o.getSid()));
            o.setContract((ContractVO)orderContractMap.get(o.getSid()));
            if (null != orderLogMap.get(o.getSid())) {
                o.setTossFail(((OrderLogVO)orderLogMap.get(o.getSid())).getReason());
            }
            if (null != orderPromotionMixMap.get(o.getSid())) {
                o.setOrderPromotionMixVO((OrderPromotionMixVO)orderPromotionMixMap.get(o.getSid()));
            }
            o.setPack((PackGoodsVO)packsMap.get(o.getPackSid()));
            o.setIfCustomFormData(Boolean.valueOf(formCountMap.getOrDefault(o.getSid(), 0) > 0));
            InstallmentOrderVO installmentOrderTmp0 = (InstallmentOrderVO)periodsMap.get(o.getPeriodNo());
            InstallmentOrderVO installmentOrderTmp1 = (InstallmentOrderVO)orderSidPeriodsMap.get(o.getSid());
            InstallmentOrderVO installmentOrderVO = installmentOrder = Objects.isNull(installmentOrderTmp0) ? installmentOrderTmp1 : installmentOrderTmp0;
            if (!Objects.isNull(installmentOrder)) {
                o.setRenewPeriods(installmentOrder.getTotalPeriods());
                o.setPeriodType(installmentOrder.getPeriodType());
                o.setFirstAuthDate(installmentOrder.getFirstAuthTime());
                o.setPeriodAmount(installmentOrder.getPeriodAmt());
                o.setCreditAutoRenew(true);
                o.setPeriodSubOrder(Objects.isNull(installmentOrderTmp1));
            }
            o.setBnpl((BnplOrderVO)bnplOrderMap.get(o.getSid()));
            o.setTeamName(tenantSimpleMap.getOrDefault(o.getTenantId(), new CommonVO()).getTeamName());
            o.setCategoryName((String)categoryMap.get(o.getCategoryId()));
        });
    }

    private void getOrderSub4Backend(List<OrderVO> orders) {
        if (orders.isEmpty()) {
            return;
        }
        List tenantVOs = this.bossiamService.getBossTenantsSimple(orders.stream().map(OrderVO::getTenantId).distinct().collect(Collectors.toList()));
        Map<String, TenantVO> tenantMap = tenantVOs.stream().collect(Collectors.toMap(TenantVO::getTenantId, a -> a, (k1, k2) -> k1));
        List orderSids = orders.stream().map(OrderVO::getSid).collect(Collectors.toList());
        List orderPayments = this.orderDetailMapper.findOrderPayments(orderSids, TradeStatusEnum.TRADE_SUCCESS.name());
        Map<Long, PaymentVO> orderPaymentMap = orderPayments.stream().collect(Collectors.toMap(PaymentVO::getOrderSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(PaymentVO::getSid))));
        List packSids = orders.stream().map(OrderVO::getPackSid).distinct().collect(Collectors.toList());
        List packs = this.orderDetailMapper.findPacks(packSids);
        Map<Long, PackGoodsVO> packsMap = packs.stream().collect(Collectors.toMap(PackGoodsVO::getGoodsSid, a -> a, (k1, k2) -> k1));
        List orderDetails = this.orderDetailMapper.findOrderDetails(orderSids);
        Map<Long, List<OrderDetailVO>> orderDetailMap = orderDetails.stream().collect(Collectors.groupingBy(OrderDetailVO::getOrderSid));
        Map strategyMap = this.getStrategyMap(orderDetails.stream().map(OrderDetailVO::getStrategySid).collect(Collectors.toList()));
        List goodsName = new ArrayList();
        List goodSids = orderDetails.stream().map(OrderDetailVO::getGoodsSid).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(goodSids)) {
            goodsName = this.languageMapper.findByDataSidInAndFieldName(goodSids, "goodsName");
        }
        Map<Long, String> goodsNameMap = goodsName.stream().filter(a -> StrUtils.isNotEmpty((String)a.getContent()) && a.getLanguage().equals(LocaleContextHolder.getLocale().toLanguageTag())).collect(Collectors.toMap(LanguageResource::getDataSid, LanguageResource::getContent, (k1, k2) -> k1));
        List categories = this.goodsMapper.findCategories();
        Map<String, String> categoryMap = categories.stream().collect(Collectors.toMap(CommonVO::getId, CommonVO::getName, (k1, k2) -> k1));
        orders.forEach(o -> {
            List details = (List)orderDetailMap.get(o.getSid());
            if (null != details && !details.isEmpty()) {
                details.forEach(d -> {
                    if (goodsNameMap.containsKey(d.getGoodsSid())) {
                        d.setGoodsName((String)goodsNameMap.get(d.getGoodsSid()));
                    }
                });
                TenantVO tenantVO = Optional.ofNullable(tenantMap.get(o.getTenantId())).orElse(new TenantVO());
                o.setTeamId(tenantVO.getTeamId());
                o.setTeamName(tenantVO.getTeamName());
                o.setOrderDetails(details);
                o.setPayment((PaymentVO)orderPaymentMap.get(o.getSid()));
                o.setNeedInit(((OrderDetailVO)details.get(0)).getNeedInit());
                o.setServicer(Boolean.valueOf(StrUtils.isNotEmpty((String)((OrderDetailVO)details.get(0)).getServicerId())));
                o.setCategoryName((String)categoryMap.get(o.getCategoryId()));
                if ("pack".equalsIgnoreCase(o.getCategoryId())) {
                    o.setCategoryName("\u7ec4\u5408\u5546\u54c1");
                }
                o.setPack((PackGoodsVO)packsMap.get(o.getPackSid()));
                details.forEach(detail -> detail.setStrategy((GoodsStrategy)strategyMap.get(detail.getStrategySid())));
            }
        });
    }

    public Map<Long, GoodsStrategy> getStrategyMap(List<Long> strategySids) {
        List strategies = new ArrayList();
        if (!strategySids.isEmpty()) {
            strategies = this.goodsMapper.findStrategyBySidIn(strategySids);
        }
        strategies.forEach(GoodsStrategy::showJson);
        return strategies.stream().collect(Collectors.toMap(GoodsStrategy::getId, Function.identity()));
    }

    public boolean existsByGoodsCode(String goodsCode) {
        return this.preOrderMapper.existsByGoodsCode(goodsCode) || this.orderMapper.existsByGoodsCode(goodsCode);
    }

    public OrderVO getBaseOrderByPeriodNo(String periodNo) {
        OrderVO baseOrder = this.orderMapper.getBaseOrderByPeriodNo(periodNo);
        if (!Objects.isNull(baseOrder)) {
            this.getOrderSub(Collections.singletonList(baseOrder));
        }
        return baseOrder;
    }
}

