/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.TossStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.InvoiceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCouponCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailItemCrudService;
import com.digiwin.dap.middleware.omc.dao.PaymentCrudService;
import com.digiwin.dap.middleware.omc.domain.CartOrderVO;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.gmc.PackPriceVO;
import com.digiwin.dap.middleware.omc.domain.gmc.ShoppingCartPriceVO;
import com.digiwin.dap.middleware.omc.domain.gmc.TotalPriceVO;
import com.digiwin.dap.middleware.omc.domain.remote.AttachedGoodsVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.IsvInfo;
import com.digiwin.dap.middleware.omc.domain.remote.MailOrder;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OMBillSearchConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OfflineVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCouponVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailItemVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPriceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.TossstatusVO;
import com.digiwin.dap.middleware.omc.domain.response.OMBillSearchResultVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrder;
import com.digiwin.dap.middleware.omc.entity.Invoice;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.entity.OrderDetail;
import com.digiwin.dap.middleware.omc.entity.OrderDetailItem;
import com.digiwin.dap.middleware.omc.entity.OrderPromotionMix;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PaymentMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.repository.CustomFormCartRepository;
import com.digiwin.dap.middleware.omc.repository.CustomFormOrderRepository;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.repository.OrderDetailItemRepository;
import com.digiwin.dap.middleware.omc.repository.OrderPromotionMixRepository;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.repository.PaymentRepository;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.order.OrderLogService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.remote.MiswsService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    private final Set<String> tossstatusSet = new HashSet<String>(Arrays.asList(TossStatusEnum.N.name(), TossStatusEnum.Z.name()));
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DwPayService dwPayService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private PaymentCrudService paymentCrudService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderLogService orderLogService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private OrderCouponCrudService orderCouponCrudService;
    @Autowired
    private OrderDetailItemCrudService orderDetailItemCrudService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private InvoiceCrudService invoiceCrudService;
    @Autowired
    private OrderDetailItemRepository orderDetailItemRepository;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private PaymentRepository paymentRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderPromotionMixRepository orderPromotionMixRepository;
    @Autowired
    private OrderFlowService orderFlowService;
    @Autowired
    private CustomFormCartRepository customFormCartRepository;
    @Autowired
    private CustomFormOrderRepository customFormOrderRepository;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private IamService iamService;
    @Autowired
    private InstallmentOrderCrudService installmentOrderCrudService;
    @Autowired
    private BnplOrderService bnplOrderService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;

    private static BigDecimal parse(String percentage) {
        try {
            return BigDecimal.valueOf(Integer.parseInt(percentage));
        }
        catch (Exception e) {
            logger.error("parse profit share percentage failed", (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long createOrder(OrderVO orderVO) {
        if (StrUtils.isEmpty((String)orderVO.getOrderCode())) {
            if (orderVO.getServicer().booleanValue()) {
                orderVO.setOrderCode(this.orderCrudService.generateServiceOrderCode(this.envProperties.getCountry()));
            } else {
                orderVO.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
            }
        }
        orderVO.setValid(Boolean.valueOf(true));
        this.calculateProfitShare(orderVO);
        long orderSid = this.orderCrudService.create((BaseEntity)orderVO.doForward());
        orderVO.setSid(Long.valueOf(orderSid));
        OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
        List itemVOs = orderDetailVO.getItems();
        OrderDetail orderDetail = (OrderDetail)orderDetailVO.doForward();
        orderDetail.setOrderSid(Long.valueOf(orderSid));
        long orderDetailSid = this.orderDetailCrudService.create((BaseEntity)orderDetail);
        orderDetailVO.setSid(Long.valueOf(orderDetailSid));
        if (null != itemVOs) {
            for (OrderDetailItemVO itemVO : itemVOs) {
                OrderDetailItem item = (OrderDetailItem)itemVO.doForward();
                if (null == item.getPayPrice()) {
                    item.setPayPrice(item.getTotalPrice());
                }
                item.setOrderDetailSid(Long.valueOf(orderDetailSid));
                this.orderDetailItemCrudService.create((BaseEntity)item);
            }
        }
        if (null != orderVO.getOrderCoupons() && !orderVO.getOrderCoupons().isEmpty()) {
            List myCouponSids = orderVO.getOrderCoupons().stream().map(OrderCouponVO::getMyCouponSid).collect(Collectors.toList());
            List orderCoupons = this.goodsMapper.findCouponByMyCouponSid(myCouponSids);
            orderCoupons.forEach(o -> {
                o.setOrderSid(Long.valueOf(orderSid));
                o.setUsedDate(LocalDateTime.now());
                o.setDiscountPrice(orderVO.getDiscountPrice());
                this.orderCouponCrudService.create((BaseEntity)o);
            });
            this.goodsMapper.batchUpdateMyCouponUsed(myCouponSids);
        } else if (null != orderVO.getOrderPromotionMixVO()) {
            orderVO.getOrderPromotionMixVO().setOrderSid(Long.valueOf(orderSid));
            if (orderVO.getOrderPromotionMixVO().getDiscountPrice() == null) {
                orderVO.getOrderPromotionMixVO().setDiscountPrice(orderVO.getDiscountPrice());
            }
            OrderPromotionMix orderPromotionMix = orderVO.getOrderPromotionMixVO().genarateDO();
            orderPromotionMix.setUsedDate(LocalDateTime.now());
            EntityUtils.setCreateFields((BaseEntity)orderPromotionMix);
            this.orderPromotionMixRepository.save((Object)orderPromotionMix);
        }
        if (null != orderVO.getInvoice()) {
            Invoice invoice = (Invoice)orderVO.getInvoice().doForward();
            invoice.setOrderSid(Long.valueOf(orderSid));
            this.invoiceCrudService.create((BaseEntity)invoice);
        }
        if (orderVO.isCreditAutoRenew() && !StringUtils.hasLength((String)orderVO.getPeriodNo())) {
            this.installmentOrderCrudService.create((BaseEntity)this.generateInstallmentOrder(orderVO));
        }
        this.bnplOrderService.generate(orderVO);
        return orderSid;
    }

    private InstallmentOrder generateInstallmentOrder(OrderVO orderVO) {
        InstallmentOrderVO installmentOrderVO = new InstallmentOrderVO();
        installmentOrderVO.setOrderSid(orderVO.getSid());
        installmentOrderVO.setOrderCode(orderVO.getOrderCode());
        installmentOrderVO.setGoodsCode(orderVO.getGoodsCode());
        if (StringUtils.hasText((String)orderVO.getPeriodType())) {
            installmentOrderVO.setPeriodType(orderVO.getPeriodType());
        } else {
            installmentOrderVO.setPeriodType("M");
        }
        installmentOrderVO.setPeriodAmt(orderVO.getPayPrice());
        installmentOrderVO.setTotalPeriods(orderVO.getRenewPeriods());
        installmentOrderVO.setTenantSid(orderVO.getTenantSid());
        installmentOrderVO.setTenantId(orderVO.getTenantId());
        installmentOrderVO.setTenantName(orderVO.getTenantName());
        installmentOrderVO.setTestTenant(orderVO.getTestTenant());
        installmentOrderVO.setUserId(orderVO.getUserId());
        installmentOrderVO.setUserName(orderVO.getUserName());
        installmentOrderVO.setEmail(orderVO.getEmail());
        installmentOrderVO.setTelephone(orderVO.getTelephone());
        installmentOrderVO.setPeriodStatus("suspend");
        return (InstallmentOrder)installmentOrderVO.doForward();
    }

    public void calculateProfitShare(OrderVO orderVO) {
        Goods goods = this.goodsMapper.findGoodsByCode(orderVO.getGoodsCode());
        if (goods == null) {
            return;
        }
        String servicerId = goods.getServicerId();
        if (ObjectUtils.isEmpty((Object)servicerId)) {
            return;
        }
        IsvInfo isvInfo = this.iamService.getISVSharePercentage(servicerId);
        if (GoodsCategoryEnum.APP.name().equalsIgnoreCase(goods.getCategoryId())) {
            orderVO.setProfitShare(orderVO.getPayPrice().multiply(OrderServiceImpl.parse((String)isvInfo.getAppSharePercentage())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        } else if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(goods.getCategoryId())) {
            orderVO.setProfitShare(orderVO.getPayPrice().multiply(OrderServiceImpl.parse((String)isvInfo.getServiceSharePercentage())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
    }

    public void getMyCoupon(OrderVO orderVO, long tenantSid, long userSid) {
        if (orderVO.getShareAchievement().booleanValue()) {
            orderVO.setBusinessCode(orderVO.getRecommendedItCode());
            orderVO.setDepartCode(orderVO.getRecommendedDepartCode());
        }
        orderVO.getOrderCoupons().forEach(o -> {
            Long myCouponSid = this.goodsMapper.findMyCouponSid(tenantSid, userSid, o.getCouponRuleSid().longValue());
            if (null == myCouponSid) {
                myCouponSid = this.goodsService.receiveCoupon(o.getCouponRuleSid().longValue());
            }
            o.setMyCouponSid(myCouponSid);
        });
    }

    public void cancelOrder(long orderSid) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (order == null) {
            return;
        }
        if (order.getShopping().intValue() == OrderShoppingEnum.COMMON.getCode()) {
            this.deleteOrder(order.getSid());
        } else {
            List orders = this.orderRepository.findByCartCode(order.getCartCode());
            orders.forEach(o -> this.deleteOrder(o.getSid()));
            List customFormCarts = this.customFormCartRepository.getByCartOrderSid(Long.valueOf(orderSid));
            this.customFormCartRepository.deleteAll((Iterable)customFormCarts);
        }
    }

    private void deleteOrder(long sid) {
        this.goodsMapper.updateMyCouponUnUsed(sid);
        this.orderCrudService.deleteById(sid);
        this.customFormOrderRepository.deleteByOrderSid(sid);
        this.installmentOrderCrudService.deleteByOrderSid(Long.valueOf(sid));
    }

    public void updateOrderPrice(OrderPriceVO orderPrice) {
        Order order = (Order)this.orderCrudService.findBySid(orderPrice.getOrderSid().longValue());
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{orderPrice.getOrderSid()});
        }
        if ("service".equals(order.getCategoryId()) && (StrUtils.isEmpty((String)orderPrice.getDepartCode()) || StrUtils.isEmpty((String)orderPrice.getBusinessCode()))) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10006);
        }
        order.setNoTaxPrice(orderPrice.getNoTaxPrice());
        order.setTaxPrice(orderPrice.getTaxPrice());
        order.setContainTaxPrice(orderPrice.getPayPrice());
        order.setTotalPrice(orderPrice.getTotalPrice());
        order.setPayPrice(orderPrice.getPayPrice());
        order.setProfitShare(orderPrice.getProfitShare());
        order.setContainTaxPrice(orderPrice.getPayPrice());
        order.setRemark(orderPrice.getRemark());
        order.setDepartCode(orderPrice.getDepartCode());
        order.setBusinessCode(orderPrice.getBusinessCode());
        order.setShipmentStartDate(orderPrice.getShipmentStartDate());
        order.setShipmentEndDate(orderPrice.getShipmentEndDate());
        order.setUserId(orderPrice.getUserId());
        order.setUserName(orderPrice.getUserName());
        this.orderCrudService.update((BaseEntity)order);
        this.orderUpdateMapper.updateCartOrderPrice(order.getCartCode());
        for (OrderDetailVO orderDetailVO : orderPrice.getOrderDetails()) {
            OrderDetail orderDetail = (OrderDetail)this.orderDetailCrudService.findBySid(orderDetailVO.getSid().longValue());
            if (null == orderDetail) continue;
            orderDetail.setAdjustmentTotal(orderPrice.getPayPrice());
            this.orderDetailCrudService.update((BaseEntity)orderDetail);
            this.orderDetailItemRepository.deleteByOrderDetailSid(orderDetailVO.getSid().longValue());
            for (OrderDetailItemVO itemVO : orderDetailVO.getItems()) {
                OrderDetailItem item = (OrderDetailItem)itemVO.doForward();
                item.setOrderDetailSid(orderDetailVO.getSid());
                item.setUnitPrice(item.getPayPrice().divide(new BigDecimal(orderDetail.getQuantity()), 2, 4));
                this.orderDetailItemCrudService.create((BaseEntity)item);
            }
        }
        this.orderLogService.updateOrderLog(order.getSid(), orderPrice.getReason());
    }

    @Transactional(rollbackFor={Exception.class})
    public void payOrder(long orderSid, BigDecimal payPrice, PaymentTypeEnum payType, OfflineVO offlineVO) {
        this.paymentService.createPayment(orderSid, payPrice, payType);
        this.orderUpdateMapper.updateOrderStatus(OrderStatusEnum.Paid.getValue(), orderSid);
        if (offlineVO != null) {
            if (offlineVO.getPayDate() != null) {
                this.updateOrderPayDate(orderSid, offlineVO.getPayDate());
            }
            if (offlineVO.getInvoice() != null) {
                this.invoiceCrudService.saveOrderInvoice(offlineVO.getInvoice(), (Order)this.orderCrudService.findBySid(orderSid));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void payOrder(long orderSid, BigDecimal payPrice, Payment payment, boolean success) {
        this.paymentRepository.deleteByOrderSidAndTradeStatus(orderSid, payment.getTradeStatus());
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setAmount(payment.getAmount() == null ? payPrice : payment.getAmount());
        this.paymentCrudService.create((BaseEntity)payment);
        if (success) {
            this.orderUpdateMapper.updateOrderStatus(1, orderSid);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void payOrderCart(OrderVO cart, List<OrderVO> orders, PaymentTypeEnum payType, OfflineVO offlineVO) {
        List payments = orders.stream().map(it -> this.paymentService.getPayment(it.getSid().longValue(), cart.getPayPrice(), payType)).collect(Collectors.toList());
        this.paymentMapper.deleteByCartCodeAndTradeStatus(cart.getCartCode(), TradeStatusEnum.TRADE_SUCCESS.name());
        this.paymentCrudService.saveAll(payments);
        this.orderUpdateMapper.updateCartOrderStatus(1, cart.getCartCode());
        if (offlineVO != null) {
            if (offlineVO.getInvoice() != null) {
                this.invoiceCrudService.saveShoppingInvoice(cart.getCartCode(), offlineVO.getInvoice());
            }
            if (offlineVO.getPayDate() != null) {
                this.updateOrderPayDate(cart.getSid().longValue(), offlineVO.getPayDate());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void payOrderCart(String cartCode, String tradeStatus, List<Payment> payments, boolean success) {
        this.paymentMapper.deleteByCartCodeAndTradeStatus(cartCode, tradeStatus);
        this.paymentCrudService.saveAll(payments);
        if (success) {
            this.orderUpdateMapper.updateCartOrderStatus(1, cartCode);
        }
    }

    public boolean checkOrderPaid(String orderCode) {
        OrderVO orderVO = this.orderQueryService.getOrderByOrderCode(orderCode);
        if (orderVO.getOrderStatus() == 1) {
            return true;
        }
        if (orderVO.getCartCode() == null) {
            this.orderFlowService.checkBaseOrder(orderVO);
            OrderFlowVO context = OrderFlowContextHolder.getContext();
            return "true".equalsIgnoreCase(context.getData().toString());
        }
        this.orderFlowService.checkCartOrder(orderVO.getSid().longValue(), orderVO.getCartCode());
        return true;
    }

    public void updateOrderStatus(long sid) {
        Order order = (Order)this.orderCrudService.findBySid(sid);
        if (order.getShopping() == 0) {
            if (order.getOrderStatus() == 0) {
                this.orderUpdateMapper.updateOrderStatusAndValid(3, true, order.getSid());
            } else if (order.getOrderStatus() == 3) {
                this.orderUpdateMapper.updateOrderStatus(0, order.getSid());
            }
        } else if (order.getShopping() == 1) {
            if (order.getOrderStatus() == 0) {
                this.orderUpdateMapper.updateCartOrderStatusAndValid(3, true, order.getCartCode());
            } else if (order.getOrderStatus() == 3) {
                this.orderUpdateMapper.updateCartOrderStatus(0, order.getCartCode());
            }
        }
    }

    public void updateOrderPayDate(long orderSid, LocalDateTime payDate) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (payDate.isBefore(order.getCreateDate())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_40001);
        }
        if (order.getCartCode() != null) {
            this.orderUpdateMapper.updateCartPayDate(payDate, order.getCartCode());
        } else {
            this.orderUpdateMapper.updatePayDate(payDate, Long.valueOf(orderSid));
        }
    }

    @Transactional
    public void cancelAndSendMail(long sid) {
        Order order = (Order)this.orderCrudService.findBySid(sid);
        if (order == null) {
            return;
        }
        if (order.getOrderType().intValue() == OrderTypeEnum.BILL.getValue()) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            logger.error(I18nError.OMC_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), request.getMethod(), request.getRequestURI(), UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)sid))}));
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_BNPL_DELETE_ERROR, new Object[]{sid});
        }
        List orders = new ArrayList<Order>();
        if (order.getShopping().intValue() == OrderShoppingEnum.COMMON.getCode()) {
            orders.add(order);
        } else {
            orders = this.orderRepository.findByCartCode(order.getCartCode());
        }
        TradeInfo entity = this.dwPayService.queryPayInfo(order.getOrderCode());
        if (null != entity && (TradeStatusEnum.TRADE_SUCCESS.name().equals(entity.getTradeStatus()) || TradeStatusEnum.TRADE_FINISHED.name().equals(entity.getTradeStatus()))) {
            logger.info("{}\u8ba2\u5355\u5df2\u652f\u4ed8\u5b8c\u6210\uff0c\u4e0d\u80fd\u5220\u9664", (Object)order.getOrderCode());
            return;
        }
        ArrayList mailOrders = new ArrayList();
        orders.forEach(temp -> {
            if (temp.getShopping() == 0) {
                MailOrder mailOrder = this.mailService.getMailOrder(temp.getSid());
                mailOrder.setTotalPrice(temp.getTotalPrice());
                mailOrders.add(mailOrder);
            }
        });
        this.cancelOrder(sid);
        mailOrders.forEach(mailOrder -> {
            this.mailService.sendEmailCancelOrder(mailOrder);
            this.mailService.sendEmailCancelOrder4Customer(mailOrder);
        });
    }

    public void updateOrderAccount(long sid) {
        Order order = (Order)this.orderCrudService.findBySid(sid);
        if (order.getShopping() == 0) {
            if (order.isAccountConfirm()) {
                this.orderUpdateMapper.updateOrderAccountUnConfirm(order.getSid());
            } else {
                this.orderUpdateMapper.updateOrderAccountConfirm(order.getSid());
            }
        }
    }

    public void cancelOrdersByTenant(Long tenantSid) {
        List preOrders;
        List orders = this.orderMapper.findTenantSimpleOrders(tenantSid);
        if (!orders.isEmpty()) {
            List orderSids = orders.stream().map(OrderVO::getSid).collect(Collectors.toList());
            List orderDetails = this.orderDetailMapper.findOrderDetails(orderSids);
            List orderDetailSids = orderDetails.stream().map(OrderDetailVO::getSid).collect(Collectors.toList());
            this.orderMapper.deleteInOrderSids(orderSids);
            this.orderDetailMapper.deleteInOrderSids(orderSids);
            if (!orderDetails.isEmpty()) {
                this.orderDetailMapper.deleteItemInOrderDetailSids(orderDetailSids);
            }
            this.paymentMapper.deleteInOrderSids(orderSids);
            this.orderMapper.deleteCouponInOrderSids(orderSids);
            this.orderCloudDeviceMapper.deleteInOrderSids(orderSids);
            this.orderMapper.deleteDeviceInOrderSids(orderSids);
            this.orderMapper.deleteBNPLInOrderSids(orderSids);
        }
        if (!(preOrders = this.preOrderMapper.getByTenants(tenantSid)).isEmpty()) {
            List preOrderSids = preOrders.stream().map(PreOrderVO::getSid).collect(Collectors.toList());
            this.preOrderMapper.deleteInSids(preOrderSids);
            this.preOrderMapper.deleteDetailInOrderSids(preOrderSids);
            this.orderCloudDeviceMapper.deleteInOrderSids(preOrderSids);
            this.orderMapper.deleteDeviceInOrderSids(preOrderSids);
        }
    }

    public void priceSecurityCheck4Normal(OrderVO orderVO) {
        try {
            HttpEntity request = this.getHttpEntity(orderVO);
            Integer orderType = orderVO.getOrderType();
            String url = this.envProperties.getGmcUri();
            switch (orderType) {
                case 1: 
                case 2: {
                    this.normalCheck(orderVO, url + "/api/cloudgoods/calculatetotalprice", request, false);
                    break;
                }
                case 3: {
                    this.normalCheck(orderVO, url + "/api/cloudgoods/calculatetotalprice/purchaseuser", request, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(orderType));
                }
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u3010priceSecurityCheck4Normal\u3011", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, e.getMessage());
        }
    }

    private void normalCheck(OrderVO orderVO, String url, HttpEntity<String> request, boolean isBuyMore) {
        TotalPriceVO resp = (TotalPriceVO)this.restTemplate.postForObject(url, request, TotalPriceVO.class, new Object[0]);
        if (resp == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "resp null");
        }
        UUID uuid = UUID.randomUUID();
        logger.info("\u3010normalCheck-{}\u3011frontend={}\uff1binner={}", new Object[]{uuid, JsonUtils.objToJson((Object)orderVO), JsonUtils.objToJson((Object)resp)});
        OrderDetailVO orderDetailVO = orderVO.getFirstOrderDetail();
        if (orderDetailVO == null || CollectionUtils.isEmpty((Collection)orderDetailVO.getItems())) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "frontend items pre check");
        }
        List items = orderDetailVO.getItems();
        BigDecimal adjustmentTotal = orderDetailVO.getAdjustmentTotal();
        BigDecimal payPrice = orderVO.getPayPrice();
        BigDecimal totalPrice = orderVO.getTotalPrice();
        BigDecimal discountPrice = orderVO.getDiscountPrice();
        BigDecimal noTaxPrice = orderVO.getNoTaxPrice();
        BigDecimal containTaxPrice = orderVO.getContainTaxPrice();
        BigDecimal taxPrice = orderVO.getTaxPrice();
        Integer quantity = orderDetailVO.getQuantity();
        if (this.priceAttrCompare(resp.getTotalPrice(), adjustmentTotal) || this.priceAttrCompare(resp.getTotalPrice(), payPrice) || this.priceAttrCompare(resp.getOriginalPrice(), totalPrice) || this.priceAttrCompare(resp.getDiscountPrice(), discountPrice) || this.priceAttrCompare(resp.getNoTaxPrice(), noTaxPrice) || this.priceAttrCompare(resp.getContainTaxPrice(), containTaxPrice) || this.priceAttrCompare(resp.getTaxPrice(), taxPrice) || !Objects.equals(resp.getOrderNumber(), quantity)) {
            HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            logger.error(I18nError.OMC_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), servletRequest.getMethod(), servletRequest.getRequestURI(), UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)orderVO))}));
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, uuid.toString());
        }
    }

    public void priceSecurityCheck4Pack(PackOrderVO body) {
        try {
            List orders = body.getOrders();
            HttpEntity request = this.getHttpEntity((OrderVO)orders.get(0));
            String url = this.envProperties.getGmcUri() + "/api/gmc/v2/goods/calculate/price/pack";
            PackPriceVO resp = (PackPriceVO)this.restTemplate.postForObject(url, (Object)request, PackPriceVO.class, new Object[0]);
            if (resp == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "resp null");
            }
            UUID uuid = UUID.randomUUID();
            logger.info("\u3010singleOrderCheck4Pack-{}\u3011frontend={}\uff1binner={}", new Object[]{uuid, JsonUtils.objToJson((Object)orders), JsonUtils.objToJson((Object)resp)});
            this.singleOrderCheck4Pack(resp, body, uuid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u3010priceSecurityCheck4Pack\u3011", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    private HttpEntity<String> getHttpEntity(OrderVO order) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)order.getPriceCalculate(), (MultiValueMap)headers);
        return request;
    }

    private void singleOrderCheck4Pack(PackPriceVO resp, PackOrderVO body, UUID uuid) {
        List orders = body.getOrders();
        List goodPrice = resp.getGoodPrice();
        if (CollectionUtils.isEmpty((Collection)goodPrice)) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "inner resp error.goodPrice empty");
        }
        Map<Long, OrderVO> collect = orders.stream().filter(o -> {
            if (o.getOrderDetails().size() != 1) {
                throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "getOrderDetails size not 1");
            }
            return true;
        }).collect(Collectors.toMap(k -> ((OrderDetailVO)k.getOrderDetails().get(0)).getStrategySid(), v -> v, (k1, k2) -> k1));
        if (!Objects.equals(resp.getUserCount(), body.getUserNumber()) || !Objects.equals(resp.getOrderNumber(), body.getQuantity())) {
            HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            logger.error(I18nError.OMC_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), servletRequest.getMethod(), servletRequest.getRequestURI(), UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)body))}));
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, uuid.toString());
        }
        for (TotalPriceVO totalPriceVO : goodPrice) {
            long sellingStrategySid = totalPriceVO.getSellingStrategySid();
            OrderVO order = collect.get(sellingStrategySid);
            if (order == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, uuid.toString());
            }
            this.overallCheck(order, uuid, totalPriceVO);
        }
    }

    public void priceSecurityCheck4Cart(CartOrderVO body) {
        try {
            List orders = body.getOrders();
            HttpEntity request = this.getHttpEntity((OrderVO)orders.get(0));
            String url = this.envProperties.getGmcUri() + "/api/cloudgoods/calculatetotalprice/shoppingcart";
            ShoppingCartPriceVO resp = (ShoppingCartPriceVO)this.restTemplate.postForObject(url, (Object)request, ShoppingCartPriceVO.class, new Object[0]);
            if (resp == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "resp null");
            }
            UUID uuid = UUID.randomUUID();
            logger.info("\u3010singleOrderCheck4Cart-{}\u3011frontend={}\uff1binner={}", new Object[]{uuid, JsonUtils.objToJson((Object)orders), JsonUtils.objToJson((Object)resp)});
            this.singleOrderCheck4Cart(resp, orders, uuid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u3010priceSecurityCheck4Cart\u3011", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    private void singleOrderCheck4Cart(ShoppingCartPriceVO resp, List<OrderVO> orders, UUID uuid) {
        List goodPrice = resp.getGoodsPriceDetail();
        if (CollectionUtils.isEmpty((Collection)goodPrice)) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "inner resp error.goodsPriceDetail empty");
        }
        ShoppingCartPriceVO.GoodsPriceDetail goodPriceFirst = (ShoppingCartPriceVO.GoodsPriceDetail)goodPrice.get(0);
        List sellingStrategyPrice = null;
        if (goodPriceFirst == null || CollectionUtils.isEmpty((Collection)(sellingStrategyPrice = goodPriceFirst.getSellingStrategyPrice()))) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "inner resp error.sellingStrategyPrice empty");
        }
        Map<String, OrderVO> collect = orders.stream().filter(o -> {
            if (o.getOrderDetails().size() != 1) {
                throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "getOrderDetails size not 1");
            }
            return true;
        }).collect(Collectors.toMap(k -> ((OrderDetailVO)k.getOrderDetails().get(0)).getGoodsSid() + "-" + ((OrderDetailVO)k.getOrderDetails().get(0)).getStrategySid(), v -> v, (k1, k2) -> k1));
        for (ShoppingCartPriceVO.GoodsPriceDetail good : goodPrice) {
            long goodsSid = good.getGoodsSid();
            List totalPriceVOS = good.getSellingStrategyPrice();
            for (TotalPriceVO totalPriceVO : totalPriceVOS) {
                long sellingStrategySid = totalPriceVO.getSellingStrategySid();
                OrderVO order = collect.get(goodsSid + "-" + sellingStrategySid);
                if (order == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, uuid.toString());
                }
                this.overallCheck(order, uuid, totalPriceVO);
            }
        }
    }

    private void overallCheck(OrderVO order, UUID uuid, TotalPriceVO totalPriceVOFirst) {
        OrderDetailVO orderDetailVO = order.getFirstOrderDetail();
        BigDecimal adjustmentTotal = orderDetailVO.getAdjustmentTotal();
        BigDecimal totalPrice = order.getTotalPrice();
        BigDecimal discountPrice = order.getDiscountPrice();
        BigDecimal noTaxPrice = order.getNoTaxPrice();
        BigDecimal containTaxPrice = order.getContainTaxPrice();
        BigDecimal taxPrice = order.getTaxPrice();
        BigDecimal payPrice = order.getPayPrice();
        Integer quantity = orderDetailVO.getQuantity();
        if (this.priceAttrCompare(totalPriceVOFirst.getTotalPrice(), adjustmentTotal) || this.priceAttrCompare(totalPriceVOFirst.getOriginalPrice(), totalPrice) || this.priceAttrCompare(totalPriceVOFirst.getDiscountPrice(), discountPrice) || this.priceAttrCompare(totalPriceVOFirst.getNoTaxPrice(), noTaxPrice) || this.priceAttrCompare(totalPriceVOFirst.getContainTaxPrice(), containTaxPrice) || this.priceAttrCompare(totalPriceVOFirst.getTaxPrice(), taxPrice) || this.priceAttrCompare(totalPriceVOFirst.getTotalPrice(), payPrice) || !Objects.equals(totalPriceVOFirst.getOrderNumber(), quantity)) {
            HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            logger.error(I18nError.OMC_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), servletRequest.getMethod(), servletRequest.getRequestURI(), UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)order))}));
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, uuid.toString());
        }
    }

    boolean priceAttrCompare(BigDecimal a, BigDecimal b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) != 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderTossstatus(TossstatusVO orderPrice) {
        if (!this.tossstatusSet.contains(orderPrice.getTossStatus())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS, "\u4e0d\u7b26\u5408\u8981\u6c42\u7684\u8ba2\u5355\u629b\u8f6c\u72b6\u6001");
        }
        this.orderMapper.updateOrderTossstatus(orderPrice.getSids(), orderPrice.getTossStatus());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderCheckBillBatch(List<Long> sids) {
        this.orderUpdateMapper.updateOrderCheckBillBatch(sids);
    }

    public void checkItemExist(Long sid) {
        Order order;
        List details = this.orderDetailCrudService.findByOrderSid(sid.longValue());
        List items = this.orderDetailMapper.findOrderDetailItems(details.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        String area = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? "T" : "C";
        this.miswsService.checkItem(items.stream().map(OrderDetailItemVO::getItemCode).collect(Collectors.toList()), area);
        if (items.stream().anyMatch(i -> i.getItemCode().startsWith("1") || i.getItemCode().startsWith("3") || i.getItemCode().startsWith("4") || i.getItemCode().startsWith("T3")) && null != (order = (Order)this.orderCrudService.findBySid(sid.longValue())) && (null == order.getShipmentStartDate() || null == order.getShipmentEndDate())) {
            throw new BusinessException("\u5408\u7ea6\u8d77\u8bab\u65e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<OrderVO> createAccessoryOrder(OrderVO orderVO, String cartCode) {
        ArrayList<OrderVO> accessoryOrders = new ArrayList<OrderVO>();
        List attachedGoodsVOS = this.goodsMapper.findAccessoryByStrategySid(orderVO.getFirstOrderDetail().getStrategySid());
        if (!CollectionUtils.isEmpty((Collection)attachedGoodsVOS)) {
            if (ObjectUtils.isEmpty((Object)cartCode)) {
                cartCode = this.orderCrudService.generateOrderCode(this.envProperties.getCountry(), "MATCC", "MATCT");
                Order originalOrder = (Order)this.orderCrudService.findBySid(orderVO.getSid().longValue());
                originalOrder.setCartCode(cartCode);
                this.orderCrudService.update((BaseEntity)originalOrder);
                OrderVO cart = this.generateCartOrder(orderVO);
                cart.setCartCode(cartCode);
                cart.setOrderCode(this.orderCrudService.generateOrderCode(this.envProperties.getCountry()));
                this.orderCrudService.create((BaseEntity)cart.doForward());
            }
            for (AttachedGoodsVO accessoryGoodsVO : attachedGoodsVOS) {
                OrderVO newOrder = new OrderVO();
                BeanUtils.copyProperties((Object)orderVO, (Object)newOrder);
                newOrder.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
                newOrder.setCartCode(cartCode);
                newOrder.setGoodsCode(accessoryGoodsVO.getAttachedGoodsCode());
                newOrder.setCategoryId(accessoryGoodsVO.getCategoryId());
                newOrder.setPackSid(Long.valueOf(0L));
                newOrder.setPayPrice(BigDecimal.ZERO);
                newOrder.setTotalPrice(BigDecimal.ZERO);
                newOrder.setDiscountPrice(BigDecimal.ZERO);
                newOrder.setContainTaxPrice(BigDecimal.ZERO);
                newOrder.setTaxPrice(BigDecimal.ZERO);
                newOrder.setRemark(null);
                newOrder.setOrderCode(null);
                OrderDetailVO detail = new OrderDetailVO();
                newOrder.setOrderDetails(Collections.singletonList(detail));
                GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(accessoryGoodsVO.getAttachedStrategySid().longValue());
                if (null == strategy) {
                    throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_ACCESSORY_STRATEGY_NULL, new Object[]{accessoryGoodsVO.getAttachedStrategySid()});
                }
                detail.setAdjustmentTotal(BigDecimal.ZERO);
                detail.setGoodsCode(accessoryGoodsVO.getAttachedGoodsCode());
                detail.setGoodsSid(accessoryGoodsVO.getAttachedGoodsSid());
                detail.setCategoryId(accessoryGoodsVO.getCategoryId());
                detail.setGoodsName(accessoryGoodsVO.getAttachedGoodsDisplayName());
                detail.setQuantity(orderVO.getFirstOrderDetail().getQuantity());
                detail.setUnitPrice(BigDecimal.ZERO);
                detail.setStrategySid(accessoryGoodsVO.getAttachedStrategySid());
                detail.setStrategyName(strategy.getName());
                detail.setItems(this.goodsMapper.findOrderDetailItem(strategy.getId().longValue()));
                newOrder.setUserNumber(strategy.getUsersNumber());
                newOrder.setRemark(I18nCode.ORDER_ACCESSORY_GOODS.getMessage(new Object[]{accessoryGoodsVO.getMainGoodsCode()}));
                newOrder.setBnpl(null);
                if (Boolean.FALSE.equals(strategy.getBnpl())) {
                    newOrder.setCredentialFileId(null);
                }
                this.createOrder(newOrder);
                accessoryOrders.add(newOrder);
            }
        }
        return accessoryOrders;
    }

    public OrderVO generateCartOrder(OrderVO temp) {
        OrderVO cartOrder = new OrderVO();
        cartOrder.setShopping(Integer.valueOf(1));
        cartOrder.setOrderType(temp.getOrderType());
        cartOrder.setOrderSource(temp.getOrderSource());
        cartOrder.setTenantSid(temp.getTenantSid());
        cartOrder.setTenantId(temp.getTenantId());
        cartOrder.setTenantName(temp.getTenantName());
        cartOrder.setUserId(temp.getUserId());
        cartOrder.setUserName(temp.getUserName());
        cartOrder.setEmail(temp.getEmail());
        cartOrder.setTelephone(temp.getTelephone());
        cartOrder.setEnterprise(temp.getEnterprise());
        cartOrder.setComment(temp.getComment());
        cartOrder.setTestTenant(temp.getTestTenant());
        cartOrder.setTossStatus(TossStatusEnum.Z.name());
        cartOrder.setNoTaxPrice(temp.getNoTaxPrice());
        cartOrder.setTaxPrice(temp.getTaxPrice());
        cartOrder.setContainTaxPrice(temp.getContainTaxPrice());
        cartOrder.setTotalPrice(temp.getTotalPrice());
        cartOrder.setPayPrice(temp.getPayPrice());
        cartOrder.setDiscountPrice(temp.getDiscountPrice());
        return cartOrder;
    }

    public PageSerializable<OMBillSearchResultVO> getBills4OM(OMBillSearchConditionVO condition) {
        PageMethod.startPage((int)condition.getPageNum(), (int)condition.getPageSize(), (String)condition.getOrderBy());
        List result = this.orderMapper.findBillOM(condition);
        Map tenantSimpleMap = this.iamService.getTenantSimplesMap(result.stream().map(OMBillSearchResultVO::getTenantId).distinct().collect(Collectors.toList()));
        result.forEach(a -> a.setTeamName(tenantSimpleMap.getOrDefault(a.getTenantId(), new CommonVO()).getTeamName()));
        return PageSerializable.of((List)result);
    }

    public void fillCredentialFileId(List<OrderVO> list) {
        Map<String, OrderVO> deviceCodeToOrderVoMap = list.stream().filter(vo -> GoodsCategoryEnum.isDevice((String)vo.getCategoryId())).filter(vo -> vo.getFirstOrderDetail() != null && StringUtils.hasLength((String)vo.getFirstOrderDetail().getDeviceCode())).collect(Collectors.toMap(vo -> vo.getFirstOrderDetail().getDeviceCode(), vo -> vo, (existing, replacement) -> existing));
        if (deviceCodeToOrderVoMap.isEmpty()) {
            return;
        }
        List deviceList = this.orderCloudDeviceRepository.findByCodeInAndDisabled(new ArrayList<String>(deviceCodeToOrderVoMap.keySet()), false);
        if (deviceList.isEmpty()) {
            return;
        }
        List orders = this.orderCrudService.findBySids(deviceList.stream().map(OrderCloudDevice::getOrderSid).collect(Collectors.toList()));
        Map<Long, String> orderSidToCredentialFileIdMap = orders.stream().filter(order -> StringUtils.hasLength((String)order.getCredentialFileId())).collect(Collectors.toMap(BaseEntity::getSid, Order::getCredentialFileId));
        deviceList.forEach(device -> {
            OrderVO orderVO;
            String credentialFileId = (String)orderSidToCredentialFileIdMap.get(device.getOrderSid());
            if (credentialFileId != null && (orderVO = (OrderVO)deviceCodeToOrderVoMap.get(device.getCode())) != null) {
                orderVO.setCredentialFileId(credentialFileId);
            }
        });
    }
}

