/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.omc.constant.enums.BnplOrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.InstallmentOrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryBillMonthDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryEntrustDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryExpensesMonthDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryPendingPaymentDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryProductRenewalDTO;
import com.digiwin.dap.middleware.omc.mapper.BnplOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.InstallmentOrderMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.order.OrderSummaryService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.util.DateUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrderSummaryServiceImpl
implements OrderSummaryService {
    private static final Logger logger = LoggerFactory.getLogger(OrderSummaryServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private BnplOrderMapper bnplOrderMapper;
    @Autowired
    private InstallmentOrderMapper installmentOrderMapper;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private CacService cacService;

    public OrderSummaryExpensesMonthDTO orderSummaryExpensesMonth(Long tenantSid) {
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfMonth = today.with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime startDateTime = firstDayOfMonth.atStartOfDay();
        LocalDateTime endDateTime = today.atTime(LocalTime.MAX);
        List orderVOList = this.orderMapper.findOrdersByCondition(tenantSid, DateUtil.getDateStr((LocalDateTime)startDateTime), DateUtil.getDateStr((LocalDateTime)endDateTime));
        if (CollectionUtils.isEmpty((Collection)orderVOList)) {
            return null;
        }
        ArrayList<OrderVO> paidOrderVOList = new ArrayList<OrderVO>();
        List orderSidList = orderVOList.stream().map(OrderVO::getSid).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orderSidList)) {
            List bnplOrderVOList = this.bnplOrderMapper.listBnplOrdersByOrderSidList(orderSidList);
            List bnplOrderSidList = bnplOrderVOList.stream().map(BnplOrderVO::getOrderSid).distinct().collect(Collectors.toList());
            List cartCodeList = orderVOList.stream().filter(x -> bnplOrderSidList.contains(x.getSid()) && StringUtils.hasLength((String)x.getCartCode())).map(OrderVO::getCartCode).collect(Collectors.toList());
            for (OrderVO orderVO : orderVOList) {
                if (Objects.equals(orderVO.getOrderType(), OrderTypeEnum.BILL.getValue()) || !Objects.equals(orderVO.getShopping(), OrderShoppingEnum.COMMON.getCode()) || bnplOrderSidList.contains(orderVO.getSid()) || cartCodeList.contains(orderVO.getCartCode()) || !Objects.equals(orderVO.getOrderStatus(), OrderStatusEnum.Paid.getValue())) continue;
                paidOrderVOList.add(orderVO);
            }
        }
        List billOrderVOList = orderVOList.stream().filter(x -> Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode())).collect(Collectors.toList());
        BigDecimal paidAmount = CollectionUtils.isEmpty(paidOrderVOList) ? BigDecimal.ZERO : paidOrderVOList.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal billedAmount = CollectionUtils.isEmpty(billOrderVOList) ? BigDecimal.ZERO : billOrderVOList.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = paidAmount.add(billedAmount);
        OrderSummaryExpensesMonthDTO dto = new OrderSummaryExpensesMonthDTO();
        dto.setAmount(amount);
        dto.setPaidAmount(paidAmount);
        dto.setBilledAmount(billedAmount);
        dto.setStartDateTime(startDateTime);
        dto.setEndDateTime(endDateTime);
        return dto;
    }

    public OrderSummaryPendingPaymentDTO orderSummaryPendingPayment(Long tenantSid) {
        List orderVOList = this.orderMapper.findOrdersByCondition(tenantSid, null, null);
        if (CollectionUtils.isEmpty((Collection)orderVOList)) {
            return null;
        }
        List unPaidCommonOrderVOList = orderVOList.stream().filter(x -> !Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getUserId(), UserUtils.getUserId()) && Objects.equals(x.getValid(), true) && Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode()) && (Objects.equals(x.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Unpaid.getValue()) && !StringUtils.hasLength((String)x.getCartCode()))).collect(Collectors.toList());
        List unPaidPackOrderVOList = orderVOList.stream().filter(x -> !Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getUserId(), UserUtils.getUserId()) && Objects.equals(x.getValid(), true) && Objects.equals(x.getShopping(), OrderShoppingEnum.SHOPPING_CART.getCode()) && (Objects.equals(x.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Unpaid.getValue()))).collect(Collectors.toList());
        List unPaidCommonbillOrderVOList = orderVOList.stream().filter(x -> Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode()) && (Objects.equals(x.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Unpaid.getValue())) && !StringUtils.hasLength((String)x.getCartCode())).collect(Collectors.toList());
        List unPaidPackbillOrderVOList = orderVOList.stream().filter(x -> Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getShopping(), OrderShoppingEnum.PACK.getCode()) && (Objects.equals(x.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Unpaid.getValue()))).collect(Collectors.toList());
        BigDecimal pendingAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(unPaidCommonbillOrderVOList)) {
            BigDecimal bnplUnPaidBillAmount = unPaidCommonbillOrderVOList.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            pendingAmount = bnplUnPaidBillAmount.add(pendingAmount);
        }
        if (!CollectionUtils.isEmpty(unPaidPackbillOrderVOList)) {
            BigDecimal unPaidBillAmount = unPaidPackbillOrderVOList.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            pendingAmount = unPaidBillAmount.add(pendingAmount);
        }
        OrderSummaryPendingPaymentDTO dto = new OrderSummaryPendingPaymentDTO();
        dto.setPendingAmount(pendingAmount);
        dto.setPendingBills(Integer.valueOf(unPaidPackbillOrderVOList.size() + unPaidCommonbillOrderVOList.size()));
        dto.setPendingOrders(Integer.valueOf(unPaidCommonOrderVOList.size() + unPaidPackOrderVOList.size()));
        return dto;
    }

    public OrderSummaryProductRenewalDTO orderSummaryProductRenewal(String tenantId) {
        List authorizationResultVOList;
        int expiryWithin30Days = 0;
        int expiryWithin7Days = 0;
        int expiry = 0;
        LocalDateTime now = LocalDateTime.now();
        CloudDeviceConditionVO cloudDeviceConditionVO = new CloudDeviceConditionVO();
        cloudDeviceConditionVO.setTenantId(tenantId);
        cloudDeviceConditionVO.setStates(Arrays.asList(2, 3));
        cloudDeviceConditionVO.setDisabled(Boolean.valueOf(false));
        List orderCloudDeviceVOS = this.orderCloudDeviceMapper.getDeviceClouds(cloudDeviceConditionVO, 1, 99999, "createDate desc");
        if (!CollectionUtils.isEmpty((Collection)orderCloudDeviceVOS)) {
            for (Object orderCloudDeviceVO : orderCloudDeviceVOS) {
                LocalDateTime expireDate = orderCloudDeviceVO.getExpireDate();
                if (Objects.isNull(expireDate)) continue;
                if (now.isAfter(expireDate)) {
                    long daysExpired = ChronoUnit.DAYS.between(expireDate.toLocalDate(), now);
                    if (daysExpired > 7L) continue;
                    ++expiry;
                    continue;
                }
                long daysUntilExpire = ChronoUnit.DAYS.between(now, expireDate);
                if (daysUntilExpire <= 7L) {
                    ++expiryWithin7Days;
                }
                if (daysUntilExpire > 30L) continue;
                ++expiryWithin30Days;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(authorizationResultVOList = this.cacService.queryAllAuthorization(tenantId)))) {
            for (AuthorizationResultVO authorizationResultVO : authorizationResultVOList) {
                LocalDateTime expireDate = authorizationResultVO.getExpiredTime();
                if (Objects.isNull(expireDate) || !authorizationResultVO.getCategoryId().equals("app") && !authorizationResultVO.getCategoryId().equals("pack")) continue;
                if (now.isAfter(expireDate)) {
                    long daysExpired = ChronoUnit.DAYS.between(expireDate.toLocalDate(), now);
                    if (daysExpired > 7L) continue;
                    ++expiry;
                    continue;
                }
                long daysUntilExpire = ChronoUnit.DAYS.between(now, expireDate);
                if (daysUntilExpire <= 7L) {
                    ++expiryWithin7Days;
                }
                if (daysUntilExpire > 30L) continue;
                ++expiryWithin30Days;
            }
        }
        OrderSummaryProductRenewalDTO orderSummaryProductRenewalDTO = new OrderSummaryProductRenewalDTO();
        orderSummaryProductRenewalDTO.setExpiry(Integer.valueOf(expiry));
        orderSummaryProductRenewalDTO.setExpiryWithin7Days(Integer.valueOf(expiryWithin7Days));
        orderSummaryProductRenewalDTO.setExpiryWithin30Days(Integer.valueOf(expiryWithin30Days));
        return orderSummaryProductRenewalDTO;
    }

    public OrderSummaryEntrustDTO orderSummaryEntrust(Long tenantSid) {
        LocalDate currentDate = LocalDate.now();
        LocalDate startDate = currentDate.minusMonths(18L);
        LocalDateTime startDateTime = startDate.atStartOfDay();
        LocalDateTime endDateTime = currentDate.atTime(LocalTime.MAX);
        OrderSummaryEntrustDTO dto = new OrderSummaryEntrustDTO();
        List bnplOrderVOList = this.bnplOrderMapper.findBnplOrdersByCondition(tenantSid, DateUtil.getDateStr((LocalDateTime)startDateTime), DateUtil.getDateStr((LocalDateTime)endDateTime));
        if (!CollectionUtils.isEmpty((Collection)bnplOrderVOList)) {
            List effectBnplOrderVOS = bnplOrderVOList.stream().filter(x -> BnplOrderStatusEnum.isActiveStatus((Integer)x.getStatus())).collect(Collectors.toList());
            List terminatedBnplOrderVOS = bnplOrderVOList.stream().filter(x -> Objects.equals(x.getStatus(), BnplOrderStatusEnum.TERMINATED.getCode())).collect(Collectors.toList());
            List finishBnplOrderVOS = bnplOrderVOList.stream().filter(x -> Objects.equals(x.getStatus(), BnplOrderStatusEnum.COMPLETED.getCode())).collect(Collectors.toList());
            dto.setEffectiveBnpl(Integer.valueOf(CollectionUtils.isEmpty(effectBnplOrderVOS) ? 0 : effectBnplOrderVOS.size()));
            dto.setTerminatedBnpl(Integer.valueOf(CollectionUtils.isEmpty(terminatedBnplOrderVOS) ? 0 : terminatedBnplOrderVOS.size()));
            dto.setFinishBnpl(Integer.valueOf(CollectionUtils.isEmpty(finishBnplOrderVOS) ? 0 : finishBnplOrderVOS.size()));
        } else {
            dto.setEffectiveBnpl(Integer.valueOf(0));
            dto.setTerminatedBnpl(Integer.valueOf(0));
        }
        List installmentOrderVOList = this.installmentOrderMapper.findInstallmentOrdersByTenantSid(tenantSid);
        if (!CollectionUtils.isEmpty((Collection)installmentOrderVOList)) {
            List effectInstallmentOrderVOS = installmentOrderVOList.stream().filter(x -> Objects.equals(x.getPeriodStatus(), InstallmentOrderStatusEnum.RESTART.getCode())).collect(Collectors.toList());
            List terminatedInstallmentOrderVOS = installmentOrderVOList.stream().filter(x -> Objects.equals(x.getPeriodStatus(), InstallmentOrderStatusEnum.TERMINATE.getCode())).collect(Collectors.toList());
            dto.setEffectiveInstallment(Integer.valueOf(CollectionUtils.isEmpty(effectInstallmentOrderVOS) ? 0 : effectInstallmentOrderVOS.size()));
            dto.setTerminatedInstallment(Integer.valueOf(CollectionUtils.isEmpty(terminatedInstallmentOrderVOS) ? 0 : terminatedInstallmentOrderVOS.size()));
        } else {
            dto.setEffectiveInstallment(Integer.valueOf(0));
            dto.setTerminatedInstallment(Integer.valueOf(0));
        }
        return dto;
    }

    public List<OrderSummaryBillMonthDTO> orderSummaryBillMonth(Long tenantSid) {
        LocalDate currentDate = LocalDate.now();
        LocalDate startDate = currentDate.minusMonths(6L);
        LocalDateTime startDateTime = startDate.atStartOfDay();
        LocalDateTime endDateTime = currentDate.atTime(LocalTime.MAX);
        List<Object> orderSummaryBillMonthDTOS = new ArrayList();
        for (int i = 0; i < 6; ++i) {
            LocalDate date = currentDate.minusMonths(i);
            OrderSummaryBillMonthDTO orderSummaryBillMonthDTO2 = new OrderSummaryBillMonthDTO();
            orderSummaryBillMonthDTO2.setDate(DateUtil.getDateStr((LocalDateTime)date.atStartOfDay(), (String)"yyyy-MM"));
            orderSummaryBillMonthDTOS.add(orderSummaryBillMonthDTO2);
        }
        orderSummaryBillMonthDTOS = orderSummaryBillMonthDTOS.stream().sorted(Comparator.comparing(OrderSummaryBillMonthDTO::getDate).reversed()).collect(Collectors.toList());
        List orderVOList = this.orderMapper.findOrdersByCondition(tenantSid, DateUtil.getDateStr((LocalDateTime)startDateTime), DateUtil.getDateStr((LocalDateTime)endDateTime));
        if (CollectionUtils.isEmpty((Collection)orderVOList)) {
            return orderSummaryBillMonthDTOS;
        }
        List billOrderVOList = orderVOList.stream().filter(x -> Objects.equals(x.getOrderType(), OrderTypeEnum.BILL.getValue()) && Objects.equals(x.getShopping(), OrderShoppingEnum.COMMON.getCode()) && (Objects.equals(x.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Unpaid.getValue()) || Objects.equals(x.getOrderStatus(), OrderStatusEnum.Paid.getValue()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(billOrderVOList)) {
            return orderSummaryBillMonthDTOS;
        }
        Map<String, List<OrderVO>> monthBillOrderMap = billOrderVOList.stream().collect(Collectors.groupingBy(x -> DateUtil.getDateStr((LocalDateTime)x.getCreateDate(), (String)"yyyy-MM")));
        orderSummaryBillMonthDTOS.forEach(orderSummaryBillMonthDTO -> {
            List orderVOS = (List)monthBillOrderMap.get(orderSummaryBillMonthDTO.getDate());
            BigDecimal billAmount = CollectionUtils.isEmpty((Collection)orderVOS) ? BigDecimal.ZERO : orderVOS.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderSummaryBillMonthDTO.setAmount(billAmount);
        });
        return orderSummaryBillMonthDTOS;
    }
}

