/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.order.impl;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderDetailCrudService;
import com.digiwin.dap.middleware.omc.dao.PaymentCrudService;
import com.digiwin.dap.middleware.omc.domain.LanguageResource;
import com.digiwin.dap.middleware.omc.domain.pay.TradeQueryResponse;
import com.digiwin.dap.middleware.omc.domain.remote.DwPayCallback;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrder;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderDetail;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.mapper.LanguageMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PaymentMapper;
import com.digiwin.dap.middleware.omc.repository.PaymentRepository;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import com.digiwin.dap.middleware.omc.support.remote.DwPayService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PaymentServiceImpl
implements PaymentService {
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private PaymentRepository paymentRepository;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private PaymentCrudService paymentCrudService;
    @Autowired
    private InstallmentOrderCrudService installmentOrderCrudService;
    @Autowired
    private OrderDetailCrudService orderDetailCrudService;
    @Autowired
    private LanguageMapper languageMapper;
    @Autowired
    private DwPayService dwPayService;

    public long createPayment(long orderSid, BigDecimal amount) {
        return this.createPayment(orderSid, amount, PaymentTypeEnum.Free);
    }

    public long createPayment(long orderSid, BigDecimal amount, PaymentTypeEnum payType) {
        this.paymentRepository.deleteByOrderSidAndTradeStatus(orderSid, TradeStatusEnum.TRADE_SUCCESS.name());
        return this.paymentCrudService.create((BaseEntity)this.getPayment(orderSid, amount, payType));
    }

    public long createPayment(long orderSid, BigDecimal amount, PaymentTypeEnum payType, String payMethod) {
        this.paymentRepository.deleteByOrderSidAndTradeStatus(orderSid, TradeStatusEnum.TRADE_SUCCESS.name());
        return this.paymentCrudService.create((BaseEntity)this.getPayment(orderSid, amount, payType, payMethod));
    }

    public long createPayment(long orderSid, BigDecimal amount, TradeQueryResponse tradeQuery) {
        Payment payment = new Payment(tradeQuery);
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setAmount(payment.getAmount() == null ? amount : payment.getAmount());
        return this.paymentCrudService.create((BaseEntity)payment);
    }

    public long createPayment(long orderSid, BigDecimal amount, TradeInfo trade) {
        Payment payment = new Payment(trade);
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setAmount(payment.getAmount() == null ? amount : payment.getAmount());
        return this.paymentCrudService.create((BaseEntity)payment);
    }

    public long createPayment(long orderSid, BigDecimal amount, DwPayCallback callback) {
        Payment payment = new Payment(callback);
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setAmount(payment.getAmount() == null ? amount : payment.getAmount());
        return this.paymentCrudService.create((BaseEntity)payment);
    }

    public StdData getPayUri(long orderSid, String backUrl, Boolean app) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (order == null || order.getOrderStatus() == 1) {
            return StdData.of((int)I18nCode.CODE_10001.getId(), (String)I18nCode.CODE_10001.getMessage(new Object[]{orderSid}));
        }
        InstallmentOrder installmentOrder = this.installmentOrderCrudService.findByOrderSid(Long.valueOf(orderSid));
        if (!Objects.isNull(installmentOrder)) {
            List orderDetails = this.orderDetailCrudService.findByOrderSid(orderSid);
            Long goodsSid = ((OrderDetail)orderDetails.get(0)).getGoodsSid();
            String goodsName = ((OrderDetail)orderDetails.get(0)).getGoodsName();
            List goodsNameList = this.languageMapper.findByDataSidInAndFieldName(Collections.singletonList(goodsSid), "goodsName");
            Map<Long, String> goodsNameMap = goodsNameList.stream().filter(a -> StringUtils.hasText((String)a.getContent()) && a.getLanguage().equals(LocaleContextHolder.getLocale().toLanguageTag())).collect(Collectors.toMap(LanguageResource::getDataSid, LanguageResource::getContent, (k1, k2) -> k1));
            if (goodsNameMap.containsKey(goodsSid)) {
                goodsName = goodsNameMap.get(goodsSid);
            }
            String subject = goodsName + "(" + installmentOrder.getGoodsCode() + ")";
            return this.dwPayService.queryPeriodPay(order.getOrderCode(), subject, installmentOrder.getPeriodAmt(), installmentOrder.getTotalPeriods(), null, backUrl);
        }
        return this.dwPayService.tradePay(order.getOrderCode(), order.getPayPrice(), backUrl, app);
    }

    public StdData payCheck(long orderSid) {
        Order order = (Order)this.orderCrudService.findBySid(orderSid);
        if (order == null || order.getOrderStatus() == 1) {
            return StdData.of((int)I18nCode.CODE_10001.getId(), (String)I18nCode.CODE_10001.getMessage(new Object[]{orderSid}));
        }
        TradeInfo entity = this.dwPayService.queryPayInfo(order.getOrderCode());
        if (entity == null) {
            return StdData.ok().build();
        }
        if (TradeStatusEnum.WAIT_BUYER_PAY.name().equals(entity.getTradeStatus())) {
            if (!"mpg".equalsIgnoreCase(entity.getPaymentType())) {
                return StdData.ok().build();
            }
            if ("VACC".equalsIgnoreCase(entity.getPayMethod())) {
                return StdData.of((int)I18nCode.CODE_40002.getId(), (String)I18nCode.CODE_40002.getMessage());
            }
            return StdData.of((int)I18nCode.CODE_40003.getId(), (String)I18nCode.CODE_40003.getMessage());
        }
        if (TradeStatusEnum.TRADE_CLOSED.name().equals(entity.getTradeStatus()) && "mpg".equalsIgnoreCase(entity.getPaymentType()) && "CREDIT".equalsIgnoreCase(entity.getPayMethod())) {
            return StdData.of((int)I18nCode.CODE_40006.getId(), (String)I18nCode.CODE_40006.getMessage());
        }
        return StdData.of((int)I18nCode.CODE_10001.getId(), (String)I18nCode.CODE_10001.getMessage(new Object[]{order.getOrderCode()}));
    }

    public Payment getPayment(long orderSid, BigDecimal amount, PaymentTypeEnum payType) {
        Payment payment = new Payment();
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setTradeStatus(TradeStatusEnum.TRADE_SUCCESS.name());
        payment.setAmount(amount);
        payment.setPayDate(LocalDateTime.now());
        payment.setPayType(payType.name());
        payment.setPayMethod(payType.name());
        EntityUtils.setCreateFields((BaseEntity)payment);
        return payment;
    }

    public Payment getPayment(long orderSid, BigDecimal amount, PaymentTypeEnum payType, String payMethod) {
        Payment payment = new Payment();
        payment.setOrderSid(Long.valueOf(orderSid));
        payment.setTradeStatus(TradeStatusEnum.TRADE_SUCCESS.name());
        payment.setAmount(amount);
        payment.setPayDate(LocalDateTime.now());
        payment.setPayType(payType.name());
        payment.setPayMethod(payMethod);
        EntityUtils.setCreateFields((BaseEntity)payment);
        return payment;
    }

    public void cancelCartPayment(String cartCode, String remark) {
        this.paymentMapper.cancelPayment(cartCode);
        this.orderUpdateMapper.updateCartOrderRemarkAndState(remark, cartCode);
    }
}

