/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.preorder.impl;

import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.OmcConstant;
import com.digiwin.dap.middleware.omc.constant.enums.AuthCategory;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.domain.remote.AttachedGoodsVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.request.GoodsAuthDO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDetailDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderAutoService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.service.preorder.impl.PreOrderAutoServiceImpl;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PreOrderAutoServiceImpl
implements PreOrderAutoService {
    private static final Logger logger = LoggerFactory.getLogger(PreOrderAutoServiceImpl.class);
    @Autowired
    private CacService cacService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private AuthService authService;

    public void autoPreOrder(GoodsAuthDO sourceGoodsAuth) {
        try {
            List platformGoods = this.goodsMapper.findPlatformByCodeAndStrategyCode(sourceGoodsAuth.getAppId(), sourceGoodsAuth.getStrategyCode());
            logger.info("\u81ea\u52a8\u5f00\u901a \u5546\u54c1code={}, \u9500\u552e\u65b9\u6848code={}, \u76f8\u4f9d\u5546\u54c1-\u9500\u552e\u65b9\u6848\u96c6\u5408:{}", new Object[]{sourceGoodsAuth.getAppId(), sourceGoodsAuth.getStrategyCode(), platformGoods.stream().map(g -> g.getCode() + "-" + g.getDefaultStrategySid()).collect(Collectors.toList())});
            for (Goods platform : platformGoods) {
                PlatformDate platformDate = this.checkPlatformNeedAuth(sourceGoodsAuth.getTenantId(), sourceGoodsAuth.getAppId(), platform.getCode());
                if (platformDate == null) continue;
                GoodsAuthDO goodsAuthDO = new GoodsAuthDO();
                BeanUtils.copyProperties((Object)sourceGoodsAuth, (Object)goodsAuthDO);
                goodsAuthDO.setAppId(platform.getCode());
                goodsAuthDO.setCategory(Integer.valueOf(4));
                goodsAuthDO.setStrategyCode(platform.getDefaultStrategyCode());
                goodsAuthDO.setSourceId("DirectAuthorization");
                goodsAuthDO.setSourceCode(sourceGoodsAuth.getAppId());
                goodsAuthDO.setMemo(String.format("\u5e73\u53f0\u81ea\u52a8\u6388\u6743 \u6765\u6e90\u5e94\u7528\u4e3a%s\u3010%s\u3011", sourceGoodsAuth.getAppId(), sourceGoodsAuth.getMemo()));
                goodsAuthDO.setEffectiveDateTime(platformDate.getTargetEffectiveTime());
                goodsAuthDO.setExpiredDateTime(platformDate.getTargetExpiredTime());
                goodsAuthDO.setBatchCode(sourceGoodsAuth.getBatchCode());
                this.authService.authAndNoticeAndPlatform(goodsAuthDO);
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u5f00\u901a\u5e73\u53f0\u5546\u54c1\u4eba\u5de5\u6388\u6743", (Throwable)e);
        }
    }

    public void autoPreOrderAccessory(GoodsAuthDO sourceGoodsAuth) {
        try {
            List attachedGoodsVOS = this.goodsMapper.findAttachedByStrategyCode(sourceGoodsAuth.getStrategyCode());
            for (AttachedGoodsVO accessoryGoodsVO : attachedGoodsVOS) {
                GoodsAuthDO goodsAuthDO = new GoodsAuthDO();
                BeanUtils.copyProperties((Object)sourceGoodsAuth, (Object)goodsAuthDO);
                goodsAuthDO.setAppId(accessoryGoodsVO.getAttachedGoodsCode());
                goodsAuthDO.setCategory(Integer.valueOf(AuthCategory.Accessory.ordinal()));
                logger.warn("\u4e3b\u5e94\u7528-\u65b9\u6848\uff1a{}-{}\uff0c\u642d\u914d\u5546\u54c1-\u65b9\u6848\uff1a{}-{}\uff0c\u6309\u7167\u642d\u914d\u5546\u54c1\u903b\u8f91\u8fdb\u884c\u6388\u6743\u5904\u7406", new Object[]{accessoryGoodsVO.getMainGoodsCode(), accessoryGoodsVO.getMainStrategyCode(), accessoryGoodsVO.getAttachedGoodsCode(), accessoryGoodsVO.getAttachedStrategyId()});
                goodsAuthDO.setStrategyCode(accessoryGoodsVO.getAttachedStrategyId());
                goodsAuthDO.setSourceId("DirectAuthorization");
                goodsAuthDO.setSourceCode(sourceGoodsAuth.getAppId());
                goodsAuthDO.setMemo(String.format("\u642d\u914d\u5546\u54c1 \u6765\u6e90\u5e94\u7528\u4e3a%s\u3010%s\u3011", sourceGoodsAuth.getAppId(), sourceGoodsAuth.getMemo()));
                goodsAuthDO.setBatchCode(sourceGoodsAuth.getBatchCode());
                this.authService.authAndNoticeAndPlatform(goodsAuthDO);
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u5f00\u901a\u642d\u914d\u5546\u54c1\u4eba\u5de5\u6388\u6743", (Throwable)e);
        }
    }

    public void autoPreOrderAccessory(PreOrderVO preOrderVO) {
        logger.info("\u81ea\u52a8\u5f00\u901a\u642d\u914d\u5546\u54c1\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)preOrderVO));
        List accessoryGoodsVOS = this.goodsMapper.findAccessoryByStrategySid(preOrderVO.getFirstOrderDetail().getStrategySid());
        for (AttachedGoodsVO accessoryGoodsVO : accessoryGoodsVOS) {
            try {
                this.createAccessoryPreorder(preOrderVO, accessoryGoodsVO);
            }
            catch (Exception e) {
                logger.error("\u81ea\u52a8\u5f00\u901a\u642d\u914d\u5546\u54c1", (Throwable)e);
            }
        }
    }

    public void autoPreOrder(OrderVO orderVO) {
        OrderDetailVO detailVO = orderVO.getFirstOrderDetail();
        List goods = this.goodsMapper.findPlatformByCodeAndStrategySid(orderVO.getGoodsCode(), detailVO.getStrategySid());
        logger.info("\u81ea\u52a8\u5f00\u901a \u5546\u54c1code={}, \u9500\u552e\u65b9\u6848sid={}, \u76f8\u4f9d\u5546\u54c1\u96c6\u5408:{}", new Object[]{orderVO.getGoodsCode(), detailVO.getStrategySid(), goods.stream().map(Goods::getCode).collect(Collectors.toList())});
        for (Goods platform : goods) {
            this.preOrder(platform, orderVO.getTenantSid(), orderVO.getTenantId(), orderVO.getTenantName(), orderVO.getOrderCode(), orderVO.getBusinessCode(), detailVO.getGoodsCode(), detailVO.getGoodsName(), null, null, orderVO.getCustomerId(), orderVO.getUserId(), orderVO.getBatchCode());
        }
    }

    public void autoPreOrder(PreOrderVO preOrderVO) {
        PreOrderDetailVO preOrderDetailVO = preOrderVO.getFirstOrderDetail();
        List goods = this.goodsMapper.findPlatformByCodeAndStrategySid(preOrderDetailVO.getGoodsCode(), preOrderDetailVO.getStrategySid());
        logger.info("\u81ea\u52a8\u5f00\u901a \u5546\u54c1code={}, \u9500\u552e\u65b9\u6848sid={}, \u76f8\u4f9d\u5546\u54c1-\u9500\u552e\u65b9\u6848\u96c6\u5408:{}", new Object[]{preOrderDetailVO.getGoodsCode(), preOrderDetailVO.getStrategySid(), goods.stream().map(g -> g.getCode() + "-" + g.getDefaultStrategySid()).collect(Collectors.toList())});
        for (Goods platform : goods) {
            this.preOrder(platform, preOrderVO.getTenantSid(), preOrderVO.getTenantId(), preOrderVO.getTenantName(), preOrderVO.getSourceBillCode(), preOrderVO.getBusinessCode(), preOrderDetailVO.getGoodsCode(), preOrderDetailVO.getGoodsName(), preOrderDetailVO.getEffectiveDateTime(), preOrderVO.getPotentialCustomerId(), preOrderVO.getCustomerId(), preOrderVO.getUserId(), preOrderVO.getBatchCode());
        }
    }

    public void autoPreOrderProcess(LocalDateTime localDateTime, PreOrderVO preOrderVO) {
        PreOrderDetailVO orderDetail = preOrderVO.getFirstOrderDetail();
        if (orderDetail.getEffectiveDateTime() == null || localDateTime.isBefore(orderDetail.getEffectiveDateTime())) {
            logger.warn("\u6388\u6743[{}]\u5f00\u59cb\u65f6\u95f4\u4e3a[{}],\u4e0d\u9700\u8981\u5f00\u901a\u5e73\u53f0/\u642d\u914d\u5546\u54c1\u6388\u6743", (Object)preOrderVO.getOrderCode(), (Object)orderDetail.getEffectiveDateTime());
            return;
        }
        this.autoPreOrderAccessory(preOrderVO);
        this.autoPreOrder(preOrderVO);
    }

    private void createAccessoryPreorder(PreOrderVO preOrderVO, AttachedGoodsVO accessoryGoodsVO) {
        String tenantName = preOrderVO.getTenantName();
        String tenantId = preOrderVO.getTenantId();
        Long tenantSid = preOrderVO.getTenantSid();
        PreOrderDetailVO detail = preOrderVO.getFirstOrderDetail();
        LocalDateTime effectiveDateTime = detail.getEffectiveDateTime();
        PreOrderDetailDTO detailDTO = new PreOrderDetailDTO();
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(accessoryGoodsVO.getAttachedStrategySid().longValue());
        detailDTO.setCategoryId(accessoryGoodsVO.getCategoryId());
        detailDTO.setGoodsSid(accessoryGoodsVO.getAttachedGoodsSid());
        detailDTO.setGoodsCode(accessoryGoodsVO.getAttachedGoodsCode());
        detailDTO.setGoodsName(accessoryGoodsVO.getAttachedGoodsDisplayName());
        detailDTO.setMainStrategy(Boolean.TRUE);
        detailDTO.setStrategySid(strategy.getId());
        detailDTO.setStrategyCode(strategy.getCode());
        detailDTO.setStrategyName(strategy.getName());
        detailDTO.setModules(strategy.obtainModules());
        detailDTO.setTotalUsageBound(strategy.getUsersNumber() > 0 ? strategy.getUsersNumber() : strategy.getUseCount());
        PlatformDate platformDate = this.calculateAccessory(tenantId, accessoryGoodsVO, effectiveDateTime, strategy);
        detailDTO.setEffectiveDateTime(platformDate.getTargetEffectiveTime());
        detailDTO.setExpiredDateTime(platformDate.getTargetExpiredTime());
        logger.info("\u642d\u914d\u5546\u54c1{}\u5f00\u901a,\u6388\u6743\u8d77\u8bab\u65f6\u95f4\u5bf9\u8c61{}", (Object)accessoryGoodsVO.getAttachedGoodsCode(), (Object)platformDate);
        PreOrderDTO preOrderDTO = new PreOrderDTO();
        preOrderDTO.setDetails(Collections.singletonList(detailDTO));
        preOrderDTO.setTenantSid(tenantSid);
        preOrderDTO.setTenantId(tenantId);
        preOrderDTO.setTenantName(tenantName);
        preOrderDTO.setOrderType(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue());
        preOrderDTO.setOrderSource(PreOrderSourceEnum.Accessory.name());
        preOrderDTO.setSourceBillCode(preOrderVO.getSourceBillCode());
        preOrderDTO.setBusinessCode(preOrderDTO.getBusinessCode());
        preOrderDTO.setRemark(I18nCode.PRE_ORDER_AUTO_AUTH_ACCESSORY.getMessage(new Object[]{accessoryGoodsVO.getMainGoodsCode()}));
        preOrderDTO.setSendEmail(Boolean.FALSE);
        preOrderDTO.setCreateById(I18nCode.PRE_ORDER_CREATE_BY_SYSTEM.getMessage());
        preOrderDTO.setPotentialCustomerId(preOrderDTO.getPotentialCustomerId());
        preOrderDTO.setCustomerId(preOrderDTO.getCustomerId());
        preOrderDTO.setShipmentScenario(String.valueOf(ShipmentScenarioEnum.OTHER.getValue()));
        preOrderDTO.setUserId(preOrderVO.getUserId());
        preOrderDTO.setBatchCode(preOrderVO.getBatchCode());
        this.preOrderService.save(preOrderDTO);
    }

    private PlatformDate calculateAccessory(String tenantId, AttachedGoodsVO accessoryGoodsVO, LocalDateTime effectiveDateTime, GoodsStrategy strategy) {
        PlatformDate platformDate = PlatformDate.of();
        AuthorizationVO goodsAuthInfo = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenantId, accessoryGoodsVO.getAttachedGoodsCode());
        if (null == goodsAuthInfo) {
            platformDate.setTargetEffectiveTime(effectiveDateTime);
            if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(accessoryGoodsVO.getCategoryId()) && !ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)strategy.getEnableTenancy()) || GoodsCategoryEnum.isAppCountOrNoControl((String)accessoryGoodsVO.getCategoryId(), (Integer)accessoryGoodsVO.getPaymentType())) {
                platformDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
            } else {
                platformDate.setTargetExpiredTime(effectiveDateTime.plusMonths(strategy.getTenancyPeriod().intValue()).with(LocalTime.of(23, 59, 59)));
            }
        } else {
            platformDate.setOriginEffectiveTime(goodsAuthInfo.getEffectiveTime());
            platformDate.setOriginExpiredTime(goodsAuthInfo.getExpiredTime());
            platformDate.setTargetEffectiveTime(goodsAuthInfo.getEffectiveTime());
            if (GoodsCategoryEnum.isAppCountOrNoControl((String)accessoryGoodsVO.getCategoryId(), (Integer)accessoryGoodsVO.getPaymentType())) {
                platformDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
            } else if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(accessoryGoodsVO.getCategoryId())) {
                if (!ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)strategy.getEnableTenancy())) {
                    platformDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
                } else {
                    platformDate.setTargetExpiredTime(effectiveDateTime.plusMonths(strategy.getTenancyPeriod().intValue()).with(LocalTime.of(23, 59, 59)));
                }
            } else {
                platformDate.setTargetExpiredTime(goodsAuthInfo.getExpiredTime().plusMonths(strategy.getTenancyPeriod().intValue()).with(LocalTime.of(23, 59, 59)));
            }
        }
        logger.warn("\u4e3b\u5e94\u7528-\u65b9\u6848\uff1a{}-{}\uff0c\u642d\u914d\u5546\u54c1-\u65b9\u6848\uff1a{}{}\uff0c\u6309\u7167\u642d\u914d\u5546\u54c1\u903b\u8f91\u8fdb\u884c\u6388\u6743\u5904\u7406", new Object[]{accessoryGoodsVO.getMainGoodsCode(), accessoryGoodsVO.getMainStrategyCode(), accessoryGoodsVO.getAttachedGoodsCode(), accessoryGoodsVO.getAttachedStrategyId()});
        return platformDate;
    }

    private void preOrder(Goods platform, Long tenantSid, String tenantId, String tenantName, String sourceOrderCode, String businessCode, String sourceGoodsCode, String sourceGoodsName, LocalDateTime effectiveDateTime, String potentialCustomerId, String customerId, String userId, String batchCode) {
        try {
            GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(platform.getDefaultStrategySid().longValue());
            platform.setSellingStrategy(strategy);
            PreOrderDetailDTO detailDTO = new PreOrderDetailDTO();
            detailDTO.setCategoryId(platform.getCategoryId());
            detailDTO.setGoodsSid(Long.valueOf(platform.getId()));
            detailDTO.setGoodsCode(platform.getCode());
            detailDTO.setGoodsName(platform.getDisplayName());
            detailDTO.setMainStrategy(Boolean.TRUE);
            detailDTO.setStrategySid(strategy.getId());
            detailDTO.setStrategyCode(strategy.getCode());
            detailDTO.setStrategyName(strategy.getName());
            detailDTO.setModules(strategy.obtainModules());
            detailDTO.setTotalUsageBound(strategy.getUsersNumber() > 0 ? strategy.getUsersNumber() : strategy.getUseCount());
            PlatformDate platformDate = this.checkPlatformNeedAuth(tenantId, sourceGoodsCode, platform.getCode());
            if (platformDate == null) {
                return;
            }
            if (effectiveDateTime != null) {
                detailDTO.setEffectiveDateTime(effectiveDateTime);
            } else {
                detailDTO.setEffectiveDateTime(platformDate.getTargetEffectiveTime());
            }
            detailDTO.setExpiredDateTime(platformDate.getTargetExpiredTime());
            PreOrderDTO preOrderDTO = new PreOrderDTO();
            preOrderDTO.setDetails(Collections.singletonList(detailDTO));
            preOrderDTO.setTenantSid(tenantSid);
            preOrderDTO.setTenantId(tenantId);
            preOrderDTO.setTenantName(tenantName);
            preOrderDTO.setOrderType(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue());
            preOrderDTO.setOrderSource(PreOrderSourceEnum.PlatformAuto.name());
            preOrderDTO.setSourceBillCode(sourceOrderCode);
            preOrderDTO.setBusinessCode(businessCode);
            preOrderDTO.setRemark(I18nCode.PRE_ORDER_AUTO_AUTH.getMessage(new Object[]{sourceGoodsName}));
            preOrderDTO.setSendEmail(Boolean.FALSE);
            preOrderDTO.setCreateById(I18nCode.PRE_ORDER_CREATE_BY_SYSTEM.getMessage());
            preOrderDTO.setPotentialCustomerId(potentialCustomerId);
            preOrderDTO.setCustomerId(customerId);
            preOrderDTO.setShipmentScenario(String.valueOf(ShipmentScenarioEnum.OTHER.getValue()));
            preOrderDTO.setUserId(userId);
            AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(preOrderDTO.getTenantId(), detailDTO.getGoodsCode());
            if (authorizationVO == null) {
                preOrderDTO.setOrderType(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue());
            } else {
                preOrderDTO.setOrderType(PreOrderTypeEnum.APP_CHANGES.getValue());
                detailDTO.setModules(authorizationVO.getEnabledModules());
                detailDTO.getModules().forEach(m -> m.setExpiredTime(platformDate.getTargetExpiredTime()));
                detailDTO.setOldTotalUsageBound(Integer.valueOf(authorizationVO.getTotalUserCount() > 0 ? authorizationVO.getTotalUserCount() : authorizationVO.getTotalUsage()));
                detailDTO.setOldEffectiveDateTime(authorizationVO.getEffectiveTime());
                detailDTO.setOldExpiredDateTime(authorizationVO.getExpiredTime());
                detailDTO.setOldModules(authorizationVO.getEnabledModules());
            }
            preOrderDTO.setBatchCode(batchCode);
            this.preOrderService.save(preOrderDTO);
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u5f00\u901a\u5e73\u53f0\u5546\u54c1\u4eba\u5de5\u6388\u6743", (Throwable)e);
        }
    }

    private PlatformDate checkPlatformNeedAuth(String tenantId, String goodsCode, String platformCode) {
        Goods platform = this.goodsMapper.findGoodsByCode(platformCode);
        PlatformDate authDate = PlatformDate.of();
        AuthorizationVO goodsAuthInfo = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenantId, goodsCode);
        if (goodsAuthInfo == null) {
            logger.error("\u83b7\u53d6\u79df\u6237{}\u5e94\u7528{}\u6388\u6743\u4fe1\u606f\u5931\u8d25", (Object)tenantId, (Object)goodsCode);
            return null;
        }
        authDate.setTargetEffectiveTime(goodsAuthInfo.getEffectiveTime());
        if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(platform.getCategoryId()) && !ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)platform.getEnableTenancy()) || GoodsCategoryEnum.isAppCountOrNoControl((String)platform.getCategoryId(), (Integer)platform.getPaymentType())) {
            authDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
        } else {
            authDate.setTargetExpiredTime(goodsAuthInfo.getExpiredTime());
        }
        AuthorizationVO platformAuthInfo = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenantId, platformCode);
        if (platformAuthInfo != null) {
            int compareTo = platformAuthInfo.getExpiredTime().withNano(0).compareTo(goodsAuthInfo.getExpiredTime().withNano(0));
            if (compareTo >= 0) {
                logger.info("\u79df\u6237[{}]\u6765\u6e90\u5546\u54c1[{}]\u7684\u5e73\u53f0\u5546\u54c1[{}]\u7684\u6388\u6743\u53d6\u6d88\u3002\u5df2\u6709\u6388\u6743\uff1a{} \u5927\u4e8e\u7b49\u4e8e\u5c06\u8981\u6388\u6743\uff1a{}", new Object[]{tenantId, goodsCode, platformCode, platformAuthInfo.getExpiredTime(), goodsAuthInfo.getExpiredTime()});
                authDate.setOriginEffectiveTime(platformAuthInfo.getEffectiveTime());
                authDate.setOriginExpiredTime(platformAuthInfo.getExpiredTime());
                authDate.setTargetEffectiveTime(platformAuthInfo.getEffectiveTime());
                if (GoodsCategoryEnum.isAppCountOrNoControl((String)platform.getCategoryId(), (Integer)platform.getPaymentType())) {
                    authDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
                } else if (GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(platform.getCategoryId())) {
                    if (!ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)platform.getEnableTenancy())) {
                        authDate.setTargetExpiredTime(OmcConstant.MAX_DATE_TIME);
                    }
                } else {
                    authDate.setTargetExpiredTime(platformAuthInfo.getExpiredTime());
                }
            } else {
                authDate.setOriginEffectiveTime(platformAuthInfo.getEffectiveTime());
                authDate.setOriginExpiredTime(platformAuthInfo.getExpiredTime());
            }
        }
        return authDate;
    }
}

