/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.preorder.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.OmcConstant;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsPaymentEnum;
import com.digiwin.dap.middleware.omc.constant.enums.ShippingTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderInitializeStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderDetailAuthorizationEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderSourceEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.PreOrderCrudService;
import com.digiwin.dap.middleware.omc.dao.PreOrderDetailCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.CopySubtenantPreOrderVO;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.PreOrderTenantAppVO;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationResultVO;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.remote.CustomerShippingVO;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDetailDTO;
import com.digiwin.dap.middleware.omc.domain.response.AuthorizationModuleVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.PreOrder;
import com.digiwin.dap.middleware.omc.entity.PreOrderDetail;
import com.digiwin.dap.middleware.omc.mapper.CodeMapper;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.repository.PreOrderDetailRepository;
import com.digiwin.dap.middleware.omc.repository.PreOrderRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderDeviceService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderAutoService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderDetailService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.cache.RedisService;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.BossiamService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.LmcService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.remote.MiswsService;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderContext;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderParameters;
import com.digiwin.dap.middleware.omc.support.validate.ParameterCheckService;
import com.digiwin.dap.middleware.omc.util.BatchCodeUtil;
import com.digiwin.dap.middleware.omc.util.CodeUtil;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PreOrderServiceImpl
implements PreOrderService {
    protected static final List<Integer> SEND_MAIL_DAY_LIST = Arrays.asList(1, 2, 3, 7, 30);
    private static final Logger logger = LoggerFactory.getLogger(PreOrderServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PreOrderRepository preOrderRepository;
    @Autowired
    private PreOrderDetailRepository preOrderDetailRepository;
    @Autowired
    private PreOrderCrudService preOrderCrudService;
    @Autowired
    private PreOrderDetailCrudService preOrderDetailCrudService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private CodeMapper codeMapper;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private AuthService authService;
    @Autowired
    private IamService iamService;
    @Autowired
    private OrderDeviceService orderDeviceService;
    @Autowired
    private PreOrderDetailService preOrderDetailService;
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private BossiamService bossiamService;
    @Autowired
    private PreOrderDetailMapper preOrderDetailMapper;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private ParameterCheckService parameterCheckService;
    @Autowired
    private LmcService lmcService;
    @Autowired
    private PreOrderAutoService preOrderAutoService;

    @Transactional
    public PreOrderVO save(PreOrderDTO dto) {
        dto.setOrderCode(this.generatePreOrderCode(dto.getOrderType(), dto.getOrderSource()));
        if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType())) {
            if (StrUtils.isEmpty((String)dto.getSourceBillCode())) {
                dto.setSourceBillCode(dto.getOrderCode());
            }
            AuthorizationVO auth = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(dto.getTenantId(), ((PreOrderDetailDTO)dto.getDetails().get(0)).getGoodsCode());
            if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType()) && null == auth) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_PRE_ORDER_ORDER_TYPE_ERROR, new Object[]{dto.getTenantId(), ((PreOrderDetailDTO)dto.getDetails().get(0)).getGoodsCode(), dto.getOrderCode()});
            }
        }
        if (PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(dto.getOrderType()) && PreOrderSourceEnum.DigiwinCloud.name().equals(dto.getOrderSource())) {
            dto.setRemark(I18nCode.PRE_ORDER_REMARK.getMessage());
        }
        if (dto.getOrderSource() == null) {
            if (PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(dto.getOrderType())) {
                dto.setOrderSource(PreOrderSourceEnum.BossManualAuthorization.name());
            } else if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType())) {
                dto.setOrderSource(PreOrderSourceEnum.BossAppChanges.name());
            }
        }
        this.fillShipmentScenario(dto);
        long preOrderSid = this.createPreOrderWithDtl(dto);
        PreOrderVO preOrderVO = this.findPreOrderAndDtlBySid(Long.valueOf(preOrderSid));
        preOrderVO.setUserId(dto.getUserId());
        preOrderVO.setBatchCode(Optional.ofNullable(dto.getBatchCode()).orElse(BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.SINGLE_PRE)));
        ResponseResult result = this.preOrderAuthorization(preOrderVO, LocalDateTime.now());
        if (!result.isSuccess()) {
            logger.error("\u4eba\u5de5\u6388\u6743[{}]\u5f00\u901a\u5931\u8d25\uff0c{}", (Object)PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()), (Object)result.getMessage());
        }
        return this.findPreOrderAndDtlBySid(Long.valueOf(preOrderSid));
    }

    private void fillShipmentScenario(PreOrderDTO dto) {
        if (PreOrderSourceEnum.SaaSShipmentAuthorization.name().equals(dto.getOrderSource()) || PreOrderSourceEnum.AutoShipment.name().equals(dto.getOrderSource())) {
            Integer shippingType = dto.getShippingType();
            if (ShippingTypeEnum.OTHER.getValue().equals(shippingType)) {
                dto.setShipmentScenario(ShipmentScenarioEnum.OTHER.getValue());
            } else if (ShippingTypeEnum.BORROWING.getValue().equals(shippingType)) {
                dto.setShipmentScenario(ShipmentScenarioEnum.BORROWING.getValue());
            } else if (ShippingTypeEnum.SHIPMENT.getValue().equals(shippingType)) {
                PreOrderDTO preOrderDTO = new PreOrderDTO();
                preOrderDTO.setTenantId(dto.getTenantId());
                preOrderDTO.setGoodsCode(((PreOrderDetailDTO)dto.getDetails().get(0)).getGoodsCode());
                List preOrders = this.preOrderMapper.getPreOrders(preOrderDTO);
                if (preOrders.stream().anyMatch(a -> ShipmentScenarioEnum.PURCHASE.getValue().equals(a.getShipmentScenario()))) {
                    dto.setShipmentScenario(ShipmentScenarioEnum.EXTENSION.getValue());
                } else {
                    dto.setShipmentScenario(ShipmentScenarioEnum.PURCHASE.getValue());
                }
            }
        }
    }

    public void editPreOrder(PreOrderDTO dto) {
        PreOrder preOrder = (PreOrder)this.preOrderCrudService.findBySid(dto.getSid().longValue());
        if (preOrder != null) {
            Optional.ofNullable(dto.getShipmentScenario()).ifPresent(arg_0 -> ((PreOrder)preOrder).setShipmentScenario(arg_0));
            Optional.ofNullable(dto.getRemark()).ifPresent(arg_0 -> ((PreOrder)preOrder).setRemark(arg_0));
            Optional.ofNullable(dto.getExtensionFlag()).ifPresent(arg_0 -> ((PreOrder)preOrder).setExtensionFlag(arg_0));
            Optional.ofNullable(dto.getRelateOrderCode()).ifPresent(arg_0 -> ((PreOrder)preOrder).setRelateOrderCode(arg_0));
            Optional.ofNullable(dto.getSourceBillCode()).ifPresent(arg_0 -> ((PreOrder)preOrder).setSourceBillCode(arg_0));
            this.preOrderCrudService.update((BaseEntity)preOrder);
        }
    }

    @Transactional
    public PreOrderVO checkAndSave(PreOrderDTO dto) {
        this.parameterCheckService.checkPreOrder(dto, Boolean.TRUE.booleanValue());
        return this.save(dto);
    }

    @Transactional
    public Long update(PreOrderDTO dto) {
        Long preOrderSid = dto.getSid();
        PreOrder oldPreOrder = (PreOrder)this.preOrderRepository.findById((Object)preOrderSid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_10009, new Object[]{preOrderSid}));
        dto.setOrderCode(oldPreOrder.getOrderCode());
        dto.setOrderType(oldPreOrder.getOrderType());
        dto.setOrderSource(oldPreOrder.getOrderSource());
        if (PreOrderSourceEnum.SaaSShipmentAuthorization.name().equals(oldPreOrder.getOrderSource())) {
            dto.setSourceBillCode(oldPreOrder.getSourceBillCode());
            dto.setShippingType(oldPreOrder.getShippingType());
            dto.setCompanyId(oldPreOrder.getCompanyId());
        }
        if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType()) && StrUtils.isEmpty((String)dto.getSourceBillCode())) {
            dto.setSourceBillCode(dto.getOrderCode());
        }
        BeanUtils.mergeDifferentTypeObject((Object)dto, (Object)oldPreOrder);
        this.preOrderCrudService.update((BaseEntity)oldPreOrder);
        this.preOrderDetailRepository.deleteByOrderSid(preOrderSid);
        dto.getDetails().forEach(preOrderDetailDTO -> {
            preOrderDetailDTO.setOrderSid(preOrderSid);
            preOrderDetailDTO.setAuthorization(Optional.ofNullable(preOrderDetailDTO.getAuthorization()).orElse(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue()));
            this.preOrderDetailCrudService.create((BaseEntity)preOrderDetailDTO.doForward());
        });
        PreOrderVO preOrderVO = this.findPreOrderAndDtlBySid(preOrderSid);
        preOrderVO.setBatchCode(BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.SINGLE_PRE));
        ResponseResult result = this.preOrderAuthorization(preOrderVO, LocalDateTime.now());
        if (!result.isSuccess()) {
            logger.error("\u5f00\u901a[{}]\u5931\u8d25\uff0c{}", (Object)PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()), (Object)result.getMessage());
        } else {
            this.cacService.syncRecord(preOrderVO);
        }
        return preOrderSid;
    }

    @Transactional
    public Long checkAndupdate(PreOrderDTO dto) {
        this.parameterCheckService.checkPreOrder(dto, Boolean.FALSE.booleanValue());
        return this.update(dto);
    }

    public PreOrderVO findPreOrderAndDtlBySid(Long sid) {
        PreOrder preOrder = (PreOrder)this.preOrderRepository.findById((Object)sid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_10009, new Object[]{sid}));
        PreOrderVO preOrderVO = new PreOrderVO();
        preOrderVO.doBackward((Object)preOrder);
        preOrderVO.setDetails(this.preOrderDetailService.getPreOrderDetails(sid));
        return preOrderVO;
    }

    public PreOrderVO findPreOrderAndDtlByOrderCode(String orderCode) {
        PreOrder preOrder = Optional.ofNullable(this.preOrderRepository.findByOrderCode(orderCode)).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_10009, new Object[]{orderCode}));
        PreOrderVO preOrderVO = new PreOrderVO();
        preOrderVO.doBackward((Object)preOrder);
        preOrderVO.setDetails(this.preOrderDetailService.getPreOrderDetails(Long.valueOf(preOrder.getSid())));
        return preOrderVO;
    }

    private long createPreOrderWithDtl(PreOrderDTO dto) {
        long preOrderSid = this.preOrderCrudService.create((BaseEntity)dto.doForward());
        List details = dto.getDetails();
        details.forEach(preOrderDetailDTO -> {
            preOrderDetailDTO.setOrderSid(Long.valueOf(preOrderSid));
            Optional.ofNullable(preOrderDetailDTO.getEffectiveDateTime()).ifPresent(x -> preOrderDetailDTO.setEffectiveDateTime(x.withNano(0)));
            preOrderDetailDTO.setAuthorization(Optional.ofNullable(preOrderDetailDTO.getAuthorization()).orElse(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue()));
            if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType())) {
                preOrderDetailDTO.setInitialize(Optional.ofNullable(preOrderDetailDTO.getInitialize()).orElse(OrderInitializeStatusEnum.SUCCESS.getValue()));
            } else {
                preOrderDetailDTO.setInitialize(Optional.ofNullable(preOrderDetailDTO.getInitialize()).orElse(OrderInitializeStatusEnum.UNINITIALIZED.getValue()));
            }
            this.preOrderDetailCrudService.create((BaseEntity)preOrderDetailDTO.doForward());
        });
        return preOrderSid;
    }

    private ResponseResult preOrderAuthorization(PreOrderVO preOrderVO, LocalDateTime effectiveDateStart) {
        effectiveDateStart = Optional.ofNullable(PreOrderContext.get()).map(PreOrderParameters::getExeTime).orElse(effectiveDateStart);
        ResponseResult responseResult = new ResponseResult(true);
        PreOrderDetailVO orderDetailVO = preOrderVO.getFirstOrderDetail();
        if (PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(preOrderVO.getOrderType()) && !effectiveDateStart.isBefore(orderDetailVO.getEffectiveDateTime())) {
            if (GoodsCategoryEnum.isApp((String)orderDetailVO.getCategoryId())) {
                responseResult = this.authorization(preOrderVO);
            } else if (GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(orderDetailVO.getCategoryId())) {
                Integer count = this.orderDeviceService.createOrderEquip(preOrderVO);
                logger.info("\u751f\u6210\u8bbe\u5907\u5e8f\u53f7\u6210\u529f\uff0c\u6570\u91cf[{}]", (Object)count);
                this.authorization(preOrderVO);
                responseResult = new ResponseResult(true, String.format("\u751f\u6210\u8bbe\u5907\u5e8f\u53f7\u6210\u529f\uff0c\u6570\u91cf[%s]", count));
            }
            if (responseResult.isSuccess() && PreOrderSourceEnum.DigiwinCloud.name().equals(preOrderVO.getOrderSource())) {
                Order order = this.orderCrudService.findByOrderCode(preOrderVO.getSourceBillCode());
                logger.info("\u4eba\u5de5\u6388\u6743,\u9f0e\u6377\u4e91\u8ba2\u5355\u7f16\u53f7\uff1a{}, \u8ba2\u5355\uff1a{}", (Object)preOrderVO.getSourceBillCode(), (Object)order);
                if (null != order) {
                    order.setAuthorization(true);
                    this.orderRepository.save((Object)order);
                }
            }
        } else if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(preOrderVO.getOrderType()) && !effectiveDateStart.isBefore(orderDetailVO.getEffectiveDateTime())) {
            responseResult = this.authorization(preOrderVO);
        }
        return responseResult;
    }

    public ResponseResult authorization(PreOrderVO preOrderVO) {
        String userToken = this.iamService.getUserToken(preOrderVO.getTenantId());
        ResponseResult authorizationResult = this.authService.authorization(preOrderVO, userToken);
        logger.info("\u4eba\u5de5\u6388\u6743[{}]\u5f00\u901a\u6388\u6743\u5b8c\u6210 {}", (Object)preOrderVO.getOrderCode(), (Object)authorizationResult);
        if (authorizationResult.isSuccess()) {
            ResponseResult initGoodsResult = this.authService.initGoods(preOrderVO, authorizationResult.getAuthInfo());
            logger.info("\u4eba\u5de5\u6388\u6743[{}]\u521d\u59cb\u5316\u5b8c\u6210 {}", (Object)preOrderVO.getOrderCode(), (Object)initGoodsResult);
        }
        return authorizationResult;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deletePreOrderAndDtlBySid(Long sid) {
        PreOrderVO preOrderVO = this.findPreOrderAndDtlBySid(sid);
        if (PreOrderDetailAuthorizationEnum.OPENED.getValue().equals(preOrderVO.getFirstOrderDetail().getAuthorization())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10010, new Object[]{PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()), preOrderVO.getOrderCode()});
        }
        this.preOrderRepository.deleteById((Object)sid);
        this.preOrderDetailRepository.deleteByOrderSid(sid);
    }

    public PageSerializable<PreOrderVO> getPreOrders(Integer pageNum, Integer pageSize, String orderBy, PreOrderDTO preOrderDTO) {
        List preOrders = this.preOrderMapper.getPreOrders(pageNum.intValue(), pageSize.intValue(), orderBy, preOrderDTO);
        return new PageSerializable(this.getPreOrderVOWithDtl(preOrders));
    }

    public PageSerializable<PreOrderVO> getPreOrdersBackend(Integer pageNum, Integer pageSize, String orderBy, PreOrderDTO preOrderDTO) {
        List preOrders = this.preOrderMapper.getPreOrdersBackend(pageNum.intValue(), pageSize.intValue(), orderBy, preOrderDTO);
        return new PageSerializable(this.getPreOrderVOWithDtl(preOrders));
    }

    public List<PreOrderVO> getPreOrderList(PreOrderDTO preOrderDTO) {
        List preOrders = this.preOrderMapper.getPreOrders(preOrderDTO);
        return this.getPreOrderVOWithDtl(preOrders);
    }

    public List<PreOrderVO> getPreOrderListExcludeDataPolicy(PreOrderDTO preOrderDTO) {
        List preOrders = this.preOrderMapper.getPreOrdersExcludeDataPolicy(preOrderDTO);
        return this.getPreOrderVOWithDtl(preOrders);
    }

    @Transactional
    public void manualAuthorization() {
        PreOrderDTO dto = new PreOrderDTO();
        dto.setAuthorization(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue());
        List preOrders = this.getPreOrderListExcludeDataPolicy(dto);
        if (!preOrders.isEmpty()) {
            preOrders.forEach(o -> {
                try {
                    this.updatePreOrder(o);
                    logger.info("\u5f00\u59cb\u5f00\u901a\u4eba\u5de5\u6388\u6743{}", (Object)JsonUtils.objToJson((Object)o));
                    this.preOrderAuthorization(o, LocalDateTime.now().plusMinutes(10L));
                    PreOrderContext.set((PreOrderParameters)new PreOrderParameters(LocalDateTime.now().plusMinutes(10L)));
                    if (!LocalDateTime.now().plusMinutes(10L).isBefore(o.getFirstOrderDetail().getEffectiveDateTime())) {
                        this.preOrderAutoService.autoPreOrderProcess(LocalDateTime.now().plusMinutes(10L), o);
                    }
                }
                catch (Exception e) {
                    logger.error("\u4eba\u5de5\u6388\u6743\u5b9a\u65f6\u5f00\u901a\u5931\u8d25\uff0csid:{}", (Object)o.getSid(), (Object)e);
                }
                finally {
                    PreOrderContext.clear();
                }
            });
        }
    }

    private void updatePreOrder(PreOrderVO o) {
        AuthorizationVO authorizationVos;
        PreOrderDetailVO dtl = o.getFirstOrderDetail();
        if (GoodsCategoryEnum.isApp((String)dtl.getCategoryId()) && (authorizationVos = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(o.getTenantId(), dtl.getGoodsCode())) != null && (dtl.getOldExpiredDateTime() == null || dtl.getOldEffectiveDateTime() == null || dtl.getOldTotalUsageBound() == null)) {
            dtl.setOldTotalUsageBound(Integer.valueOf(authorizationVos.getTotalUserCount() > 0 ? authorizationVos.getTotalUserCount() : authorizationVos.getTotalUsage()));
            dtl.setOldEffectiveDateTime(authorizationVos.getEffectiveTime());
            dtl.setOldExpiredDateTime(authorizationVos.getExpiredTime());
            dtl.setOldModules(authorizationVos.getEnabledModules());
            this.preOrderDetailMapper.updateOldAuthInfoBySid(dtl.getSid(), dtl.getOldTotalUsageBound(), dtl.getOldEffectiveDateTime(), dtl.getOldExpiredDateTime(), com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString((Object)dtl.getOldModules()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean savePreOrderForTest(PreOrderDTO preOrderDTO) {
        Goods goods = this.goodsMapper.findGoodsByCode(preOrderDTO.getGoodsCode());
        if (null == goods) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5546\u54c1[%s]\u4e0d\u5b58\u5728", preOrderDTO.getGoodsCode()));
        }
        GoodsStrategy strategy = this.goodsMapper.findFirstStrategyByGoodsCode(preOrderDTO.getGoodsCode());
        if (null == strategy) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5546\u54c1[%s]\u6ca1\u6709\u9500\u552e\u65b9\u6848", preOrderDTO.getGoodsCode()));
        }
        preOrderDTO.setDetailInfo(goods, strategy, preOrderDTO.getDaplcdp());
        PreOrderVO preOrderVO = this.save(preOrderDTO);
        this.preOrderAutoService.autoPreOrder(preOrderVO);
        return PreOrderDetailAuthorizationEnum.OPENED.getValue().equals(preOrderVO.getFirstOrderDetail().getAuthorization());
    }

    public String checkAllAcpPreOrder(List<PreOrderDTO> list) {
        logger.info("\u51fa\u901a\u5355\u6279\u91cf\u540c\u6b65\u5165\u53c2list {}", (Object)com.digiwin.dap.middleware.lmc.util.JsonUtils.writeValueAsString(list));
        this.parameterCheckService.checkAcpPreOrder(list);
        String errorMsg = null;
        List tenantSimples = this.iamService.getTenantSimples(list.stream().map(PreOrderDTO::getTenantId).collect(Collectors.toList()));
        for (PreOrderDTO dto : list) {
            Optional<CommonVO> optional;
            PreOrderDTO shipmentDTO = new PreOrderDTO();
            shipmentDTO.setOrderSources(Arrays.asList(PreOrderSourceEnum.SaaSShipmentAuthorization.name(), PreOrderSourceEnum.AutoShipment.name()));
            shipmentDTO.setSourceBillCodeEq(dto.getSourceBillCode());
            shipmentDTO.setAuthorizations(Arrays.asList(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue(), PreOrderDetailAuthorizationEnum.OPENED.getValue()));
            List orderVOList = this.getPreOrderListExcludeDataPolicy(shipmentDTO);
            if (!CollectionUtils.isEmpty((Collection)orderVOList)) {
                dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), I18nCode.PRE_ORDER_AUTO_SHIPMENT_ORDER_EXISTS.getMessage(new Object[]{dto.getSourceBillCode()})));
            }
            if ((optional = tenantSimples.stream().filter(x -> dto.getTenantId().equals(x.getId())).findFirst()).isPresent()) {
                CommonVO vo = optional.get();
                dto.setTenantSid(vo.getSid());
                dto.setTenantName(Optional.ofNullable(dto.getTenantName()).orElse(vo.getName()));
            } else {
                dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), I18nCode.CODE_TENANT_NOT_EXISTS_DIGIWIN_CLOUD.getMessage(new Object[]{dto.getTenantId()})));
            }
            PreOrderDetailDTO dtl = (PreOrderDetailDTO)dto.getDetails().get(0);
            dtl.setMainStrategy(Boolean.TRUE);
            this.checkGoods(dto, dtl);
            dto.setRemark(Optional.ofNullable(dto.getRemark()).filter(x -> StrUtils.isNotEmpty((String)x)).orElse(String.format("\u81ea\u52d5\u51fa\u8ca8\uff0c\u54c1\u865f\uff1a%s", dtl.getItemId())));
            AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(dto.getTenantId(), dtl.getGoodsCode());
            if (authorizationVO == null) {
                dto.setOrderType(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue());
            } else {
                dto.setOrderType(PreOrderTypeEnum.APP_CHANGES.getValue());
                dtl.setModules(authorizationVO.getEnabledModules());
                dtl.setOldTotalUsageBound(Integer.valueOf(authorizationVO.getTotalUserCount() > 0 ? authorizationVO.getTotalUserCount() : authorizationVO.getTotalUsage()));
                dtl.setOldEffectiveDateTime(authorizationVO.getEffectiveTime());
                dtl.setOldExpiredDateTime(authorizationVO.getExpiredTime());
                dtl.setOldModules(authorizationVO.getEnabledModules());
            }
            Optional.ofNullable(dtl.getModules()).ifPresent(x -> x.forEach(o -> o.setExpiredTime(dtl.getExpiredDateTime())));
            DictData dictData = this.dictDataService.selectDictData(new DictDataDTO(DictEnum.COMPANY.getId(), dto.getCompanyId()));
            Optional.ofNullable(dictData).ifPresent(x -> dto.setCompanyName(x.getDictValue()));
            if (!StrUtils.isNotEmpty((String)dto.getErrorMsg())) continue;
            errorMsg = this.buildErrorMsg(errorMsg, String.format("[%s(%s)]\u6388\u6b0a\u5931\u6557\uff0c\u5931\u6557\u539f\u56e0\uff1a%s ", dtl.getGoodsName(), dtl.getGoodsCode(), dto.getErrorMsg()));
        }
        return errorMsg;
    }

    public ResponseResult cancelAcpPreOrders(PreOrderTenantAppVO dto) {
        ResponseResult result = new ResponseResult(true);
        List preOrderDetailVOS = this.preOrderMapper.getPreOrderTenantPlatformAppVO(dto.getCompanyId(), dto.getSourceBillCode(), null, null, null);
        if (preOrderDetailVOS.isEmpty()) {
            String message = String.format("\u6765\u6e90\u5355\u636e%s\u4e0d\u5b58\u5728\u51fa\u8d27\u6388\u6743\u4fe1\u606f", dto.getSourceBillCode());
            logger.error(message);
            return new ResponseResult(false, message);
        }
        Boolean success = true;
        ArrayList<PreOrderDetailVO> preOrders = new ArrayList<PreOrderDetailVO>(preOrderDetailVOS.stream().collect(Collectors.toMap(PreOrderDetailVO::getGoodsCode, p -> p, (p1, p2) -> {
            LocalDateTime dateTime = p1.getModifyDate();
            LocalDateTime dateTime1 = p2.getModifyDate();
            if (dateTime == null || dateTime1 == null) {
                return dateTime != null ? p1 : p2;
            }
            return dateTime.isAfter(dateTime1) || dateTime.equals(dateTime1) ? p1 : p2;
        })).values());
        List validPreOrders = preOrders.stream().filter(p -> 2 != p.getAuthorization()).collect(Collectors.toList());
        try {
            if (validPreOrders.isEmpty()) {
                logger.warn("\u6765\u6e90\u5355\u636e{}\u5173\u8054\u7684\u51fa\u8d27\u90fd\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u53d6\u6d88\u51fa\u8d27", (Object)dto.getSourceBillCode());
            } else {
                List<PreOrderDetailVO> authPreOrders = validPreOrders.stream().filter(p -> 1 == p.getAuthorization()).collect(Collectors.toList());
                authPreOrders.forEach(a -> {
                    if (StrUtils.isNotEmpty((String)a.getCompanyId())) {
                        DictData dictData = this.dictDataService.selectDictData(new DictDataDTO(DictEnum.COMPANY.getId(), a.getCompanyId()));
                        Optional.ofNullable(dictData).ifPresent(x -> a.setCompanyName(x.getDictValue()));
                    }
                    a.setSourceBillCode(dto.getSourceBillCode());
                    a.setSourceId("SaasShipmentAuthorization");
                    a.setRemark(String.format("\u540e\u53f0\u53d6\u6d88\u51fa\u8d27\u5355{%s},{\u53d6\u6d88\u4eba\u5458\u5de5\u53f7{%s},\u59d3\u540d%s}", dto.getSourceBillCode(), dto.getModifyByCode(), dto.getModifyByName()));
                });
                result = this.cacService.obsoleteTenantAuth(authPreOrders);
                if (result != null) {
                    if (!result.isSuccess()) {
                        success = result.isSuccess();
                        List<String> errorGoodsCodes = Arrays.asList(result.getMessage().split(";"));
                        preOrders.forEach(p -> {
                            if (errorGoodsCodes.contains(p.getGoodsCode())) {
                                p.setErrorMsg("\u5931\u8d25,\u8be5\u7b14\u6388\u6743\u975e\u6700\u65b0\u4e00\u7b14\u5f02\u52a8\u8d44\u6599");
                            } else {
                                p.setErrorMsg("\u6210\u529f");
                            }
                        });
                    } else {
                        preOrders.forEach(p -> p.setErrorMsg("\u6210\u529f"));
                        this.preOrderMapper.obsoleteBySourceCode(validPreOrders.stream().map(PreOrderDetailVO::getPreOrderCode).collect(Collectors.toList()), dto.getMemo(), Long.valueOf(UserUtils.getUserSid()), UserUtils.getUserName());
                        this.preOrderDetailMapper.obsoleteBySourceCode(validPreOrders.stream().map(PreOrderDetailVO::getPreOrderCode).collect(Collectors.toList()), dto.getMemo(), null, dto.getModifyByCode());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u53d6\u6d88\u51fa\u8d27\u5931\u8d25:{}", (Object)ex.getMessage(), (Object)ex);
            success = false;
            preOrders.forEach(p -> p.setErrorMsg(String.format("\u5931\u8d25,\u4f5c\u5e9f\u6388\u6743\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u9f0e\u6377\u4e91\u7ba1\u7406\u4eba\u5458", new Object[0])));
            result = new ResponseResult(false, "\u53d6\u6d88\u51fa\u8d27\u5931\u8d25\uff0c\u56de\u6eda\u6388\u6743\u51fa\u9519");
        }
        this.mailService.sendEmailCancelAutoShipmentResult(preOrders, success.booleanValue());
        return result;
    }

    @Transactional
    public List<PreOrderVO> saveAllWithCheck(List<PreOrderDTO> list) {
        ArrayList<Long> sids = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        Optional<String> tenantId = list.stream().map(PreOrderDTO::getTenantId).findFirst();
        List auths = new ArrayList();
        if (tenantId.isPresent()) {
            auths = this.cacService.queryAllAuthorization(tenantId.get());
        }
        for (PreOrderDTO dto : list) {
            dto.setOrderType(Optional.ofNullable(dto.getOrderType()).orElse(PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue()));
            if (!PreOrderSourceEnum.canAddBatch((String)dto.getOrderSource())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u6279\u91cf\u65b0\u589e\u9884\u552e\u8ba2\u5355\u7684\u6765\u6e90\u4e0d\u5c5e\u4e8e[\u7ec4\u5408\u6388\u6743\u3001SaaS\u51fa\u8d27\u6388\u6743\u3001\u81ea\u52a8\u51fa\u8d27]");
            }
            this.fillShipmentScenario(dto);
            this.parameterCheckService.checkPreOrder(dto, Boolean.TRUE.booleanValue());
            dto.setOrderCode(this.generatePreOrderCode(dto.getOrderType(), dto.getOrderSource()));
            if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(dto.getOrderType()) && !auths.stream().anyMatch(a -> a.getTenantId().equals(dto.getTenantId()) && a.getCode().equals(((PreOrderDetailDTO)dto.getDetails().get(0)).getGoodsCode()))) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_PRE_ORDER_ORDER_TYPE_ERROR, new Object[]{dto.getTenantId(), ((PreOrderDetailDTO)dto.getDetails().get(0)).getGoodsCode(), dto.getOrderCode()});
            }
            long preOrderSid = this.createPreOrderWithDtl(dto);
            sids.add(preOrderSid);
        }
        ArrayList<PreOrderVO> preOrders = new ArrayList<PreOrderVO>();
        String batchCode = BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.BATCH_PRE);
        for (Long sid : sids) {
            PreOrderVO preOrderVO = this.findPreOrderAndDtlBySid(sid);
            preOrderVO.setBatchCode(batchCode);
            preOrderVO.setUserId((String)list.stream().filter(a -> a.getOrderCode().equals(preOrderVO.getOrderCode())).findFirst().map(PreOrderDTO::getUserId).orElse(null));
            ResponseResult result = this.preOrderAuthorization(preOrderVO, LocalDateTime.now());
            if (!result.isSuccess()) {
                logger.error("\u4eba\u5de5\u6388\u6743[{}]\u5f00\u901a\u5931\u8d25\uff0c{}", (Object)PreOrderTypeEnum.getName((Integer)preOrderVO.getOrderType()), (Object)result.getMessage());
                continue;
            }
            preOrders.add(preOrderVO);
        }
        return preOrders;
    }

    public PreOrderTenantAppVO getPreAuthWithTestTenant(PreOrderDTO dto) {
        List preOrderVOS = this.preOrderMapper.getPreOrderTenantAppVO(dto);
        if (CollectionUtils.isEmpty((Collection)preOrderVOS)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6765\u6e90\u5355\u53f7[%s]\u4e0d\u5b58\u5728\u6216\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u786e\u8ba4", dto.getSourceBillCode()));
        }
        PreOrderVO preOrderVO = (PreOrderVO)preOrderVOS.get(0);
        PreOrderTenantAppVO tenantAppVO = new PreOrderTenantAppVO();
        tenantAppVO.setTenantSid(preOrderVO.getTenantSid());
        tenantAppVO.setTenantId(preOrderVO.getTenantId());
        tenantAppVO.setTenantName(preOrderVO.getTenantName());
        tenantAppVO.setCustomerId(preOrderVO.getCustomerId());
        List authorizationResultVOS = Boolean.TRUE.equals(dto.getObsolete()) ? this.cacService.queryAllAuthorization(preOrderVO.getTenantId()) : new ArrayList();
        preOrderVOS.forEach(p -> {
            p.getDetails().sort(Comparator.comparing(PreOrderDetailVO::getCreateDate).reversed());
            p.getDetails().forEach(g -> {
                g.setCanObsolete(Boolean.valueOf(true));
                if (g.getAuthorization() == 1) {
                    AuthorizationResultVO existed;
                    g.changeModules();
                    if (!CollectionUtils.isEmpty((Collection)authorizationResultVOS) && (existed = (AuthorizationResultVO)authorizationResultVOS.stream().filter(a -> a.getCode().equals(g.getGoodsCode())).findFirst().orElse(null)) != null) {
                        boolean expireDate = existed.getExpiredTime().isAfter(g.getExpiredDateTime());
                        boolean totalCount = existed.getTotalUsage() > g.getTotalUsageBound();
                        boolean totalUsage = existed.getTotalUserCount() > g.getTotalUsageBound();
                        boolean enableModule = false;
                        for (AuthorizationModuleVO moduleVO : existed.getEnabledModules()) {
                            if (g.getModules().stream().anyMatch(mm -> mm.getId().equals(moduleVO.getId()))) continue;
                            enableModule = true;
                            break;
                        }
                        if (expireDate || totalCount || totalUsage || enableModule) {
                            g.setCanObsolete(Boolean.valueOf(false));
                        }
                        if (null == g.getStrategySid() || 0L == g.getStrategySid()) {
                            if (StringUtils.hasText((String)existed.getLastStrategyId())) {
                                g.setStrategySid(Long.valueOf(Long.parseLong(existed.getLastStrategyId())));
                            } else {
                                throw new BusinessException(String.format("\u5e94\u7528%s\u9500\u552e\u65b9\u6848\u4fe1\u606f\u4e3a\u7a7a", g.getGoodsCode()));
                            }
                        }
                    }
                }
                if (!tenantAppVO.getApps().stream().anyMatch(a -> a.getGoodsCode().equals(g.getGoodsCode()))) {
                    tenantAppVO.getApps().add(g);
                }
            });
        });
        if (!Boolean.TRUE.equals(dto.getObsolete())) {
            if (CollectionUtils.isEmpty((Collection)tenantAppVO.getApps())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6765\u6e90\u5355\u53f7[%s]\u751f\u6210\u7684\u51fa\u8d27\u4fe1\u606f\u672a\u5f00\u901a\uff0c\u65e0\u6cd5\u8fdb\u884c\u590d\u5236\uff0c\u8bf7\u786e\u8ba4", dto.getSourceBillCode()));
            }
            List subTenants = this.iamService.getMultiTestTenants(preOrderVO.getTenantSid().longValue());
            tenantAppVO.setSubtenants(subTenants);
        }
        return tenantAppVO;
    }

    public List<PreOrderTenantAppVO> getTenantSecretKey(PreOrderDTO dto) {
        List preOrderVOS = this.preOrderMapper.getPreOrderTenantAppVO(dto);
        if (CollectionUtils.isEmpty((Collection)preOrderVOS)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6765\u6e90\u5355\u53f7[%s]\u4e0d\u5b58\u5728\u6216\u5df2\u4f5c\u5e9f\u6216\u4e0d\u5b58\u5728\u53ef\u590d\u5236\u6388\u6743\u7801\u7684\u5546\u54c1\uff0c\u8bf7\u786e\u8ba4", dto.getSourceBillCode()));
        }
        Long sourceTenantSid = ((PreOrderVO)preOrderVOS.get(0)).getTenantSid();
        ArrayList sourceAppIds = new ArrayList();
        preOrderVOS.forEach(o -> sourceAppIds.addAll(o.getDetails().stream().map(PreOrderDetailVO::getGoodsCode).collect(Collectors.toList())));
        return this.iamService.getTenantSecretKey(sourceTenantSid.longValue(), sourceAppIds);
    }

    public void obsoleteBySourceCode(PreOrderTenantAppVO dto) {
        List<PreOrderDetailVO> authGoodsList;
        List preOrderVOS = this.preOrderMapper.getPreOrderTenantPlatformAppVO(dto.getCompanyId(), dto.getSourceBillCode(), null, Arrays.asList(PreOrderSourceEnum.SaaSShipmentAuthorization.name(), PreOrderSourceEnum.PlatformAuto.name(), PreOrderSourceEnum.AutoShipment.name()), Arrays.asList(PreOrderDetailAuthorizationEnum.NOT_OPENED.getValue(), PreOrderDetailAuthorizationEnum.OPENED.getValue()));
        if (Boolean.TRUE.equals(dto.getBackend())) {
            PreOrderDetailVO max = preOrderVOS.stream().max(Comparator.comparing(PreOrderDetailVO::getCreateDate)).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.OMC_ERROR_PRE_ORDER_CODE_NOT_EXIST));
            preOrderVOS.removeIf(l -> !l.equals(max));
            Goods goods = this.goodsMapper.findGoodsByCode(max.getGoodsCode());
            if (GoodsPaymentEnum.PersonMonth.ordinal() != goods.getPaymentType().intValue()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_ERROR_PRE_ORDER_PAYMENT_TYPE_WRONG);
            }
        }
        if (!CollectionUtils.isEmpty(authGoodsList = preOrderVOS.stream().filter(p -> PreOrderDetailAuthorizationEnum.OPENED.getValue().equals(p.getAuthorization())).collect(Collectors.toList()))) {
            authGoodsList.forEach(p -> {
                p.setSourceId(PreOrderSourceEnum.SaaSShipmentAuthorization.name());
                p.setSourceCode(p.getPreOrderCode());
                p.setRemark(String.format("\u51fa\u901a\u5355\u4f5c\u5e9f{%s},\u4f5c\u5e9f\u539f\u56e0:{%s}", p.getPreOrderCode(), dto.getMemo()));
            });
            ResponseResult result = this.cacService.obsoleteTenantAuth(authGoodsList);
            if (result != null && !result.isSuccess()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5e94\u7528%s\u6388\u6743\u975e\u6700\u65b0\u4e00\u7b14\u5f02\u52a8\u8d44\u6599", result.getMessage()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)preOrderVOS)) {
            this.preOrderMapper.obsoleteBySourceCode(preOrderVOS.stream().map(PreOrderDetailVO::getPreOrderCode).collect(Collectors.toList()), dto.getMemo(), Long.valueOf(UserUtils.getUserSid()), UserUtils.getUserName());
            this.preOrderDetailMapper.obsoleteBySourceCode(preOrderVOS.stream().map(PreOrderDetailVO::getPreOrderCode).collect(Collectors.toList()), dto.getMemo(), Long.valueOf(UserUtils.getUserSid()), UserUtils.getUserName());
        }
        if (Boolean.TRUE.equals(dto.getBackend()) && !CollectionUtils.isEmpty((Collection)preOrderVOS)) {
            this.lmcService.logObsoletePreOrder(authGoodsList);
        }
    }

    public PreOrderVO getMiswsCustomerInfo(PreOrderDTO dto) {
        PreOrderVO preOrderVO = new PreOrderVO();
        preOrderVO.setShippingType(dto.getShippingType());
        preOrderVO.setSourceBillCode(dto.getSourceBillCode());
        preOrderVO.setCompanyId(dto.getCompanyId());
        if (ShippingTypeEnum.SHIPMENT.getValue().equals(dto.getShippingType())) {
            CustomerShippingVO shippingVO = this.miswsService.getCustServiceData(dto);
            return this.getPreOrderVOByCustShipingVO(preOrderVO, shippingVO);
        }
        return preOrderVO;
    }

    public List<PreOrderVO> getCustServiceData(PreOrderDTO dto) {
        CustomerShippingVO shippingVO = this.miswsService.getCustCase(dto);
        if ("0".equals(shippingVO.getStatus())) {
            return Optional.ofNullable(shippingVO.getData()).orElse(Collections.emptyList()).stream().map(x -> {
                PreOrderVO vo = new PreOrderVO();
                vo.setCustomerId(x.getSrvNo());
                vo.setTenantName(x.getCustName());
                return vo;
            }).collect(Collectors.toList());
        }
        logger.error("\u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\u5f02\u5e38 {}", (Object)shippingVO);
        throw new BusinessException((ErrorHandler)I18nError.ERROR_PRE_ORDER_POTENTIAL_CUSTOMER_ID_NOT_EXISTED, new Object[]{dto.getPotentialCustomerId()});
    }

    public PreOrderVO getCustomerTenantInfo(PreOrderDTO dto) {
        TenantVO tenantVO = this.getCustomerTenantVO(dto.getCustomerId());
        PreOrderVO vo = new PreOrderVO();
        vo.setTenantSid(tenantVO.getSid());
        vo.setTenantId(tenantVO.getId());
        vo.setTenantName(tenantVO.getName());
        return vo;
    }

    public void updateSynchronized(List<Long> preOrderSids) {
        if (preOrderSids.isEmpty()) {
            return;
        }
        this.preOrderMapper.updateSynchronized(preOrderSids);
    }

    public List<PreOrderVO> getSynchronousPurchases() {
        List preOrderVOS = this.preOrderMapper.findSynchronousPurchases();
        return preOrderVOS;
    }

    private void checkGoods(PreOrderDTO dto, PreOrderDetailDTO dtl) {
        Goods goods = this.goodsMapper.findGoodsByCode(dtl.getGoodsCode());
        if (goods == null) {
            dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u61c9\u7528[%s]\u4e0d\u5b58\u5728\uff1b", dtl.getGoodsCode())));
        } else if (!OmcConstant.GoodsStatus.OnSale.getValue().equals(goods.getOnSale())) {
            dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u61c9\u7528[%s]\u672a\u4e0a\u67b6\uff1b", dtl.getGoodsCode())));
        } else if (!goods.getPurchaseSalesOpen().booleanValue()) {
            dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u5546\u54c1[%s]\u672a\u8bbe\u5b9a\u51fa\u8d27\u9500\u552e\u65b9\u6848\u8bbe\u5b9a\u65b9\u5f0f;", dtl.getGoodsCode())));
        } else {
            dtl.setGoodsSid(Long.valueOf(goods.getId()));
            dtl.setGoodsName(goods.getDisplayName());
            dtl.setCategoryId(goods.getCategoryId());
            if ((GoodsCategoryEnum.APP.name().equalsIgnoreCase(goods.getCategoryId()) || GoodsCategoryEnum.PLATFORM.name().equalsIgnoreCase(goods.getCategoryId()) || GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(goods.getCategoryId())) && (0 == goods.getPaymentType() || 3 == goods.getPaymentType())) {
                dtl.setExpiredDateTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
            }
            if (0 == goods.getPurchaseSalesType()) {
                if (0L == goods.getPurchaseStrategySid() || null == goods.getPurchaseStrategySid()) {
                    dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u5546\u54c1[%s]\u9500\u552e\u65b9\u6848\u8bbe\u5b9a\u65b9\u5f0f\u4e3a\u7ebf\u4e0b\u65b9\u6848\uff0c\u9ed8\u8ba4\u9500\u552e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a;", dtl.getGoodsCode())));
                } else {
                    GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(goods.getPurchaseStrategySid().longValue());
                    if (strategy == null) {
                        dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u5546\u54c1[%s]\u9884\u8bbe\u7684\u9500\u552e\u65b9\u6848[%s]\u4e0d\u5b58\u5728;", dtl.getGoodsCode(), goods.getPurchaseStrategySid())));
                    } else {
                        dtl.setStrategySid(strategy.getId());
                        dtl.setStrategyCode(strategy.getCode());
                        dtl.setStrategyName(strategy.getName());
                        dtl.setModules(strategy.obtainModules());
                    }
                }
            } else if (StrUtils.isEmpty((String)dtl.getItemId())) {
                dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u5546\u54c1[%s]\u9500\u552e\u65b9\u6848\u8bbe\u5b9a\u65b9\u5f0f\u4e3a\u54c1\u53f7\u5bf9\u5e94\u65b9\u6848\uff0c\u54c1\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a;", dtl.getGoodsCode())));
            } else {
                GoodsStrategy strategy = this.goodsMapper.findStrategyByCode(dtl.getItemId());
                if (strategy == null) {
                    dto.setErrorMsg(this.buildErrorMsg(dto.getErrorMsg(), String.format("\u5546\u54c1[%s]\u54c1\u53f7\u5bf9\u5e94\u7684\u9500\u552e\u65b9\u6848[%s]\u4e0d\u5b58\u5728;", dtl.getGoodsCode(), dtl.getItemId())));
                } else {
                    dtl.setStrategySid(strategy.getId());
                    dtl.setStrategyCode(strategy.getCode());
                    dtl.setStrategyName(strategy.getName());
                    dtl.setModules(strategy.obtainModules());
                }
            }
        }
    }

    private String buildErrorMsg(String oldErrorMsg, String errorMsg) {
        if (StrUtils.isEmpty((String)oldErrorMsg)) {
            return errorMsg;
        }
        return oldErrorMsg + errorMsg;
    }

    private PreOrderVO getPreOrderVOByCustShipingVO(PreOrderVO preOrderVO, CustomerShippingVO shippingVO) {
        if ("0".equals(shippingVO.getStatus())) {
            String srvNo = shippingVO.getSrvNo();
            Assert.hasText((String)srvNo, (String)String.format("\u6839\u636e\u6765\u6e90\u5355\u53f7[%s]\u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\uff0c\u8fd4\u56de\u5ba2\u670d\u4ee3\u53f7\u4e3a\u7a7a", preOrderVO.getSourceBillCode()));
            TenantVO tenantVO = this.getCustomerTenantVO(srvNo);
            preOrderVO.setTenantSid(tenantVO.getSid());
            preOrderVO.setTenantId(tenantVO.getId());
            preOrderVO.setTenantName(tenantVO.getName());
            preOrderVO.setPotentialCustomerId(StrUtils.isEmpty((String)tenantVO.getPotentialCustomerId()) ? shippingVO.getCustNo() : tenantVO.getPotentialCustomerId());
            preOrderVO.setCustomerId(srvNo);
            if (StrUtils.isNotEmpty((String)shippingVO.getMnDateStart())) {
                preOrderVO.setEffectiveDateTime(DateUtils.parseLocalDateTime((String)(shippingVO.getMnDateStart() + "000000"), (String)"yyyyMMddHHmmss"));
            }
            if (StrUtils.isNotEmpty((String)shippingVO.getMnDateEnd())) {
                preOrderVO.setExpiredDateTime(DateUtils.parseLocalDateTime((String)(shippingVO.getMnDateEnd() + "000000"), (String)"yyyyMMddHHmmss"));
            }
            return preOrderVO;
        }
        logger.error("\u67e5\u8be2\u5ba2\u6237\u51fa\u8d27\u8d44\u6599\u5f02\u5e38 {}", (Object)shippingVO);
        throw new BusinessException((ErrorHandler)I18nError.ERROR_PRE_ORDER_COMPANY_SOURCE_BILL_CODE_NOT_EXISTED, new Object[]{preOrderVO.getCompanyId(), preOrderVO.getSourceBillCode()});
    }

    private TenantVO getCustomerTenantVO(String customerId) {
        List tenantVOList = this.bossiamService.getBossTenants(Collections.singletonMap("customerId", customerId));
        if (CollectionUtils.isEmpty((Collection)tenantVOList)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_PRE_ORDER_CUSTOMER_ID_TENANT_NOT_EXISTED, new Object[]{customerId});
        }
        List successList = tenantVOList.stream().filter(x -> Integer.valueOf(1).equals(x.getConfirm()) && Objects.equals(customerId, x.getCustomerId()) && Boolean.FALSE.equals(x.getTestTenant()) && Long.valueOf(0L).equals(x.getSourceTenantSid()) && Arrays.asList(0, 1).contains(x.getEnterpriseType())).collect(Collectors.toList());
        if (successList.size() == 1) {
            return (TenantVO)successList.get(0);
        }
        if (successList.size() > 1) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_PRE_ORDER_MULTI_TENANT_EXISTED, new Object[]{customerId});
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_PRE_ORDER_CUSTOMER_ID_TENANT, new Object[]{customerId});
    }

    private List<PreOrderVO> getPreOrderVOWithDtl(List<PreOrderVO> preOrders) {
        preOrders.forEach(o -> o.setDetails(this.preOrderDetailService.getPreOrderDetails(o.getSid())));
        return preOrders;
    }

    private String generatePreOrderCode(Integer orderType, String source) {
        String preOrderCode;
        boolean isTW = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry());
        if (PreOrderTypeEnum.MANUAL_AUTHORIZATION.getValue().equals(orderType)) {
            preOrderCode = PreOrderSourceEnum.PlatformAuto.name().equalsIgnoreCase(source) ? (isTW ? this.generateCode("AUTOT") : this.generateCode("AUTOC")) : (isTW ? this.generateCode("AUTHT") : this.generateCode("AUTHC"));
        } else if (PreOrderTypeEnum.APP_CHANGES.getValue().equals(orderType)) {
            preOrderCode = isTW ? this.generateCode("CHAGT") : this.generateCode("CHAGC");
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u672a\u77e5\u7684\u9884\u552e\u8ba2\u5355\u7c7b\u578b");
        }
        return preOrderCode;
    }

    private String generateCode(String prefix) {
        long maxOrderCode;
        String key = CodeUtil.preOrderCodePrefix((String)prefix);
        long sequence = this.redisService.incrementMonth(key, 1L);
        if (sequence == 1L && (maxOrderCode = this.codeMapper.findMaxPreOrderCode(key)) >= sequence) {
            sequence = this.redisService.incrementMonth(key, maxOrderCode);
        }
        return key + String.format("%05d", sequence);
    }

    @Transactional
    public void copySubTenantPreOrders(CopySubtenantPreOrderVO input) {
        List subtenants = input.getSubTenant();
        List preOrdersToCopy = input.getGoodsVO();
        if (CollectionUtils.isEmpty((Collection)subtenants) || CollectionUtils.isEmpty((Collection)preOrdersToCopy)) {
            return;
        }
        for (PreOrderDetailVO preOrderDetailVO : preOrdersToCopy) {
            this.copyPreOrder(preOrderDetailVO, subtenants);
        }
    }

    private void copyPreOrder(PreOrderDetailVO preOrderDetailVO, List<CommonVO> subtenants) {
        String oldPreOrderCode = preOrderDetailVO.getPreOrderCode();
        PreOrder oldPreOrder = this.preOrderRepository.findByOrderCode(oldPreOrderCode);
        if (oldPreOrder == null) {
            return;
        }
        long oldPreOrderSid = oldPreOrder.getSid();
        List details = this.preOrderDetailRepository.findByOrderSid(Long.valueOf(oldPreOrderSid));
        for (CommonVO subtenant : subtenants) {
            PreOrder newPreOrder = new PreOrder();
            BeanUtils.mergeObject((Object)oldPreOrder, (Object)newPreOrder);
            newPreOrder.setSid(0L);
            newPreOrder.setCreateDate(null);
            newPreOrder.setCreateBy(Long.valueOf(0L));
            newPreOrder.setCreateById(null);
            newPreOrder.setTenantId(subtenant.getId());
            newPreOrder.setTenantName(subtenant.getName());
            newPreOrder.setTenantSid(subtenant.getSid());
            newPreOrder.setOrderCode(this.generatePreOrderCode(newPreOrder.getOrderType(), newPreOrder.getOrderSource()));
            newPreOrder.setSourceBillCode(oldPreOrderCode);
            newPreOrder.setShipmentScenario(ShipmentScenarioEnum.OTHER.getValue());
            long newPreOrderSid = this.preOrderCrudService.create((BaseEntity)newPreOrder);
            for (PreOrderDetail detail : details) {
                PreOrderDetail newDetail = new PreOrderDetail();
                BeanUtils.mergeObject((Object)detail, (Object)newDetail);
                newDetail.setCreateDate(null);
                newDetail.setCreateBy(Long.valueOf(0L));
                newDetail.setCreateById(null);
                newDetail.setSid(0L);
                newDetail.setOrderSid(Long.valueOf(newPreOrderSid));
                this.preOrderDetailCrudService.create((BaseEntity)newDetail);
            }
        }
    }
}

