/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.service.tenant.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.constant.enums.TenantChangeType;
import com.digiwin.dap.middleware.omc.dao.TenantCrudService;
import com.digiwin.dap.middleware.omc.domain.TenantVO;
import com.digiwin.dap.middleware.omc.domain.stream.TenantChangeInfoDTO;
import com.digiwin.dap.middleware.omc.entity.Tenant;
import com.digiwin.dap.middleware.omc.service.tenant.TenantSyncService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantSyncServiceImpl
implements TenantSyncService {
    private static final Logger logger = LoggerFactory.getLogger(TenantSyncServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private TenantCrudService tenantCrudService;

    public void syncTenantInfo(TenantChangeInfoDTO tenantChangeInfoDTO) {
        if (Objects.equals(TenantChangeType.DELETE.getValue(), tenantChangeInfoDTO.getChangeType())) {
            this.tenantCrudService.deleteById(tenantChangeInfoDTO.getTenantSid().longValue());
        } else {
            TenantVO tenantSimple = this.iamService.getTenantSimple(tenantChangeInfoDTO.getTenantId(), 0L);
            if (tenantSimple == null) {
                logger.error("syncTenantInfo, tenant {} not found", (Object)tenantChangeInfoDTO.getTenantId());
                return;
            }
            Tenant oldTenant = (Tenant)this.tenantCrudService.findById(tenantChangeInfoDTO.getTenantId());
            if (Objects.isNull(oldTenant) && tenantSimple.getTestTenant().booleanValue()) {
                Tenant newTenant = new Tenant();
                newTenant.setId(tenantSimple.getId());
                newTenant.setSid(tenantSimple.getSid().longValue());
                newTenant.setName(tenantSimple.getName());
                newTenant.setTestTenant(tenantSimple.getTestTenant().booleanValue());
                this.tenantCrudService.create((BaseEntity)newTenant);
            } else if (Objects.nonNull(oldTenant)) {
                if (!tenantSimple.getTestTenant().booleanValue()) {
                    this.tenantCrudService.deleteById(tenantChangeInfoDTO.getTenantSid().longValue());
                } else if (!oldTenant.isTestTenant()) {
                    oldTenant.setTestTenant(tenantSimple.getTestTenant().booleanValue());
                    this.tenantCrudService.update((BaseEntity)oldTenant);
                }
            }
        }
    }
}

