/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.domain.response.AuthorizationModuleVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.util.Assert;

@MappedTypes(value={List.class})
@MappedJdbcTypes(value={JdbcType.CLOB})
public class ModulesInfoStringTypeHandler
extends BaseTypeHandler<List<AuthorizationModuleVO>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<AuthorizationModuleVO> parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, JsonUtils.createObjectMapper().writeValueAsString(parameter));
        }
        catch (JsonProcessingException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public List<AuthorizationModuleVO> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getModuleInfoList(rs.getString(columnName));
    }

    public List<AuthorizationModuleVO> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getModuleInfoList(rs.getString(columnIndex));
    }

    public List<AuthorizationModuleVO> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getModuleInfoList(cs.getString(columnIndex));
    }

    private List<AuthorizationModuleVO> getModuleInfoList(String content) {
        try {
            Assert.isTrue((boolean)StrUtils.isNotEmpty((String)content), (String)"\u6a21\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ObjectMapper objectMapper = JsonUtils.createObjectMapper();
            return (List)objectMapper.readValue(content, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, AuthorizationModuleVO.class));
        }
        catch (IOException e) {
            throw new BusinessException((Throwable)e);
        }
    }
}

