/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.support.aspect;

import com.digiwin.dap.middleware.omc.domain.FieldValue;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.util.ExecutorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPolicyInterceptor
implements Interceptor {
    private static final int PARAM_COUNT = 4;
    private static final List<String> FILTERS = Arrays.asList("com.digiwin.dap.middleware.omc.mapper.OrderMapper.findOrders", "com.digiwin.dap.middleware.omc.mapper.OrderSyncMapper.findOrderDetails");
    private static final List<String> PRE_FILTER = Arrays.asList("com.digiwin.dap.middleware.omc.mapper.PreOrderMapper.getPreOrders", "com.digiwin.dap.middleware.omc.mapper.PreOrderMapper.getExportPreOrder", "com.digiwin.dap.middleware.omc.mapper.PreOrderMapper.getPreOrderTenantAppVO");
    private static final List<String> OPERATOR = Arrays.asList("and", "or");
    @Autowired
    private IamService iamService;

    private static String getSql(Object object, String operator) {
        if (null == object) {
            return "";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (0 == map.size()) {
                return "";
            }
            FieldValue fieldValue = new FieldValue(map);
            if (OPERATOR.contains(fieldValue.getFilterType())) {
                return DataPolicyInterceptor.getSql((Object)fieldValue.getFilterValue(), (String)fieldValue.getFilterType());
            }
            return fieldValue.getWhere();
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<String> values = new ArrayList<String>();
            for (Object o : list) {
                String temp = DataPolicyInterceptor.getSql(o, null);
                if ("".equals(temp)) continue;
                values.add(temp);
            }
            int size = values.size();
            if (size == 1) {
                return (String)values.get(0);
            }
            if (size > 1) {
                String temp = String.join((CharSequence)String.format(" %s ", operator), values);
                return String.format("(%s)", temp);
            }
        }
        return "";
    }

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String dataPolicySql = boundSql.getSql();
        if (FILTERS.contains(ms.getId())) {
            dataPolicySql = this.getDataFilterSql(dataPolicySql, "order");
        } else if (PRE_FILTER.contains(ms.getId())) {
            dataPolicySql = this.getDataFilterSql(dataPolicySql, "pre_order");
        }
        BoundSql dataBoundSql = new BoundSql(ms.getConfiguration(), dataPolicySql, boundSql.getParameterMappings(), parameter);
        Map additionalParameters = ExecutorUtil.getAdditionalParameter((BoundSql)boundSql);
        for (String key : additionalParameters.keySet()) {
            dataBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, dataBoundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private String getDataFilterSql(String sql, String program) {
        Map map = this.iamService.getRowPermission(UserUtils.getToken());
        if (CollectionUtils.isEmpty((Map)map)) {
            if ("order".equals(program)) {
                return sql + " and o.sid = 0";
            }
            return sql + " and po.sid=0 ";
        }
        boolean superadmin = Boolean.parseBoolean(String.valueOf(map.get("superadmin")));
        if (superadmin) {
            return sql;
        }
        Map rowMap = (Map)map.get("rowPermission");
        if (rowMap.isEmpty()) {
            if ("order".equals(program)) {
                return sql + " and o.sid = 0";
            }
            return sql + " and po.sid=0 ";
        }
        String temp = "order".equals(program) ? DataPolicyInterceptor.getSql((Object)rowMap, null).replace("goodsCode", "o.goodsCode").replace("categoryId", "o.categoryId").replace("productCode", "(select g.productcode from order_detail od join goods g on g.sid=od.goods_sid where od.order_sid=o.sid)") : DataPolicyInterceptor.getSql((Object)rowMap, null).replace("goodsCode", "pod.goods_code").replace("categoryId", "pod.category_id").replace("productCode", "g.productcode");
        return String.format("%s and %s", sql, temp);
    }
}

